/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.item.crossbow;

import dev.proststuff.archeries.item.bow.TieredBowItem;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TieredCrossbowItem
extends CrossbowItem {
    protected float velocity;
    protected float fireworkVelocity;
    protected float inaccuracy;
    protected float chargingTime;

    public TieredCrossbowItem(Item.Properties properties, float velocity, float inaccuracy, float fireworkVelocity, float chargingTime) {
        super(properties);
        this.velocity = velocity;
        this.inaccuracy = inaccuracy;
        this.fireworkVelocity = fireworkVelocity;
        this.chargingTime = chargingTime;
    }

    protected void shootProjectile(@NotNull LivingEntity shooter, @NotNull Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        Vector3f vector3f;
        velocity = projectile instanceof FireworkRocketEntity ? this.fireworkVelocity : this.velocity;
        inaccuracy = this.inaccuracy;
        if (target != null) {
            double d0 = target.getX() - shooter.getX();
            double d1 = target.getZ() - shooter.getZ();
            double d2 = Math.sqrt(d0 * d0 + d1 * d1);
            double d3 = target.getY(0.3333333333333333) - projectile.getY() + d2 * (double)0.2f;
            vector3f = TieredCrossbowItem.getProjectileShotVector(shooter, new Vec3(d0, d3, d1), angle);
        } else {
            Vec3 vec3 = shooter.getUpVector(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(angle * ((float)Math.PI / 180)), vec3.x, vec3.y, vec3.z);
            Vec3 vec31 = shooter.getViewVector(1.0f);
            vector3f = vec31.toVector3f().rotate((Quaternionfc)quaternionf);
        }
        projectile.shoot((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), velocity, inaccuracy);
        float f = TieredCrossbowItem.getShotPitch(shooter.getRandom(), index);
        this.playShootSound(shooter.level(), shooter.getX(), shooter.getY(), shooter.getZ(), f);
    }

    public void playShootSound(Level level, double x, double y, double z, float power) {
        level.playSound(null, x, y, z, SoundEvents.CROSSBOW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + power * 0.5f);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (tooltipFlag.isAdvanced()) {
            tooltipComponents.add(TieredBowItem.append("tooltip.archeries.velocity", this.velocity, 3.15f, false));
            if (this.fireworkVelocity > 0.0f) {
                tooltipComponents.add(TieredBowItem.append("tooltip.archeries.firework_velocity", this.fireworkVelocity, 1.6f, false));
            }
            tooltipComponents.add(TieredBowItem.append("tooltip.archeries.inaccuracy", this.inaccuracy, 1.0f, true));
            tooltipComponents.add(TieredBowItem.append("tooltip.archeries.max_draw_duration", this.chargingTime, 1.25f, true));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public int getDefaultProjectileRange() {
        return (int)((double)this.velocity / 3.15) * 8;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity shooter) {
        return TieredCrossbowItem.getChargeDuration(stack, shooter, Float.valueOf(this.getChargingTime(stack, shooter)));
    }

    @NotNull
    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        if (this.fireworkVelocity <= 0.0f) {
            return ARROW_ONLY;
        }
        return ARROW_OR_FIREWORK;
    }

    public float getChargingTime(ItemStack stack, LivingEntity shooter) {
        return this.chargingTime;
    }

    public static int getChargeDuration(ItemStack stack, LivingEntity shooter, Float initialChargingTime) {
        float f = EnchantmentHelper.modifyCrossbowChargingTime((ItemStack)stack, (LivingEntity)shooter, (float)initialChargingTime.floatValue());
        return Mth.floor((float)(f * 20.0f));
    }

    private static Vector3f getProjectileShotVector(LivingEntity shooter, Vec3 distance, float angle) {
        Vector3f vector3f = distance.toVector3f().normalize();
        Vector3f vector3f1 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)vector3f1.lengthSquared() <= 1.0E-7) {
            Vec3 vec3 = shooter.getUpVector(1.0f);
            vector3f1 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)vec3.toVector3f());
        }
        Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).rotateAxis(1.5707964f, vector3f1.x, vector3f1.y, vector3f1.z);
        return new Vector3f((Vector3fc)vector3f).rotateAxis(angle * ((float)Math.PI / 180), vector3f2.x, vector3f2.y, vector3f2.z);
    }

    private static float getShotPitch(RandomSource random, int index) {
        return index == 0 ? 1.0f : TieredCrossbowItem.getRandomShotPitch((index & 1) == 1, random);
    }

    private static float getRandomShotPitch(boolean isHighPitched, RandomSource random) {
        float f = isHighPitched ? 0.63f : 0.43f;
        return 1.0f / (random.nextFloat() * 0.5f + 1.8f) + f;
    }
}

