/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.item.crossbow;

import dev.proststuff.archeries.item.crossbow.TieredCrossbowItem;
import dev.proststuff.archeries.registry.ModDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WristbowItem
extends TieredCrossbowItem {
    public WristbowItem(Item.Properties properties, float velocity, float inaccuracy, float chargingTime) {
        super(properties, velocity, inaccuracy, 0.0f, chargingTime);
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() instanceof WristbowItem) {
            DataComponentType<Boolean> dataComponent = ModDataComponents.get(ModDataComponents.WRISTBOW_READY);
            boolean component = Boolean.TRUE.equals(stack.get(dataComponent));
            if (hand == InteractionHand.OFF_HAND && component || !CrossbowItem.isCharged((ItemStack)stack) || hand == InteractionHand.MAIN_HAND) {
                if (component) {
                    stack.set(dataComponent, (Object)false);
                }
                return super.use(level, player, hand);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public float getChargingTime(ItemStack stack, LivingEntity shooter) {
        if (shooter.getOffhandItem().is((Item)this)) {
            return super.getChargingTime(stack, shooter);
        }
        return super.getChargingTime(stack, shooter) * 4.0f;
    }
}

