/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.registry;

import dev.proststuff.archeries.Archeries;
import dev.proststuff.archeries.entity.CopperArrow;
import dev.proststuff.archeries.entity.EchoingArrow;
import dev.proststuff.archeries.entity.ExplosiveArrow;
import dev.proststuff.archeries.entity.SoftArrow;
import dev.proststuff.archeries.entity.TracerArrow;
import dev.proststuff.archeries.entity.WindChargedArrow;
import java.util.LinkedHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;

public class ModEntities {
    private static final LinkedHashMap<ResourceLocation, Supplier<EntityType<?>>> entityMap = new LinkedHashMap();
    public static final LinkedHashMap<Supplier<EntityType<?>>, EntityType<?>> REGISTERED = new LinkedHashMap();
    public static final Supplier<EntityType<ExplosiveArrow>> EXPLOSIVE_ARROW = ModEntities.registerArrow("explosive_arrow", EntityType.Builder.of(ExplosiveArrow::new, (MobCategory)MobCategory.MISC));
    public static final Supplier<EntityType<CopperArrow>> COPPER_ARROW = ModEntities.registerArrow("copper_arrow", EntityType.Builder.of(CopperArrow::new, (MobCategory)MobCategory.MISC));
    public static final Supplier<EntityType<SoftArrow>> SOFT_ARROW = ModEntities.registerArrow("soft_arrow", EntityType.Builder.of(SoftArrow::new, (MobCategory)MobCategory.MISC));
    public static final Supplier<EntityType<TracerArrow>> TRACER_ARROW = ModEntities.registerArrow("tracer_arrow", EntityType.Builder.of(TracerArrow::new, (MobCategory)MobCategory.MISC));
    public static final Supplier<EntityType<EchoingArrow>> ECHOING_ARROW = ModEntities.registerArrow("echoing_arrow", EntityType.Builder.of(EchoingArrow::new, (MobCategory)MobCategory.MISC));
    public static final Supplier<EntityType<WindChargedArrow>> WIND_CHARGED_ARROW = ModEntities.registerArrow("wind_charged_arrow", EntityType.Builder.of(WindChargedArrow::new, (MobCategory)MobCategory.MISC));

    public static <E extends Entity, T extends EntityType<E>> Supplier<T> registerArrow(String name, EntityType.Builder<E> builder) {
        return ModEntities.register(name, builder.sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(20));
    }

    public static <E extends Entity, T extends EntityType<E>> Supplier<T> register(String name, EntityType.Builder<E> builder) {
        ResourceLocation id = Archeries.id(name);
        Supplier<EntityType> supplier = () -> builder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)id));
        entityMap.put(id, supplier);
        return supplier;
    }

    public static void registerAll(BiConsumer<ResourceLocation, Supplier<EntityType<?>>> reg) {
        entityMap.forEach(reg);
    }

    public static <T> T get(Supplier<T> item) {
        return (T)REGISTERED.get(item);
    }
}

