/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.registry;

import dev.proststuff.archeries.Archeries;
import dev.proststuff.archeries.item.arrow.CopperArrowItem;
import dev.proststuff.archeries.item.arrow.EchoingArrowItem;
import dev.proststuff.archeries.item.arrow.ExplosiveArrowItem;
import dev.proststuff.archeries.item.arrow.SoftArrowItem;
import dev.proststuff.archeries.item.arrow.TracerArrowItem;
import dev.proststuff.archeries.item.arrow.WindChargedArrowItem;
import dev.proststuff.archeries.item.bow.SpectralBowItem;
import dev.proststuff.archeries.item.bow.TieredBowItem;
import dev.proststuff.archeries.item.bow.VelocitasEradicoBow;
import dev.proststuff.archeries.item.crossbow.TieredCrossbowItem;
import dev.proststuff.archeries.item.crossbow.WristbowItem;
import dev.proststuff.archeries.registry.ModDataComponents;
import java.util.LinkedHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;

public class ModItems {
    private static final LinkedHashMap<ResourceLocation, Supplier<Item>> itemMap = new LinkedHashMap();
    public static final LinkedHashMap<Supplier<Item>, Item> REGISTERED = new LinkedHashMap();
    public static Supplier<SpectralBowItem> SPECTRAL_BOW = ModItems.register("spectral_bow", SpectralBowItem::new, ModItems.property(5120).fireResistant().rarity(Rarity.RARE));
    public static Supplier<TieredBowItem> VELOCITAS_ERADICO_BOW = ModItems.register("velocitas_eradico_bow", VelocitasEradicoBow::new, ModItems.property(1).fireResistant().rarity(Rarity.RARE));
    public static Supplier<TieredBowItem> COPPER_BOW = ModItems.register("copper_bow", properties -> new TieredBowItem((Item.Properties)properties, 3.5f, 0.875f, 20), ModItems.property(576));
    public static Supplier<TieredBowItem> IRON_BOW = ModItems.register("iron_bow", properties -> new TieredBowItem((Item.Properties)properties, 4.0f, 0.75f, 20), ModItems.property(768));
    public static Supplier<TieredBowItem> GOLDEN_BOW = ModItems.register("golden_bow", properties -> new TieredBowItem((Item.Properties)properties, 4.5f, 0.75f, 16), ModItems.property(960));
    public static Supplier<TieredBowItem> DIAMOND_BOW = ModItems.register("diamond_bow", properties -> new TieredBowItem((Item.Properties)properties, 5.0f, 0.5f, 16), ModItems.property(1152));
    public static Supplier<TieredBowItem> NETHERITE_BOW = ModItems.register("netherite_bow", properties -> new TieredBowItem((Item.Properties)properties, 5.5f, 0.25f, 12), ModItems.property(1536).fireResistant());
    public static Supplier<TieredBowItem> LONGBOW = ModItems.register("longbow", properties -> new TieredBowItem((Item.Properties)properties, 5.0f, 1.0f, 24), ModItems.property(480));
    public static Supplier<TieredBowItem> COPPER_LONGBOW = ModItems.register("copper_longbow", properties -> new TieredBowItem((Item.Properties)properties, 5.5f, 0.875f, 24), ModItems.property(720));
    public static Supplier<TieredBowItem> IRON_LONGBOW = ModItems.register("iron_longbow", properties -> new TieredBowItem((Item.Properties)properties, 6.0f, 0.75f, 28), ModItems.property(960));
    public static Supplier<TieredBowItem> GOLDEN_LONGBOW = ModItems.register("golden_longbow", properties -> new TieredBowItem((Item.Properties)properties, 6.5f, 0.75f, 32), ModItems.property(1200));
    public static Supplier<TieredBowItem> DIAMOND_LONGBOW = ModItems.register("diamond_longbow", properties -> new TieredBowItem((Item.Properties)properties, 7.5f, 0.5f, 32), ModItems.property(1440));
    public static Supplier<TieredBowItem> NETHERITE_LONGBOW = ModItems.register("netherite_longbow", properties -> new TieredBowItem((Item.Properties)properties, 8.0f, 0.25f, 48), ModItems.property(1920).fireResistant());
    public static Supplier<TieredCrossbowItem> COPPER_CROSSBOW = ModItems.register("copper_crossbow", properties -> new TieredCrossbowItem((Item.Properties)properties, 3.65f, 0.8f, 1.6f, 1.25f), ModItems.property(698));
    public static Supplier<TieredCrossbowItem> IRON_CROSSBOW = ModItems.register("iron_crossbow", properties -> new TieredCrossbowItem((Item.Properties)properties, 4.15f, 0.8f, 1.7f, 1.125f), ModItems.property(930));
    public static Supplier<TieredCrossbowItem> GOLDEN_CROSSBOW = ModItems.register("golden_crossbow", properties -> new TieredCrossbowItem((Item.Properties)properties, 4.65f, 0.75f, 1.8f, 1.0f), ModItems.property(1163));
    public static Supplier<TieredCrossbowItem> DIAMOND_CROSSBOW = ModItems.register("diamond_crossbow", properties -> new TieredCrossbowItem((Item.Properties)properties, 5.15f, 0.5f, 1.9f, 0.875f), ModItems.property(1395));
    public static Supplier<TieredCrossbowItem> NETHERITE_CROSSBOW = ModItems.register("netherite_crossbow", properties -> new TieredCrossbowItem((Item.Properties)properties, 5.65f, 0.25f, 2.0f, 0.75f), ModItems.property(1860).fireResistant());
    public static Supplier<TieredCrossbowItem> HEAVY_CROSSBOW = ModItems.register("heavy_crossbow", properties -> new TieredCrossbowItem((Item.Properties)properties, 5.65f, 1.0f, 0.0f, 1.5f), ModItems.property(720));
    public static Supplier<TieredCrossbowItem> COPPER_HEAVY_CROSSBOW = ModItems.register("copper_heavy_crossbow", properties -> new TieredCrossbowItem((Item.Properties)properties, 6.15f, 0.8f, 0.0f, 1.625f), ModItems.property(900));
    public static Supplier<TieredCrossbowItem> IRON_HEAVY_CROSSBOW = ModItems.register("iron_heavy_crossbow", properties -> new TieredCrossbowItem((Item.Properties)properties, 6.65f, 0.8f, 0.0f, 1.75f), ModItems.property(1080));
    public static Supplier<TieredCrossbowItem> GOLDEN_HEAVY_CROSSBOW = ModItems.register("golden_heavy_crossbow", properties -> new TieredCrossbowItem((Item.Properties)properties, 7.15f, 0.75f, 0.0f, 1.875f), ModItems.property(1260));
    public static Supplier<TieredCrossbowItem> DIAMOND_HEAVY_CROSSBOW = ModItems.register("diamond_heavy_crossbow", properties -> new TieredCrossbowItem((Item.Properties)properties, 7.65f, 0.5f, 0.0f, 2.0f), ModItems.property(1440));
    public static Supplier<TieredCrossbowItem> NETHERITE_HEAVY_CROSSBOW = ModItems.register("netherite_heavy_crossbow", properties -> new TieredCrossbowItem((Item.Properties)properties, 8.15f, 0.25f, 0.0f, 2.25f), ModItems.property(2160).fireResistant());
    public static Supplier<WristbowItem> WRISTBOW = ModItems.register("wristbow", properties -> new WristbowItem((Item.Properties)properties, 2.15f, 1.0f, 1.0f), ModItems.property(256).component(ModDataComponents.get(ModDataComponents.WRISTBOW_READY), (Object)false));
    public static Supplier<WristbowItem> COPPER_WRISTBOW = ModItems.register("copper_wristbow", properties -> new WristbowItem((Item.Properties)properties, 2.65f, 1.0f, 1.0f), ModItems.property(384).component(ModDataComponents.get(ModDataComponents.WRISTBOW_READY), (Object)false));
    public static Supplier<WristbowItem> IRON_WRISTBOW = ModItems.register("iron_wristbow", properties -> new WristbowItem((Item.Properties)properties, 2.65f, 0.75f, 0.75f), ModItems.property(512).component(ModDataComponents.get(ModDataComponents.WRISTBOW_READY), (Object)false));
    public static Supplier<WristbowItem> GOLDEN_WRISTBOW = ModItems.register("golden_wristbow", properties -> new WristbowItem((Item.Properties)properties, 3.65f, 0.5f, 0.75f), ModItems.property(640).component(ModDataComponents.get(ModDataComponents.WRISTBOW_READY), (Object)false));
    public static Supplier<WristbowItem> DIAMOND_WRISTBOW = ModItems.register("diamond_wristbow", properties -> new WristbowItem((Item.Properties)properties, 3.15f, 0.25f, 0.625f), ModItems.property(768).component(ModDataComponents.get(ModDataComponents.WRISTBOW_READY), (Object)false));
    public static Supplier<WristbowItem> NETHERITE_WRISTBOW = ModItems.register("netherite_wristbow", properties -> new WristbowItem((Item.Properties)properties, 4.15f, 0.1f, 0.625f), ModItems.property(1024).component(ModDataComponents.get(ModDataComponents.WRISTBOW_READY), (Object)false));
    public static Supplier<ExplosiveArrowItem> EXPLOSIVE_ARROW = ModItems.register("explosive_arrow", ExplosiveArrowItem::new);
    public static Supplier<CopperArrowItem> COPPER_ARROW = ModItems.register("copper_arrow", CopperArrowItem::new);
    public static Supplier<SoftArrowItem> SOFT_ARROW = ModItems.register("soft_arrow", SoftArrowItem::new);
    public static Supplier<TracerArrowItem> TRACER_ARROW = ModItems.register("tracer_arrow", TracerArrowItem::new);
    public static Supplier<EchoingArrowItem> ECHOING_ARROW = ModItems.register("echoing_arrow", EchoingArrowItem::new);
    public static Supplier<WindChargedArrowItem> WIND_CHARGED_ARROW = ModItems.register("wind_charged_arrow", WindChargedArrowItem::new);
    public static Supplier<Item> WOODEN_UPGRADE_TEMPLATE = ModItems.register("wooden_upgrade_template", Item::new);
    public static Supplier<Item> COPPER_UPGRADE_TEMPLATE = ModItems.register("copper_upgrade_template", Item::new);
    public static Supplier<Item> IRON_UPGRADE_TEMPLATE = ModItems.register("iron_upgrade_template", Item::new);
    public static Supplier<Item> GOLDEN_UPGRADE_TEMPLATE = ModItems.register("golden_upgrade_template", Item::new);
    public static Supplier<Item> DIAMOND_UPGRADE_TEMPLATE = ModItems.register("diamond_upgrade_template", Item::new);
    public static final Supplier<CreativeModeTab> CREATIVE_MODE_TAB_SUPPLIER = () -> CreativeModeTab.builder((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).title((Component)Component.literal((String)"Archeries")).displayItems((itemDisplayParameters, output) -> REGISTERED.forEach((id, item) -> output.accept((ItemLike)item))).icon(() -> new ItemStack((ItemLike)ModItems.get(SPECTRAL_BOW))).build();

    private static Item.Properties property() {
        return new Item.Properties();
    }

    private static Item.Properties property(int durability) {
        return ModItems.property().durability(durability);
    }

    public static <T extends Item> Supplier<T> register(String name, Function<Item.Properties, T> itemFactory) {
        return ModItems.register(name, itemFactory, ModItems.property());
    }

    public static <T extends Item> Supplier<T> register(String name, Function<Item.Properties, T> itemFactory, Item.Properties properties) {
        ResourceLocation id = Archeries.id(name);
        ResourceKey itemKey = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id);
        Supplier<Item> item = () -> (Item)itemFactory.apply(properties.setId(itemKey));
        itemMap.put(id, item);
        return item;
    }

    public static void registerAll(BiConsumer<ResourceLocation, Supplier<Item>> reg) {
        itemMap.forEach(reg);
    }

    public static <T> T get(Supplier<T> item) {
        return (T)REGISTERED.get(item);
    }
}

