/*
 * Decompiled with CFR 0.152.
 */
package dev.proststuff.archeries.item.crossbow;

import dev.proststuff.archeries.item.bow.TieredBowItem;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TieredCrossbowItem
extends class_1764 {
    protected float velocity;
    protected float fireworkVelocity;
    protected float inaccuracy;
    protected float chargingTime;

    public TieredCrossbowItem(class_1792.class_1793 properties, float velocity, float inaccuracy, float fireworkVelocity, float chargingTime) {
        super(properties);
        this.velocity = velocity;
        this.inaccuracy = inaccuracy;
        this.fireworkVelocity = fireworkVelocity;
        this.chargingTime = chargingTime;
    }

    protected void method_7763(@NotNull class_1309 shooter, @NotNull class_1676 projectile, int index, float velocity, float inaccuracy, float angle, @Nullable class_1309 target) {
        Vector3f vector3f;
        velocity = projectile instanceof class_1671 ? this.fireworkVelocity : this.velocity;
        inaccuracy = this.inaccuracy;
        if (target != null) {
            double d0 = target.method_23317() - shooter.method_23317();
            double d1 = target.method_23321() - shooter.method_23321();
            double d2 = Math.sqrt(d0 * d0 + d1 * d1);
            double d3 = target.method_23323(0.3333333333333333) - projectile.method_23318() + d2 * (double)0.2f;
            vector3f = TieredCrossbowItem.getProjectileShotVector(shooter, new class_243(d0, d3, d1), angle);
        } else {
            class_243 vec3 = shooter.method_18864(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(angle * ((float)Math.PI / 180)), vec3.field_1352, vec3.field_1351, vec3.field_1350);
            class_243 vec31 = shooter.method_5828(1.0f);
            vector3f = vec31.method_46409().rotate((Quaternionfc)quaternionf);
        }
        projectile.method_7485((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), velocity, inaccuracy);
        float f = TieredCrossbowItem.getShotPitch(shooter.method_59922(), index);
        this.playShootSound(shooter.method_37908(), shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), f);
    }

    public void playShootSound(class_1937 level, double x, double y, double z, float power) {
        level.method_43128(null, x, y, z, class_3417.field_15187, class_3419.field_15248, 1.0f, 1.0f / (level.method_8409().method_43057() * 0.4f + 1.2f) + power * 0.5f);
    }

    public void method_7851(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        if (tooltipFlag.method_8035()) {
            tooltipComponents.add(TieredBowItem.append("tooltip.archeries.velocity", this.velocity, 3.15f, false));
            if (this.fireworkVelocity > 0.0f) {
                tooltipComponents.add(TieredBowItem.append("tooltip.archeries.firework_velocity", this.fireworkVelocity, 1.6f, false));
            }
            tooltipComponents.add(TieredBowItem.append("tooltip.archeries.inaccuracy", this.inaccuracy, 1.0f, true));
            tooltipComponents.add(TieredBowItem.append("tooltip.archeries.max_draw_duration", this.chargingTime, 1.25f, true));
        }
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
    }

    public int method_24792() {
        return (int)((double)this.velocity / 3.15) * 8;
    }

    public int method_7881(@NotNull class_1799 stack, @NotNull class_1309 shooter) {
        return TieredCrossbowItem.getChargeDuration(stack, shooter, Float.valueOf(this.getChargingTime(stack, shooter)));
    }

    @NotNull
    public Predicate<class_1799> method_20310() {
        if (this.fireworkVelocity <= 0.0f) {
            return field_18281;
        }
        return field_18282;
    }

    public float getChargingTime(class_1799 stack, class_1309 shooter) {
        return this.chargingTime;
    }

    public static int getChargeDuration(class_1799 stack, class_1309 shooter, Float initialChargingTime) {
        float f = class_1890.method_60159((class_1799)stack, (class_1309)shooter, (float)initialChargingTime.floatValue());
        return class_3532.method_15375((float)(f * 20.0f));
    }

    private static Vector3f getProjectileShotVector(class_1309 shooter, class_243 distance, float angle) {
        Vector3f vector3f = distance.method_46409().normalize();
        Vector3f vector3f1 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)vector3f1.lengthSquared() <= 1.0E-7) {
            class_243 vec3 = shooter.method_18864(1.0f);
            vector3f1 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)vec3.method_46409());
        }
        Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).rotateAxis(1.5707964f, vector3f1.x, vector3f1.y, vector3f1.z);
        return new Vector3f((Vector3fc)vector3f).rotateAxis(angle * ((float)Math.PI / 180), vector3f2.x, vector3f2.y, vector3f2.z);
    }

    private static float getShotPitch(class_5819 random, int index) {
        return index == 0 ? 1.0f : TieredCrossbowItem.getRandomShotPitch((index & 1) == 1, random);
    }

    private static float getRandomShotPitch(boolean isHighPitched, class_5819 random) {
        float f = isHighPitched ? 0.63f : 0.43f;
        return 1.0f / (random.method_43057() * 0.5f + 1.8f) + f;
    }
}

