/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.slashblade.maidpower.item;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDeathEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrqx.slashblade.maidpower.LittleMaidImpl;
import net.mrqx.slashblade.maidpower.config.TruePowerOfMaidCommonConfig;
import net.mrqx.slashblade.maidpower.event.api.MaidProgressComboEvent;

public class SlashBladeMaidBauble
implements IMaidBauble {

    @Mod.EventBusSubscriber
    public static class TruePower
    extends SlashBladeMaidBauble {
        @SubscribeEvent
        public static void onPowerBladeEvent(SlashBladeEvent.PowerBladeEvent event) {
            EntityMaid maid;
            LivingEntity livingEntity = event.getUser();
            if (livingEntity instanceof EntityMaid && TruePower.checkBauble(maid = (EntityMaid)livingEntity)) {
                event.setPowered(true);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public void onMaidDeathEvent(MaidDeathEvent event) {
            CompoundTag data;
            if (TruePower.checkBauble(event.getMaid()) && (data = event.getMaid().getPersistentData()).m_128454_("truePowerOfMaid.truePowerRank") > 0L) {
                data.m_128356_("truePowerOfMaid.truePowerRank", data.m_128454_("truePowerOfMaid.truePowerRank") - 300L);
                if (data.m_128454_("truePowerOfMaid.truePowerRank") > 0L) {
                    event.setCanceled(true);
                    event.getMaid().m_21153_(event.getMaid().m_21233_());
                }
            }
        }

        public static boolean checkBauble(EntityMaid maid) {
            if (maid.getFavorabilityManager().getLevel() < 3) {
                return false;
            }
            BaubleItemHandler handler = maid.getMaidBauble();
            int count = 0;
            boolean flag = false;
            for (int i = 0; i < handler.getSlots(); ++i) {
                IMaidBauble baubleIn = handler.getBaubleInSlot(i);
                if (!(baubleIn instanceof SlashBladeMaidBauble)) continue;
                ++count;
                if (!(baubleIn instanceof TruePower)) continue;
                flag = true;
            }
            return flag && count >= 9;
        }
    }

    public static class Exp
    extends SlashBladeMaidBauble {
        public static boolean checkBauble(EntityMaid maid) {
            return ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)LittleMaidImpl.EXP_BAUBLE) >= 0;
        }
    }

    public static class Health
    extends SlashBladeMaidBauble {
        public static boolean checkBauble(EntityMaid maid) {
            return ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)LittleMaidImpl.HEALTH_BAUBLE) >= 0;
        }
    }

    public static class Guard
    extends SlashBladeMaidBauble {
        public static boolean checkBauble(EntityMaid maid) {
            return ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)LittleMaidImpl.GUARD_BAUBLE) >= 0;
        }
    }

    public static class VoidSlash
    extends SlashBladeMaidBauble {
        public static boolean checkBauble(EntityMaid maid) {
            return ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)LittleMaidImpl.VOID_SLASH_BAUBLE) >= 0;
        }
    }

    public static class JustJudgementCut
    extends SlashBladeMaidBauble {
        public static boolean checkBauble(EntityMaid maid) {
            return ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)LittleMaidImpl.JUST_JUDGEMENT_CUT_BAUBLE) >= 0;
        }
    }

    public static class JudgementCut
    extends SlashBladeMaidBauble {
        public static boolean checkBauble(EntityMaid maid) {
            if (JustJudgementCut.checkBauble(maid)) {
                return true;
            }
            return ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)LittleMaidImpl.JUDGEMENT_CUT_BAUBLE) >= 0;
        }
    }

    @Mod.EventBusSubscriber
    public static class Power
    extends SlashBladeMaidBauble {
        @SubscribeEvent
        public static void onPowerBladeEvent(SlashBladeEvent.PowerBladeEvent event) {
            EntityMaid maid;
            LivingEntity livingEntity = event.getUser();
            if (livingEntity instanceof EntityMaid && Power.checkBauble(maid = (EntityMaid)livingEntity) && maid.getFavorabilityManager().getLevel() >= 3) {
                event.setPowered(true);
            }
        }

        public static boolean checkBauble(EntityMaid maid) {
            return ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)LittleMaidImpl.POWER_BAUBLE) >= 0;
        }
    }

    public static class Trick
    extends SlashBladeMaidBauble {
        public static boolean checkBauble(EntityMaid maid) {
            return ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)LittleMaidImpl.TRICK_BAUBLE) >= 0;
        }
    }

    public static class MirageBlade
    extends SlashBladeMaidBauble {
        public static boolean checkBauble(EntityMaid maid) {
            return ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)LittleMaidImpl.MIRAGE_BLADE_BAUBLE) >= 0;
        }
    }

    public static class AirCombo
    extends SlashBladeMaidBauble {
        public static boolean checkBauble(EntityMaid maid) {
            return ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)LittleMaidImpl.AIR_COMBO_BAUBLE) >= 0;
        }
    }

    @Mod.EventBusSubscriber
    public static class RapidSlash
    extends SlashBladeMaidBauble {
        @SubscribeEvent
        public static void onMaidProgressComboEvent(MaidProgressComboEvent event) {
            if (!RapidSlash.checkBauble(event.getMaid()) && event.getNextCombo().equals((Object)ComboStateRegistry.RAPID_SLASH_QUICK.getId())) {
                event.setCanceled(true);
            }
        }

        public static boolean checkBauble(EntityMaid maid) {
            return ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)LittleMaidImpl.RAPID_SLASH_BAUBLE) >= 0;
        }
    }

    @Mod.EventBusSubscriber
    public static class ComboC
    extends SlashBladeMaidBauble {
        @SubscribeEvent
        public static void onMaidProgressComboEvent(MaidProgressComboEvent event) {
            if (ComboC.checkBauble(event.getMaid())) {
                if (event.getCurrentCombo().equals((Object)ComboStateRegistry.COMBO_A2.getId())) {
                    event.setCanceled(true);
                }
            } else if (event.getNextCombo().equals((Object)ComboStateRegistry.COMBO_C.getId())) {
                event.setCanceled(true);
            }
        }

        public static boolean checkBauble(EntityMaid maid) {
            return ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)LittleMaidImpl.COMBO_C_BAUBLE) >= 0;
        }
    }

    @Mod.EventBusSubscriber
    public static class ComboB
    extends SlashBladeMaidBauble {
        @SubscribeEvent
        public static void onMaidProgressComboEvent(MaidProgressComboEvent event) {
            if (ComboB.checkBauble(event.getMaid())) {
                if (event.getCurrentCombo().equals((Object)ComboStateRegistry.COMBO_A3.getId()) || event.getCurrentCombo().equals((Object)ComboStateRegistry.AERIAL_RAVE_A2.getId())) {
                    event.setCanceled(true);
                }
            } else if (event.getNextCombo().equals((Object)ComboStateRegistry.COMBO_B1.getId()) || event.getNextCombo().equals((Object)ComboStateRegistry.AERIAL_RAVE_B3.getId())) {
                event.setCanceled(true);
            }
        }

        public static boolean checkBauble(EntityMaid maid) {
            return ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)LittleMaidImpl.COMBO_B_BAUBLE) >= 0;
        }
    }

    @Mod.EventBusSubscriber
    public static class UnawakenedSoul
    extends SlashBladeMaidBauble {
        @SubscribeEvent
        public static void onLivingDeathEvent(LivingDeathEvent event) {
            if (event.isCanceled()) {
                return;
            }
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof EntityMaid) {
                Item item1;
                String item;
                int i;
                IMaidBauble baubleIn;
                EntityMaid maid = (EntityMaid)entity;
                BaubleItemHandler handler = maid.getMaidBauble();
                RandomSource random = maid.m_9236_().m_213780_();
                int exp = event.getEntity().m_213860_();
                long exp4 = (long)exp * (long)exp * (long)exp;
                double chance = Math.min(1.0, (double)exp4 / 100000.0);
                if (random.m_188500_() < chance && (baubleIn = handler.getBaubleInSlot(i = random.m_188503_(handler.getSlots()))) instanceof UnawakenedSoul && random.m_188500_() < chance && (item = (String)TruePowerOfMaidCommonConfig.UNAWAKENED_SOUL_RANGE_MAP.get((Comparable)Double.valueOf(random.m_188500_() * TruePowerOfMaidCommonConfig.unawakenedSoulTotalRange))) != null && (item1 = (Item)maid.m_9236_().m_9598_().m_175515_(Registries.f_256913_).m_7745_(new ResourceLocation(item))) != null) {
                    handler.setStackInSlot(i, new ItemStack((ItemLike)item1));
                }
            }
        }

        public static boolean checkBauble(EntityMaid maid) {
            return ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)LittleMaidImpl.UNAWAKENED_SOUL_BAUBLE) >= 0;
        }
    }
}

