/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.slashblade.maidpower.entity.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.enchantment.Enchantments;
import net.mrqx.sbr_core.utils.MrqxSummonedSwordArts;
import net.mrqx.slashblade.maidpower.event.MaidGuardHandler;
import net.mrqx.slashblade.maidpower.item.SlashBladeMaidBauble;
import net.mrqx.slashblade.maidpower.util.MaidSlashBladeAttackUtils;
import org.jetbrains.annotations.NotNull;

public class MaidMirageBladeBehavior
extends Behavior<EntityMaid> {
    public static final String BASE_SUMMONED_SWORD_COUNTER_KEY = "truePowerOfMaid.baseSummonedSwordCounter";
    public static final String SPIRAL_SWORD_COUNTER_KEY = "truePowerOfMaid.spiralSwordCounter";
    public static final String STORM_SWORD_COUNTER_KEY = "truePowerOfMaid.stormSwordCounter";
    public static final String BLISTERING_SWORD_COUNTER_KEY = "truePowerOfMaid.blisteringSwordCounter";
    public static final String HEAVY_RAIN_SWORD_COUNTER_KEY = "truePowerOfMaid.heavyRainSwordCounter";

    public MaidMirageBladeBehavior() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), 1200);
    }

    public boolean checkExtraStartConditions(@NotNull ServerLevel level, EntityMaid maid) {
        Optional targetOpt = maid.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        if (targetOpt.isEmpty()) {
            return false;
        }
        LivingEntity target = (LivingEntity)targetOpt.get();
        return MaidSlashBladeAttackUtils.isHoldingSlashBlade((Mob)maid) && SlashBladeMaidBauble.MirageBlade.checkBauble(maid) && maid.canSee(target);
    }

    public boolean canStillUse(@NotNull ServerLevel level, EntityMaid maid, long gameTime) {
        return maid.m_6274_().m_21874_(MemoryModuleType.f_26372_) && this.checkExtraStartConditions(level, maid);
    }

    public void tick(@NotNull ServerLevel level, @NotNull EntityMaid maid, long gameTime) {
        LivingEntity target = maid.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
        boolean truePower = SlashBladeMaidBauble.TruePower.checkBauble(maid);
        if (target == null) {
            return;
        }
        if (!maid.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).isPresent()) {
            return;
        }
        if (MaidGuardHandler.isGuarding(maid) && !truePower) {
            return;
        }
        int favorLevel = maid.getFavorabilityManager().getLevel();
        int enchantPower = maid.m_21205_().getEnchantmentLevel(Enchantments.f_44988_);
        int powerLevel = (enchantPower + favorLevel + 1) * (truePower ? 2 : 1);
        CompoundTag data = maid.getPersistentData();
        switch (favorLevel) {
            case 3: {
                if (data.m_128451_(HEAVY_RAIN_SWORD_COUNTER_KEY) <= 0) {
                    int rank = maid.getCapability(CapabilityConcentrationRank.RANK_POINT).map(r -> r.getRank((long)maid.m_9236_().m_46467_()).level).orElse(0);
                    MrqxSummonedSwordArts.HEAVY_RAIN_SWORD.accept((Object)maid, (Object)target, (Object)powerLevel, (Object)((9 + Math.min(rank - 1, 0)) * 2));
                    data.m_128405_(HEAVY_RAIN_SWORD_COUNTER_KEY, 600);
                    break;
                }
            }
            case 2: {
                if (data.m_128451_(BLISTERING_SWORD_COUNTER_KEY) <= 0) {
                    int rank = maid.getCapability(CapabilityConcentrationRank.RANK_POINT).map(r -> r.getRank((long)maid.m_9236_().m_46467_()).level).orElse(0);
                    int count = IConcentrationRank.ConcentrationRanks.S.level <= rank ? 8 : 6;
                    MrqxSummonedSwordArts.BLISTERING_SWORD.accept((Object)maid, (Object)target, (Object)powerLevel, (Object)count);
                    data.m_128405_(BLISTERING_SWORD_COUNTER_KEY, 400);
                    break;
                }
            }
            case 1: {
                int count;
                int rank = maid.getCapability(CapabilityConcentrationRank.RANK_POINT).map(r -> r.getRank((long)maid.m_9236_().m_46467_()).level).orElse(0);
                int n = count = IConcentrationRank.ConcentrationRanks.S.level <= rank ? 8 : 6;
                if (data.m_128451_(SPIRAL_SWORD_COUNTER_KEY) <= 0) {
                    MrqxSummonedSwordArts.SPIRAL_SWORD.accept((Object)maid, (Object)powerLevel, (Object)count);
                    data.m_128405_(SPIRAL_SWORD_COUNTER_KEY, 200);
                    break;
                }
                if (data.m_128451_(STORM_SWORD_COUNTER_KEY) <= 0) {
                    MrqxSummonedSwordArts.STORM_SWORD.accept((Object)maid, (Object)target, (Object)powerLevel, (Object)count);
                    data.m_128405_(STORM_SWORD_COUNTER_KEY, 200);
                    break;
                }
            }
            case 0: {
                if (data.m_128451_(BASE_SUMMONED_SWORD_COUNTER_KEY) > 0) break;
                MrqxSummonedSwordArts.BASE_SUMMONED_SWORD.accept((Object)maid, (Object)target, (Object)powerLevel);
                data.m_128405_(BASE_SUMMONED_SWORD_COUNTER_KEY, 20);
                break;
            }
        }
    }
}

