/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.slashblade.maidpower.entity.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.IdF;
import com.mojang.datafixers.kinds.OptionalBox;
import java.util.Optional;
import java.util.function.Function;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.mrqx.sbr_core.utils.MrqxSlayerStyleArts;
import net.mrqx.slashblade.maidpower.event.MaidGuardHandler;
import net.mrqx.slashblade.maidpower.item.SlashBladeMaidBauble;
import net.mrqx.slashblade.maidpower.util.MaidSlashBladeMovementUtils;

public class MaidSlashBladeMove {
    public static final String TRICK_COOL_DOWN = "truePowerOfMaid.trickCooldown";

    public static BehaviorControl<Mob> create(Function<LivingEntity, Float> speedModifier) {
        return BehaviorBuilder.m_258034_(instance -> instance.group((App)instance.m_257492_(MemoryModuleType.f_26370_), (App)instance.m_257492_(MemoryModuleType.f_26371_), (App)instance.m_257495_(MemoryModuleType.f_26372_), (App)instance.m_257492_(MemoryModuleType.f_148205_)).apply((Applicative)instance, (walkTargetAccessor, lookTargetAccessor, attackTargetAccessor, visibleEntitiesAccessor) -> (level, mob, time) -> MaidSlashBladeMove.handleMove((BehaviorBuilder.Instance<Mob>)instance, (MemoryAccessor<OptionalBox.Mu, WalkTarget>)walkTargetAccessor, (MemoryAccessor<OptionalBox.Mu, PositionTracker>)lookTargetAccessor, (MemoryAccessor<IdF.Mu, LivingEntity>)attackTargetAccessor, (MemoryAccessor<OptionalBox.Mu, NearestVisibleLivingEntities>)visibleEntitiesAccessor, mob, speedModifier)));
    }

    public static BehaviorControl<Mob> create(float speedModifier) {
        return MaidSlashBladeMove.create(entity -> Float.valueOf(speedModifier));
    }

    private static boolean handleMove(BehaviorBuilder.Instance<Mob> instance, MemoryAccessor<OptionalBox.Mu, WalkTarget> walkTargetAccessor, MemoryAccessor<OptionalBox.Mu, PositionTracker> lookTargetAccessor, MemoryAccessor<IdF.Mu, LivingEntity> attackTargetAccessor, MemoryAccessor<OptionalBox.Mu, NearestVisibleLivingEntities> visibleEntitiesAccessor, Mob mob, Function<LivingEntity, Float> speedModifier) {
        LivingEntity target = (LivingEntity)instance.m_258051_(attackTargetAccessor);
        Optional visibleEntitiesOpt = instance.m_257828_(visibleEntitiesAccessor);
        if (mob instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)mob;
            float distance = maid.m_20270_((Entity)target);
            double reach = TargetSelector.getResolvedReach((LivingEntity)maid);
            CompoundTag data = maid.getPersistentData();
            boolean hasTruePower = SlashBladeMaidBauble.TruePower.checkBauble(maid);
            if (MaidGuardHandler.isGuarding(maid) && !hasTruePower) {
                return false;
            }
            boolean canTrick = MaidSlashBladeMovementUtils.canTrick(maid);
            boolean canAirTrick = canTrick && SlashBladeMaidBauble.MirageBlade.checkBauble(maid);
            boolean hasTrick = false;
            boolean targetVisible = visibleEntitiesOpt.map(entities -> entities.m_186107_(target)).orElse(false);
            if (targetVisible && (double)distance > reach * reach) {
                if (!canAirTrick) {
                    walkTargetAccessor.m_257971_();
                }
            } else {
                lookTargetAccessor.m_257512_((Object)new EntityTracker((Entity)target, true));
                walkTargetAccessor.m_257512_((Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)target, false), speedModifier.apply((LivingEntity)mob).floatValue() * (float)(hasTruePower ? 2 : 1), 0));
            }
            if (canAirTrick && (double)distance > reach) {
                if (!((Boolean)MaidSlashBladeMovementUtils.AIR_TRICK_CHECK.apply((Object)maid, (Object)Float.valueOf(distance), (Object)reach)).booleanValue()) {
                    MaidSlashBladeMovementUtils.TRY_TRICK_TO_TARGET.accept(maid, target);
                }
                hasTrick = true;
                data.m_128405_(TRICK_COOL_DOWN, 60);
                maid.m_9236_().m_7605_((Entity)maid, (byte)46);
            }
            if (canTrick && !hasTrick && !maid.m_20096_() && maid.m_20186_() - target.m_20186_() > 5.0) {
                MrqxSlayerStyleArts.TRICK_DOWN.apply(maid, true);
                data.m_128405_(TRICK_COOL_DOWN, 60);
                maid.m_9236_().m_7605_((Entity)maid, (byte)46);
            }
            return true;
        }
        return false;
    }
}

