/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.slashblade.maidpower.event;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Consumer;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrqx.sbr_core.events.ComboStateRegistryEvent;
import net.mrqx.slashblade.maidpower.item.SlashBladeMaidBauble;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ComboModifyHandler {
    private static final ResourceLocation UPPER_SLASH_NAME = SlashBlade.prefix((String)"upperslash_jump");

    @SubscribeEvent
    public static void onComboStateRegistryEvent(ComboStateRegistryEvent event) {
        ComboState.Builder builder = event.getBuilder();
        ComboState combo = event.getCombo();
        if (combo.getStartFrame() == ComboMovementModifiers.UPPER_SLASH.startFrame && combo.getEndFrame() == ComboMovementModifiers.UPPER_SLASH.endFrame && combo.getPriority() == ComboMovementModifiers.UPPER_SLASH.priority) {
            builder.addTickAction((Consumer)ComboState.TimeLineTickAction.getBuilder().put(6, livingEntity -> {
                EntityMaid maid;
                if (livingEntity instanceof EntityMaid && SlashBladeMaidBauble.AirCombo.checkBauble(maid = (EntityMaid)livingEntity)) {
                    maid.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                        state.updateComboSeq(livingEntity, UPPER_SLASH_NAME);
                        AdvancementHelper.grantCriterion((LivingEntity)livingEntity, (ResourceLocation)AdvancementHelper.ADVANCEMENT_UPPERSLASH_JUMP);
                    });
                }
            }).build());
        }
    }

    private static enum ComboMovementModifiers {
        UPPER_SLASH(1600, 1659, 90);

        public final int startFrame;
        public final int endFrame;
        public final int priority;

        private ComboMovementModifiers(int startFrame, int endFrame, int priority) {
            this.startFrame = startFrame;
            this.endFrame = endFrame;
            this.priority = priority;
        }
    }
}

