/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.slashblade.maidpower.task;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.data.builtin.SlashBladeBuiltInRegistry;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.mrqx.slashblade.maidpower.TruePowerOfMaid;
import net.mrqx.slashblade.maidpower.entity.ai.MaidMirageBladeBehavior;
import net.mrqx.slashblade.maidpower.entity.ai.MaidSlashBladeAttack;
import net.mrqx.slashblade.maidpower.entity.ai.MaidSlashBladeMove;
import net.mrqx.slashblade.maidpower.item.SlashBladeMaidBauble;
import net.mrqx.slashblade.maidpower.util.MaidSlashBladeAttackUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskSlashBlade
implements IAttackTask {
    public static final ResourceLocation UID = TruePowerOfMaid.prefix("slashblade_attack");

    @NotNull
    public ResourceLocation getUid() {
        return UID;
    }

    @NotNull
    public ItemStack getIcon() {
        Registry bladeRegistry;
        if (Minecraft.m_91087_().f_91074_ != null && (bladeRegistry = SlashBlade.getSlashBladeDefinitionRegistry((Level)Minecraft.m_91087_().f_91074_.m_9236_())).m_142003_(SlashBladeBuiltInRegistry.YAMATO)) {
            return Objects.requireNonNull((SlashBladeDefinition)bladeRegistry.m_6246_(SlashBladeBuiltInRegistry.YAMATO)).getBlade();
        }
        return SBItems.slashblade.m_7968_();
    }

    @Nullable
    public SoundEvent getAmbientSound(@NotNull EntityMaid maid) {
        return SoundUtil.attackSound((EntityMaid)maid, (SoundEvent)((SoundEvent)InitSounds.MAID_ATTACK.get()), (float)0.5f);
    }

    @NotNull
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(@NotNull EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(MaidSlashBladeAttackUtils::isHoldingSlashBlade, IRangedAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> !MaidSlashBladeAttackUtils.isHoldingSlashBlade((Mob)maid) || TaskSlashBlade.farAway(target, maid));
        BehaviorControl<Mob> moveToTargetTask = MaidSlashBladeMove.create(0.6f);
        OneShot<Mob> attackTargetTask = MaidSlashBladeAttack.create();
        MaidMirageBladeBehavior mirageBladeTask = new MaidMirageBladeBehavior();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, moveToTargetTask), Pair.of((Object)5, attackTargetTask), Pair.of((Object)5, (Object)((Object)mirageBladeTask))});
    }

    @NotNull
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createRideBrainTasks(@NotNull EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(MaidSlashBladeAttackUtils::isHoldingSlashBlade, IRangedAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> !MaidSlashBladeAttackUtils.isHoldingSlashBlade((Mob)maid) || TaskSlashBlade.farAway(target, maid));
        OneShot<Mob> attackTargetTask = MaidSlashBladeAttack.create();
        MaidMirageBladeBehavior mirageBladeTask = new MaidMirageBladeBehavior();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, attackTargetTask), Pair.of((Object)5, (Object)((Object)mirageBladeTask))});
    }

    public boolean isWeapon(@NotNull EntityMaid maid, ItemStack stack) {
        return stack.getCapability(ItemSlashBlade.BLADESTATE).isPresent();
    }

    private boolean hasSouls(EntityMaid maid) {
        BaubleItemHandler handler = maid.getMaidBauble();
        for (int i = 0; i < handler.getSlots(); ++i) {
            IMaidBauble baubleIn = handler.getBaubleInSlot(i);
            if (!(baubleIn instanceof SlashBladeMaidBauble)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(@NotNull EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"has_slashblade", MaidSlashBladeAttackUtils::isHoldingSlashBlade), Pair.of((Object)"souls", this::hasSouls)});
    }

    public static boolean farAway(LivingEntity target, EntityMaid maid) {
        if (!target.m_6084_()) {
            return true;
        }
        if (SlashBladeMaidBauble.MirageBlade.checkBauble(maid) && SlashBladeMaidBauble.Trick.checkBauble(maid)) {
            return false;
        }
        boolean enable = maid.isHomeModeEnable();
        double radius = TaskSlashBlade.getRadius(maid);
        if (!enable && maid.m_269323_() != null) {
            return (double)maid.m_269323_().m_20270_((Entity)target) > radius;
        }
        return (double)maid.m_20270_((Entity)target) > radius;
    }

    public static double getRadius(EntityMaid maid) {
        double radius = TargetSelector.getResolvedReach((LivingEntity)maid) * 2.0;
        radius *= radius;
        if (SlashBladeMaidBauble.MirageBlade.checkBauble(maid) || SlashBladeMaidBauble.JudgementCut.checkBauble(maid)) {
            radius *= 3.0;
        }
        return radius;
    }
}

