/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.slashblade.maidpower.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.mrqx.sbr_core.utils.MrqxSlayerStyleArts;
import net.mrqx.slashblade.maidpower.event.MaidGuardHandler;
import net.mrqx.slashblade.maidpower.item.SlashBladeMaidBauble;
import net.mrqx.slashblade.maidpower.util.MaidSlashBladeAttackUtils;
import org.apache.commons.lang3.function.TriFunction;

public class MaidSlashBladeMovementUtils {
    public static final TriFunction<EntityMaid, Float, Double, Boolean> AIR_TRICK_CHECK = MaidSlashBladeMovementUtils::airTrickCheck;
    public static final Consumer<EntityMaid> TRICK_DOWN_CHECK = MaidSlashBladeMovementUtils::trickDownCheck;
    public static final Consumer<EntityMaid> TRY_TRICK_DODGE = MaidSlashBladeMovementUtils::tryTrickDodge;
    public static final BiConsumer<EntityMaid, LivingEntity> TRY_TRICK_TO_TARGET = MaidSlashBladeMovementUtils::tryTrickToTarget;

    public static boolean canTrick(EntityMaid maid) {
        CompoundTag data = maid.getPersistentData();
        return SlashBladeMaidBauble.Trick.checkBauble(maid) && !MaidGuardHandler.isGuarding(maid) && data.m_128451_("truePowerOfMaid.trickCooldown") <= 0 && MaidSlashBladeAttackUtils.canInterruptCombo(maid);
    }

    private static Boolean airTrickCheck(EntityMaid maid, Float distance, Double reach) {
        if ((double)distance.floatValue() > reach) {
            return (Boolean)MrqxSlayerStyleArts.AIR_TRICK.apply(maid, true);
        }
        return false;
    }

    private static void trickDownCheck(EntityMaid maid) {
        if (maid.f_19789_ > 2.0f) {
            maid.f_19789_ = 0.0f;
            MrqxSlayerStyleArts.TRICK_DOWN.apply(maid, true);
        }
    }

    private static void tryTrickDodge(EntityMaid maid) {
        RandomSource random = maid.m_9236_().f_46441_;
        double oldX = maid.m_20182_().f_82479_;
        double oldY = maid.m_20182_().f_82480_;
        double oldZ = maid.m_20182_().f_82481_;
        if (!maid.m_9236_().m_5776_() && maid.m_6084_()) {
            for (int i = 0; i < 16; ++i) {
                double z;
                double y;
                double x = maid.m_20185_() + (random.m_188500_() - 0.5) * 16.0;
                if (maid.m_20984_(x, y = maid.m_5448_() != null ? maid.m_5448_().m_20186_() : maid.m_20186_(), z = maid.m_20189_() + (random.m_188500_() - 0.5) * 16.0, false) && ((Boolean)MrqxSlayerStyleArts.TRICK_DODGE.m_176446_((Object)maid, (Object)true, (Object)false, (Object)maid.m_20182_())).booleanValue()) {
                    maid.m_9236_().m_7605_((Entity)maid, (byte)46);
                    break;
                }
                maid.m_6021_(oldX, oldY, oldZ);
            }
        }
    }

    private static void tryTrickToTarget(EntityMaid maid, LivingEntity target) {
        RandomSource random = maid.m_9236_().f_46441_;
        double oldX = maid.m_20182_().f_82479_;
        double oldY = maid.m_20182_().f_82480_;
        double oldZ = maid.m_20182_().f_82481_;
        if (!maid.m_9236_().m_5776_() && target != null && maid.m_6084_()) {
            for (int i = 0; i < 16; ++i) {
                double z;
                double y;
                double reach = TargetSelector.getResolvedReach((LivingEntity)maid);
                reach *= reach;
                double x = target.m_20185_() + (random.m_188500_() - 0.5) * reach * 0.8;
                if (maid.m_20984_(x, y = target.m_20186_(), z = target.m_20189_() + (random.m_188500_() - 0.5) * reach * 0.8, false) && ((Boolean)MrqxSlayerStyleArts.TRICK_DODGE.m_176446_((Object)maid, (Object)true, (Object)false, (Object)maid.m_20182_())).booleanValue() && TargetSelector.getTargettableEntitiesWithinAABB((Level)maid.m_9236_(), (LivingEntity)maid).contains(target)) {
                    maid.m_9236_().m_7605_((Entity)maid, (byte)46);
                    break;
                }
                maid.m_6021_(oldX, oldY, oldZ);
            }
        }
    }
}

