/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.slashblade.maidpower.client.renderer;

import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.ILocationModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import jp.nyatla.nymmd.MmdException;
import jp.nyatla.nymmd.MmdVmdMotionMc;
import jp.nyatla.nymmd.MmdVmdMotion_BasicClass;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.client.renderer.layers.LayerMainBlade;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.BladeMotionManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.IForgeRegistry;
import net.mrqx.slashblade.maidpower.TruePowerOfMaid;
import net.mrqx.slashblade.maidpower.mixin.AccessorLayerMainBlade;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class LayerMaidBladeRenderer<T extends Mob, M extends EntityModel<T>>
extends LayerMainBlade<T, M> {
    public LayerMaidBladeRenderer(RenderLayerParent<T, M> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(@NotNull PoseStack matrixStack, @NotNull MultiBufferSource bufferIn, int lightIn, @NotNull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderOffhandItem(matrixStack, bufferIn, lightIn, entity);
        float yOffset = 1.5f;
        double motionScale = 0.125;
        double modelScaleBase = 0.0078125;
        ItemStack stack = entity.m_21120_(InteractionHand.MAIN_HAND);
        if (!stack.m_41619_()) {
            LazyOptional state = stack.getCapability(CapabilitySlashBlade.BLADESTATE);
            AccessorLayerMainBlade accessorLayerMainBlade = (AccessorLayerMainBlade)((Object)this);
            state.ifPresent(s -> accessorLayerMainBlade.getMotionPlayer().ifPresent(mmp -> {
                ComboState combo = ((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(s.getComboSeq()) != null ? (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(s.getComboSeq()) : (ComboState)ComboStateRegistry.NONE.get();
                double time = TimeValueHelper.getMSecFromTicks((double)((float)Math.max(0L, entity.m_9236_().m_46467_() - s.getLastActionTime()) + partialTicks));
                while (combo != ComboStateRegistry.NONE.get()) {
                    int n = combo != null ? combo.getTimeoutMS() : 0;
                    if (!((double)n < time)) break;
                    time -= combo != null ? (double)combo.getTimeoutMS() : 0.0;
                    combo = ((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(combo != null ? combo.getNextOfTimeout((LivingEntity)entity) : null) != null ? (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(combo != null ? combo.getNextOfTimeout((LivingEntity)entity) : null) : (ComboState)ComboStateRegistry.NONE.get();
                }
                if (combo == ComboStateRegistry.NONE.get()) {
                    ComboState comboState = combo = ((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(s.getComboRoot()) != null ? (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(s.getComboRoot()) : (ComboState)ComboStateRegistry.STANDBY.get();
                }
                if (combo != null) {
                    MmdVmdMotionMc motion = BladeMotionManager.getInstance().getMotion(combo.getMotionLoc());
                    double maxSeconds = 0.0;
                    try {
                        mmp.setVmd((MmdVmdMotion_BasicClass)motion);
                        maxSeconds = TimeValueHelper.getMSecFromFrames((double)motion.getMaxFrame());
                    }
                    catch (Exception e) {
                        TruePowerOfMaid.LOGGER.error("Error while rendering maid`s SlashBlade:", (Throwable)e);
                    }
                    double start = TimeValueHelper.getMSecFromFrames((double)combo.getStartFrame());
                    double end = TimeValueHelper.getMSecFromFrames((double)combo.getEndFrame());
                    double span = Math.abs(end - start);
                    span = Math.min(maxSeconds, span);
                    if (combo.getLoop()) {
                        time %= span;
                    }
                    time = Math.min(span, time);
                    time = start + time;
                    try {
                        mmp.updateMotion((float)time);
                    }
                    catch (MmdException e) {
                        TruePowerOfMaid.LOGGER.error("Error while rendering maid`s SlashBlade:", (Throwable)e);
                    }
                    try (MSAutoCloser ignored = MSAutoCloser.pushMatrix((PoseStack)matrixStack);){
                        PoseStack.Pose entry;
                        Matrix4f mat;
                        int idx;
                        this.setUserPose(matrixStack, entity, partialTicks);
                        matrixStack.m_252880_(0.0f, yOffset, 0.0f);
                        matrixStack.m_85841_((float)motionScale, (float)motionScale, (float)motionScale);
                        matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                        ResourceLocation textureLocation = s.getTexture().orElse(DefaultResources.resourceDefaultTexture);
                        WavefrontObject obj = BladeModelManager.getInstance().getModel(s.getModel().orElse(DefaultResources.resourceDefaultModel));
                        try (MSAutoCloser ignored1 = MSAutoCloser.pushMatrix((PoseStack)matrixStack);){
                            idx = mmp.getBoneIndexByName("hardpointA");
                            if (0 <= idx) {
                                float[] buf = new float[16];
                                mmp._skinning_mat[idx].getValue(buf);
                                mat = VectorHelper.matrix4fFromArray((float[])buf);
                                matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
                                entry = matrixStack.m_85850_();
                                entry.m_252922_().mul((Matrix4fc)mat);
                                matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
                            }
                            float modelScale = (float)(modelScaleBase * (1.0 / motionScale));
                            matrixStack.m_85841_(modelScale, modelScale, modelScale);
                            String part = s.isBroken() ? "blade_damaged" : "blade";
                            BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)obj, (String)part, (ResourceLocation)textureLocation, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
                            BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)obj, (String)(part + "_luminous"), (ResourceLocation)textureLocation, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
                        }
                        ignored1 = MSAutoCloser.pushMatrix((PoseStack)matrixStack);
                        try {
                            idx = mmp.getBoneIndexByName("hardpointB");
                            if (0 <= idx) {
                                float[] buf = new float[16];
                                mmp._skinning_mat[idx].getValue(buf);
                                mat = VectorHelper.matrix4fFromArray((float[])buf);
                                matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
                                entry = matrixStack.m_85850_();
                                entry.m_252922_().mul((Matrix4fc)mat);
                                matrixStack.m_85841_(-1.0f, 1.0f, 1.0f);
                            }
                            float modelScale = (float)(modelScaleBase * (1.0 / motionScale));
                            matrixStack.m_85841_(modelScale, modelScale, modelScale);
                            BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)obj, (String)"sheath", (ResourceLocation)textureLocation, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
                            BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)obj, (String)"sheath_luminous", (ResourceLocation)textureLocation, (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
                            if (s.isCharged((LivingEntity)entity)) {
                                float f = (float)entity.f_19797_ + partialTicks;
                                BladeRenderState.renderChargeEffect((ItemStack)stack, (float)f, (WavefrontObject)obj, (String)"effect", (ResourceLocation)new ResourceLocation("textures/entity/creeper/creeper_armor.png"), (PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)lightIn);
                            }
                        }
                        finally {
                            if (ignored1 != null) {
                                ignored1.close();
                            }
                        }
                    }
                }
            }));
        }
    }

    public void renderOffhandItem(PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, T entity) {
    }

    public void setUserPose(PoseStack matrixStack, T entity, float partialTicks) {
        BedrockModel bedrockModel;
        EntityModel model = this.m_117386_();
        if (model instanceof BedrockModel && (bedrockModel = (BedrockModel)model).hasWaistPositioningModel(HumanoidArm.LEFT)) {
            bedrockModel.translateToPositioningWaist(HumanoidArm.LEFT, matrixStack);
        } else if (model instanceof ILocationModel) {
            ILocationModel iLocationModel = (ILocationModel)model;
            RenderUtils.prepMatrixForLocator((PoseStack)matrixStack, (List)iLocationModel.leftHandBones());
        } else {
            matrixStack.m_85837_(0.25, 0.85, 0.0);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-20.0f));
        }
        matrixStack.m_252880_(-0.3f, -0.2f, -0.5f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(15.0f));
        super.setUserPose(matrixStack, entity, partialTicks);
    }
}

