/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.slashblade.maidpower.client.renderer;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoEntityRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.ILocationModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import jp.nyatla.nymmd.MmdException;
import jp.nyatla.nymmd.MmdMotionPlayerGL2;
import jp.nyatla.nymmd.MmdPmdModelMc;
import jp.nyatla.nymmd.MmdPmdModel_BasicClass;
import jp.nyatla.nymmd.MmdVmdMotionMc;
import jp.nyatla.nymmd.MmdVmdMotion_BasicClass;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.BladeMotionManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.event.client.UserPoseOverrider;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.IForgeRegistry;
import net.mrqx.slashblade.maidpower.TruePowerOfMaid;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class GeoLayerMaidBladeRenderer<T extends Mob, R extends IGeoEntityRenderer<T>>
extends GeoLayerRenderer<T, R> {
    private static final ResourceLocation CREEPER_ARMOR = new ResourceLocation("textures/entity/creeper/creeper_armor.png");
    private final LazyOptional<MmdPmdModelMc> bladeHolder = LazyOptional.of(() -> {
        try {
            return new MmdPmdModelMc(new ResourceLocation("slashblade", "model/bladeholder.pmd"));
        }
        catch (IOException | MmdException e) {
            throw new RuntimeException(e);
        }
    });
    private final LazyOptional<MmdMotionPlayerGL2> motionPlayer = LazyOptional.of(() -> {
        MmdMotionPlayerGL2 mmp = new MmdMotionPlayerGL2();
        this.bladeHolder.ifPresent(pmd -> {
            try {
                mmp.setPmd((MmdPmdModel_BasicClass)pmd);
            }
            catch (MmdException e) {
                TruePowerOfMaid.LOGGER.error("", (Throwable)e);
            }
        });
        return mmp;
    });

    public GeoLayerMaidBladeRenderer(R entityRendererIn) {
        super(entityRendererIn);
    }

    public GeoLayerMaidBladeRenderer<T, R> copy(R renderer) {
        return new GeoLayerMaidBladeRenderer<T, R>(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack = entity.m_21120_(InteractionHand.MAIN_HAND);
        if (stack.m_41619_()) {
            return;
        }
        stack.getCapability(CapabilitySlashBlade.BLADESTATE).ifPresent(state -> this.motionPlayer.ifPresent(mmp -> this.renderBlade(poseStack, buffer, light, entity, partialTicks, stack, (ISlashBladeState)state, (MmdMotionPlayerGL2)mmp)));
    }

    private void renderBlade(PoseStack poseStack, MultiBufferSource buffer, int light, T entity, float partialTicks, ItemStack stack, ISlashBladeState state, MmdMotionPlayerGL2 mmp) {
        float yOffset = 1.5f;
        double motionScale = 0.125;
        double modelScaleBase = 0.0078125;
        ComboState combo = this.getComboState(state);
        double time = this.getComboTime(combo, entity, state, partialTicks);
        if (combo == ComboStateRegistry.NONE.get()) {
            combo = this.getComboRootState(state);
        }
        MmdVmdMotionMc motion = BladeMotionManager.getInstance().getMotion(Objects.requireNonNull(combo).getMotionLoc());
        double maxSeconds = 0.0;
        try {
            mmp.setVmd((MmdVmdMotion_BasicClass)motion);
            maxSeconds = TimeValueHelper.getMSecFromFrames((double)motion.getMaxFrame());
        }
        catch (Exception e) {
            TruePowerOfMaid.LOGGER.error("", (Throwable)e);
        }
        double start = TimeValueHelper.getMSecFromFrames((double)combo.getStartFrame());
        double end = TimeValueHelper.getMSecFromFrames((double)combo.getEndFrame());
        double span = Math.abs(end - start);
        span = Math.min(maxSeconds, span);
        if (combo.getLoop()) {
            time %= span;
        }
        time = Math.min(span, time);
        time = start + time;
        try {
            mmp.updateMotion((float)time);
        }
        catch (MmdException e) {
            TruePowerOfMaid.LOGGER.error("", (Throwable)e);
        }
        try (MSAutoCloser ignored = MSAutoCloser.pushMatrix((PoseStack)poseStack);){
            this.setUserPose(poseStack, entity, partialTicks);
            poseStack.m_252880_(0.0f, yOffset, 0.0f);
            poseStack.m_85841_((float)motionScale, (float)motionScale, (float)motionScale);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            ResourceLocation textureLocation = state.getTexture().orElse(DefaultResources.resourceDefaultTexture);
            WavefrontObject obj = BladeModelManager.getInstance().getModel(state.getModel().orElse(DefaultResources.resourceDefaultModel));
            this.renderBladePart(poseStack, buffer, light, stack, obj, mmp, "hardpointA", modelScaleBase, motionScale, state, textureLocation);
            this.renderSheathPart(poseStack, buffer, light, stack, obj, mmp, "hardpointB", modelScaleBase, motionScale, state, textureLocation, entity, partialTicks);
        }
    }

    private ComboState getComboState(ISlashBladeState state) {
        ComboState combo = ((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(state.getComboSeq()) != null ? (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(state.getComboSeq()) : (ComboState)ComboStateRegistry.NONE.get();
        return combo;
    }

    private ComboState getComboRootState(ISlashBladeState state) {
        return ((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(state.getComboRoot()) != null ? (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(state.getComboRoot()) : (ComboState)ComboStateRegistry.STANDBY.get();
    }

    private double getComboTime(ComboState combo, T entity, ISlashBladeState state, float partialTicks) {
        double time = 0.0;
        if (combo != null) {
            for (time = TimeValueHelper.getMSecFromTicks((double)((float)Math.max(0L, entity.m_9236_().m_46467_() - state.getLastActionTime()) + partialTicks)); combo != ComboStateRegistry.NONE.get() && (double)Objects.requireNonNull(combo).getTimeoutMS() < time; time -= (double)combo.getTimeoutMS()) {
                combo = ((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(combo.getNextOfTimeout(entity)) != null ? (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(combo.getNextOfTimeout(entity)) : (ComboState)ComboStateRegistry.NONE.get();
            }
        }
        return time;
    }

    private void renderBladePart(PoseStack poseStack, MultiBufferSource buffer, int light, ItemStack stack, WavefrontObject obj, MmdMotionPlayerGL2 mmp, String boneName, double modelScaleBase, double motionScale, ISlashBladeState state, ResourceLocation textureLocation) {
        try (MSAutoCloser ignored = MSAutoCloser.pushMatrix((PoseStack)poseStack);){
            int idx = mmp.getBoneIndexByName(boneName);
            if (0 <= idx) {
                float[] buf = new float[16];
                mmp._skinning_mat[idx].getValue(buf);
                Matrix4f mat = VectorHelper.matrix4fFromArray((float[])buf);
                poseStack.m_85841_(-1.0f, 1.0f, 1.0f);
                PoseStack.Pose entry = poseStack.m_85850_();
                entry.m_252922_().mul((Matrix4fc)mat);
                poseStack.m_85841_(-1.0f, 1.0f, 1.0f);
            }
            float modelScale = (float)(modelScaleBase * (1.0 / motionScale));
            poseStack.m_85841_(modelScale, modelScale, modelScale);
            String part = state.isBroken() ? "blade_damaged" : "blade";
            BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)obj, (String)part, (ResourceLocation)textureLocation, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)light);
            BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)obj, (String)(part + "_luminous"), (ResourceLocation)textureLocation, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)light);
        }
    }

    private void renderSheathPart(PoseStack poseStack, MultiBufferSource buffer, int light, ItemStack stack, WavefrontObject obj, MmdMotionPlayerGL2 mmp, String boneName, double modelScaleBase, double motionScale, ISlashBladeState state, ResourceLocation textureLocation, T entity, float partialTicks) {
        try (MSAutoCloser ignored = MSAutoCloser.pushMatrix((PoseStack)poseStack);){
            int idx = mmp.getBoneIndexByName(boneName);
            if (0 <= idx) {
                float[] buf = new float[16];
                mmp._skinning_mat[idx].getValue(buf);
                Matrix4f mat = VectorHelper.matrix4fFromArray((float[])buf);
                poseStack.m_85841_(-1.0f, 1.0f, 1.0f);
                PoseStack.Pose entry = poseStack.m_85850_();
                entry.m_252922_().mul((Matrix4fc)mat);
                poseStack.m_85841_(-1.0f, 1.0f, 1.0f);
            }
            float modelScale = (float)(modelScaleBase * (1.0 / motionScale));
            poseStack.m_85841_(modelScale, modelScale, modelScale);
            BladeRenderState.renderOverrided((ItemStack)stack, (WavefrontObject)obj, (String)"sheath", (ResourceLocation)textureLocation, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)light);
            BladeRenderState.renderOverridedLuminous((ItemStack)stack, (WavefrontObject)obj, (String)"sheath_luminous", (ResourceLocation)textureLocation, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)light);
            if (state.isCharged(entity)) {
                float f = (float)((Mob)entity).f_19797_ + partialTicks;
                BladeRenderState.renderChargeEffect((ItemStack)stack, (float)f, (WavefrontObject)obj, (String)"effect", (ResourceLocation)CREEPER_ARMOR, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)light);
            }
        }
    }

    public void setUserPose(PoseStack poseStack, T entity, float partialTicks) {
        ILocationModel model = this.getLocationModel((Entity)entity);
        RenderUtils.prepMatrixForLocator((PoseStack)poseStack, (List)model.leftHandBones());
        poseStack.m_252880_(-0.35f, -0.8f, -0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(15.0f));
        UserPoseOverrider.invertRot((PoseStack)poseStack, entity, (float)partialTicks);
    }
}

