/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.slashblade.maidpower.entity.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.IdF;
import com.mojang.datafixers.kinds.OptionalBox;
import java.util.Set;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.mrqx.slashblade.maidpower.event.MaidGuardHandler;
import net.mrqx.slashblade.maidpower.item.SlashBladeMaidBauble;
import net.mrqx.slashblade.maidpower.util.MaidSlashBladeAttackUtils;
import net.mrqx.truepower.registry.TruePowerComboStateRegistry;

public class MaidSlashBladeAttack {
    public static final Set<ComboState> CHARGE_COMBO = Set.of((ComboState)ComboStateRegistry.COMBO_C.get(), (ComboState)ComboStateRegistry.COMBO_A4.get(), (ComboState)ComboStateRegistry.COMBO_A5.get(), (ComboState)ComboStateRegistry.COMBO_B7.get(), (ComboState)ComboStateRegistry.COMBO_B_END2.get(), (ComboState)ComboStateRegistry.AERIAL_RAVE_A3.get(), (ComboState)ComboStateRegistry.AERIAL_RAVE_B4.get(), (ComboState)ComboStateRegistry.UPPERSLASH.get(), (ComboState)ComboStateRegistry.UPPERSLASH_JUMP.get(), (ComboState)ComboStateRegistry.AERIAL_CLEAVE_LANDING.get(), (ComboState)ComboStateRegistry.RAPID_SLASH_END.get(), (ComboState)ComboStateRegistry.RISING_STAR.get(), (ComboState)TruePowerComboStateRegistry.VOID_SLASH_SHEATH.get());
    public static final Set<ComboState> QUICK_CHARGE_COMBO = Set.of((ComboState)ComboStateRegistry.COMBO_A1_END.get(), (ComboState)ComboStateRegistry.COMBO_A2_END.get(), (ComboState)ComboStateRegistry.COMBO_C_END.get(), (ComboState)ComboStateRegistry.COMBO_A3_END3.get(), (ComboState)ComboStateRegistry.COMBO_A4_END.get(), (ComboState)ComboStateRegistry.COMBO_A4_EX_END2.get(), (ComboState)ComboStateRegistry.COMBO_A5_END.get(), (ComboState)ComboStateRegistry.COMBO_B7_END3.get(), (ComboState)ComboStateRegistry.COMBO_B_END3.get(), (ComboState)ComboStateRegistry.AERIAL_RAVE_A1_END.get(), (ComboState)ComboStateRegistry.AERIAL_RAVE_A2_END2.get(), (ComboState)ComboStateRegistry.AERIAL_RAVE_A3_END.get(), (ComboState)ComboStateRegistry.AERIAL_RAVE_B3_END.get(), (ComboState)ComboStateRegistry.AERIAL_RAVE_B4_END.get(), (ComboState)ComboStateRegistry.UPPERSLASH_END.get(), (ComboState)ComboStateRegistry.UPPERSLASH_JUMP_END.get(), (ComboState)ComboStateRegistry.AERIAL_CLEAVE_END.get(), (ComboState)ComboStateRegistry.RAPID_SLASH_QUICK.get(), (ComboState)ComboStateRegistry.RAPID_SLASH_END2.get(), (ComboState)ComboStateRegistry.RISING_STAR_END.get(), (ComboState)TruePowerComboStateRegistry.VOID_SLASH_SHEATH.get(), (ComboState)ComboStateRegistry.JUDGEMENT_CUT_SHEATH.get(), (ComboState)ComboStateRegistry.JUDGEMENT_CUT_SHEATH_AIR.get(), (ComboState)ComboStateRegistry.JUDGEMENT_CUT_SHEATH_JUST.get());
    public static final Set<ComboState> UNINTERRUPTIBLE_COMBO = Set.of((ComboState)ComboStateRegistry.COMBO_A1.get(), (ComboState)ComboStateRegistry.COMBO_A2.get(), (ComboState)ComboStateRegistry.COMBO_C.get(), (ComboState)ComboStateRegistry.COMBO_A3.get(), (ComboState)ComboStateRegistry.COMBO_A4.get(), (ComboState)ComboStateRegistry.COMBO_A4_EX.get(), (ComboState)ComboStateRegistry.COMBO_A5.get(), (ComboState)ComboStateRegistry.COMBO_B1.get(), (ComboState)ComboStateRegistry.COMBO_B7.get(), (ComboState)ComboStateRegistry.COMBO_B_END2.get(), (ComboState)ComboStateRegistry.AERIAL_RAVE_A1.get(), (ComboState)ComboStateRegistry.AERIAL_RAVE_A2.get(), (ComboState)ComboStateRegistry.AERIAL_RAVE_A3.get(), (ComboState)ComboStateRegistry.AERIAL_RAVE_B3.get(), (ComboState)ComboStateRegistry.AERIAL_RAVE_B4.get(), (ComboState)ComboStateRegistry.UPPERSLASH.get(), (ComboState)ComboStateRegistry.UPPERSLASH_JUMP.get(), (ComboState)ComboStateRegistry.AERIAL_CLEAVE.get(), (ComboState)ComboStateRegistry.RISING_STAR.get(), (ComboState)ComboStateRegistry.JUDGEMENT_CUT.get(), (ComboState)ComboStateRegistry.JUDGEMENT_CUT_SLASH.get(), (ComboState)ComboStateRegistry.JUDGEMENT_CUT_SLASH_AIR.get(), (ComboState)ComboStateRegistry.JUDGEMENT_CUT_SLASH_JUST.get(), (ComboState)ComboStateRegistry.JUDGEMENT_CUT_SLASH_JUST2.get(), (ComboState)ComboStateRegistry.JUDGEMENT_CUT_END.get(), (ComboState)TruePowerComboStateRegistry.VOID_SLASH.get());
    public static final Set<ComboState> TRUE_POWER_UNINTERRUPTIBLE_COMBO = Set.of((ComboState)ComboStateRegistry.COMBO_C.get(), (ComboState)ComboStateRegistry.COMBO_A4_EX.get(), (ComboState)ComboStateRegistry.COMBO_A5.get(), (ComboState)ComboStateRegistry.COMBO_B7.get(), (ComboState)ComboStateRegistry.COMBO_B_END2.get(), (ComboState)ComboStateRegistry.AERIAL_RAVE_B3.get(), (ComboState)ComboStateRegistry.UPPERSLASH.get(), (ComboState)ComboStateRegistry.AERIAL_CLEAVE.get(), (ComboState)ComboStateRegistry.RISING_STAR.get(), (ComboState)ComboStateRegistry.JUDGEMENT_CUT.get(), (ComboState)ComboStateRegistry.JUDGEMENT_CUT_END.get(), (ComboState)TruePowerComboStateRegistry.VOID_SLASH.get());

    public static OneShot<Mob> create() {
        return BehaviorBuilder.m_258034_(instance -> instance.group((App)instance.m_257492_(MemoryModuleType.f_26371_), (App)instance.m_257495_(MemoryModuleType.f_26372_), (App)instance.m_257495_(MemoryModuleType.f_148205_)).apply((Applicative)instance, (lookTargetAccessor, attackTargetAccessor, visibleEntitiesAccessor) -> (level, mob, time) -> MaidSlashBladeAttack.handleAttack((BehaviorBuilder.Instance<Mob>)instance, (MemoryAccessor<OptionalBox.Mu, PositionTracker>)lookTargetAccessor, (MemoryAccessor<IdF.Mu, LivingEntity>)attackTargetAccessor, (MemoryAccessor<IdF.Mu, NearestVisibleLivingEntities>)visibleEntitiesAccessor, mob)));
    }

    private static boolean handleAttack(BehaviorBuilder.Instance<Mob> instance, MemoryAccessor<OptionalBox.Mu, PositionTracker> lookTargetAccessor, MemoryAccessor<IdF.Mu, LivingEntity> attackTargetAccessor, MemoryAccessor<IdF.Mu, NearestVisibleLivingEntities> visibleEntitiesAccessor, Mob mob) {
        LivingEntity target = (LivingEntity)instance.m_258051_(attackTargetAccessor);
        if (!(mob instanceof EntityMaid)) {
            return false;
        }
        EntityMaid maid = (EntityMaid)mob;
        if (maid.m_9236_().m_46467_() % 4L != 0L) {
            return false;
        }
        if (!MaidSlashBladeAttackUtils.isHoldingSlashBlade((Mob)maid)) {
            return false;
        }
        NearestVisibleLivingEntities visibleEntities = (NearestVisibleLivingEntities)instance.m_258051_(visibleEntitiesAccessor);
        boolean truePower = SlashBladeMaidBauble.TruePower.checkBauble(maid);
        if (!visibleEntities.m_186107_(target)) {
            return false;
        }
        if (MaidGuardHandler.isGuarding(maid) && !truePower) {
            return false;
        }
        maid.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            state.setTargetEntityId((Entity)maid.m_5448_());
            if ((double)maid.m_20270_((Entity)target) <= TargetSelector.getResolvedReach((LivingEntity)maid)) {
                lookTargetAccessor.m_257512_((Object)new EntityTracker((Entity)target, true));
                if (((Boolean)MaidSlashBladeAttackUtils.TRY_JUDGEMENT_CUT.apply((Object)maid, state, (Object)target)).booleanValue()) {
                    return;
                }
                MaidSlashBladeAttackUtils.NORMAL_SLASHBLADE_ATTACK.accept((Object)maid, state, (Object)target);
            } else {
                if (!maid.m_20096_() && maid.m_20186_() - target.m_20186_() > 5.0) {
                    MaidSlashBladeAttackUtils.TRY_AERIAL_CLEAVE.apply(maid, (ISlashBladeState)state);
                }
                if (SlashBladeMaidBauble.RapidSlash.checkBauble(maid) && MaidSlashBladeAttackUtils.canInterruptCombo(maid)) {
                    lookTargetAccessor.m_257512_((Object)new EntityTracker((Entity)target, true));
                    MaidSlashBladeAttackUtils.RAPID_SLASH_ATTACK.accept((Object)maid, state, (Object)target);
                } else if (SlashBladeMaidBauble.JudgementCut.checkBauble(maid)) {
                    lookTargetAccessor.m_257512_((Object)new EntityTracker((Entity)target, true));
                    MaidSlashBladeAttackUtils.TRY_JUDGEMENT_CUT.apply((Object)maid, state, (Object)target);
                }
            }
        });
        return true;
    }
}

