/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.slashblade.maidpower.event;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import mods.flammpfeil.slashblade.ability.Untouchable;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrqx.sbr_core.utils.MrqxSlayerStyleArts;
import net.mrqx.slashblade.maidpower.item.SlashBladeMaidBauble;
import net.mrqx.slashblade.maidpower.util.MaidSlashBladeMovementUtils;

@Mod.EventBusSubscriber
public class MaidGuardHandler {
    public static final String GUARD_DAMAGE_COUNTER = "truePowerOfMaid.guardDamageCounter";
    public static final String GUARD_TOTAL_DAMAGE_COUNTER = "truePowerOfMaid.guardTotalDamageCounter";
    public static final String GUARD_ESCAPE_COUNTER = "truePowerOfMaid.guardEscapeCounter";
    public static final String PRE_ESCAPE_COUNTER = "truePowerOfMaid.preEscapeCounter";
    public static final String GUARD_COOL_DOWN = "truePowerOfMaid.guardCooldown";
    public static final String IS_PRE_ESCAPING = "truePowerOfMaid.isPreEscaping";
    public static final String GUARD_DAMAGE = "truePowerOfMaid.guardDamage";

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof EntityMaid)) {
            return;
        }
        EntityMaid maid = (EntityMaid)livingEntity;
        maid.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> MaidGuardHandler.handleGuardAttack(event, maid, state));
    }

    private static void handleGuardAttack(LivingAttackEvent event, EntityMaid maid, ISlashBladeState state) {
        LivingEntity attacker = null;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity living;
            attacker = living = (LivingEntity)entity;
        } else {
            entity = event.getSource().m_7639_();
            if (entity instanceof OwnableEntity) {
                OwnableEntity ownable = (OwnableEntity)entity;
                attacker = ownable.m_269323_();
            }
        }
        if (attacker != null) {
            MaidGuardHandler.trickToTarget(maid, attacker);
        }
        if (!SlashBladeMaidBauble.Guard.checkBauble(maid)) {
            return;
        }
        boolean hasTruePower = SlashBladeMaidBauble.TruePower.checkBauble(maid);
        CompoundTag data = maid.getPersistentData();
        if (!MaidGuardHandler.isGuarding(maid)) {
            boolean shouldGuard;
            data.m_128405_(GUARD_DAMAGE_COUNTER, data.m_128451_(GUARD_DAMAGE_COUNTER) + 150);
            data.m_128350_(GUARD_TOTAL_DAMAGE_COUNTER, data.m_128457_(GUARD_TOTAL_DAMAGE_COUNTER) + event.getAmount());
            boolean bl = shouldGuard = data.m_128451_(GUARD_DAMAGE_COUNTER) > 500 || data.m_128457_(GUARD_TOTAL_DAMAGE_COUNTER) > maid.m_21233_() * 0.2f;
            if (shouldGuard && data.m_128451_(GUARD_COOL_DOWN) <= 0) {
                data.m_128405_(GUARD_DAMAGE_COUNTER, 0);
                data.m_128350_(GUARD_TOTAL_DAMAGE_COUNTER, 0.0f);
                data.m_128405_(GUARD_ESCAPE_COUNTER, 100);
                data.m_128350_(GUARD_DAMAGE, maid.m_21233_() * (hasTruePower ? 1.0f : 0.2f));
            }
        } else {
            boolean isProjectile;
            boolean bl = isProjectile = event.getSource().m_269533_(DamageTypeTags.f_268524_) || event.getSource().m_7640_() instanceof Projectile;
            if (!isProjectile) {
                int soulSpeedLevel = maid.m_21205_().getEnchantmentLevel(Enchantments.f_44976_);
                int justAcceptancePeriod = 3 + soulSpeedLevel;
                if (hasTruePower && maid.m_9236_().m_46467_() - data.m_128454_("truePowerOfMaid.lastDoSlashTime") < (long)justAcceptancePeriod) {
                    Untouchable.setUntouchable((LivingEntity)maid, (int)10);
                } else {
                    float guardDamage = data.m_128457_(GUARD_DAMAGE);
                    if (guardDamage >= event.getAmount()) {
                        data.m_128350_(GUARD_DAMAGE, guardDamage - event.getAmount());
                        state.updateComboSeq((LivingEntity)maid, ComboStateRegistry.COMBO_A1_END2.getId());
                    } else {
                        data.m_128350_(GUARD_DAMAGE, 0.0f);
                        data.m_128405_(GUARD_COOL_DOWN, 600);
                        state.updateComboSeq((LivingEntity)maid, ComboStateRegistry.COMBO_A1.getId());
                        data.m_128405_(PRE_ESCAPE_COUNTER, 5);
                        data.m_128379_(IS_PRE_ESCAPING, true);
                    }
                    if (SlashBladeMaidBauble.Health.checkBauble(maid)) {
                        maid.m_5634_((float)Math.min((double)maid.m_21233_() * 0.1, (double)event.getAmount() * 0.1));
                    }
                }
            }
            event.setCanceled(true);
        }
    }

    public static void trickToTarget(EntityMaid maid, LivingEntity target) {
        boolean canAirTrick;
        Level level = maid.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            maid.refreshBrain(serverLevel);
        }
        maid.m_6710_(target);
        CompoundTag data = maid.getPersistentData();
        boolean canTrick = MaidSlashBladeMovementUtils.canTrick(maid);
        boolean bl = canAirTrick = canTrick && SlashBladeMaidBauble.MirageBlade.checkBauble(maid);
        if (canAirTrick) {
            if (!((Boolean)MrqxSlayerStyleArts.AIR_TRICK.apply(maid, true)).booleanValue()) {
                MaidSlashBladeMovementUtils.TRY_TRICK_TO_TARGET.accept(maid, target);
            }
            data.m_128405_("truePowerOfMaid.trickCooldown", 60);
            maid.m_9236_().m_7605_((Entity)maid, (byte)46);
        } else if (canTrick) {
            MaidSlashBladeMovementUtils.TRY_TRICK_TO_TARGET.accept(maid, target);
            data.m_128405_("truePowerOfMaid.trickCooldown", 60);
            maid.m_9236_().m_7605_((Entity)maid, (byte)46);
        }
    }

    public static boolean isGuarding(EntityMaid maid) {
        return maid.getPersistentData().m_128457_(GUARD_DAMAGE) > 0.0f && SlashBladeMaidBauble.Guard.checkBauble(maid);
    }

    public static void guardRefreshMaidTickCounter(EntityMaid maid) {
        CompoundTag data = maid.getPersistentData();
        data.m_128405_("truePowerOfMaid.heavyRainSwordCounter", 0);
        data.m_128405_("truePowerOfMaid.blisteringSwordCounter", 0);
        data.m_128405_("truePowerOfMaid.spiralSwordCounter", 0);
        data.m_128405_("truePowerOfMaid.stormSwordCounter", 0);
        data.m_128405_("truePowerOfMaid.baseSummonedSwordCounter", 0);
        data.m_128405_("truePowerOfMaid.voidSlashCounter", 0);
        data.m_128405_("truePowerOfMaid.superJudgementCutCounter", 0);
        data.m_128405_("truePowerOfMaid.trickCooldown", 0);
        data.m_128405_(GUARD_DAMAGE, 0);
        data.m_128405_(GUARD_DAMAGE_COUNTER, 0);
        data.m_128405_(GUARD_ESCAPE_COUNTER, 0);
        data.m_128405_(PRE_ESCAPE_COUNTER, 0);
        data.m_128405_(GUARD_COOL_DOWN, 0);
    }
}

