/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.slashblade.maidpower.event;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTickEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.UUID;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.concentrationrank.ConcentrationRankCapabilityProvider;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.ModAttributes;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.slasharts.JudgementCut;
import mods.flammpfeil.slashblade.slasharts.SlashArts;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.mrqx.slashblade.maidpower.event.MaidGuardHandler;
import net.mrqx.slashblade.maidpower.item.SlashBladeMaidBauble;
import net.mrqx.slashblade.maidpower.task.TaskSlashBlade;
import net.mrqx.slashblade.maidpower.util.MaidSlashBladeMovementUtils;
import net.mrqx.truepower.util.JustSlashArtManager;

@Mod.EventBusSubscriber
public class MaidTickHandler {
    public static final String TRUE_POWER_RANK = "truePowerOfMaid.truePowerRank";

    @SubscribeEvent
    public static void onMaidTickEvent(MaidTickEvent event) {
        EntityMaid maid = event.getMaid();
        maid.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> MaidTickHandler.handleMaidTick(maid, state));
    }

    private static void handleMaidTick(EntityMaid maid, ISlashBladeState state) {
        boolean canAirTrick;
        boolean hasTruePower = SlashBladeMaidBauble.TruePower.checkBauble(maid);
        CompoundTag data = maid.getPersistentData();
        MaidTickHandler.maidTickCounter(maid, hasTruePower);
        MaidTickHandler.maidBonus(maid, hasTruePower);
        maid.m_21205_().m_41666_(maid.m_9236_(), (Entity)maid, 0, true);
        if (hasTruePower) {
            maid.getCapability(ConcentrationRankCapabilityProvider.RANK_POINT).ifPresent(rank -> {
                long rankPoint = Math.max(rank.getRankPoint(maid.m_9236_().m_46467_()), data.m_128454_(TRUE_POWER_RANK));
                rank.setRawRankPoint(rankPoint);
                data.m_128356_(TRUE_POWER_RANK, rankPoint);
            });
        }
        ComboState currentState = (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(state.resolvCurrentComboState((LivingEntity)maid));
        boolean canTrick = MaidSlashBladeMovementUtils.canTrick(maid);
        Entity target = state.getTargetEntity(maid.m_9236_());
        boolean bl = canAirTrick = canTrick && SlashBladeMaidBauble.MirageBlade.checkBauble(maid);
        if (target != null) {
            canAirTrick &= target.m_6084_();
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                canAirTrick &= living.m_21223_() > 0.0f;
                maid.m_6710_(living);
            }
        }
        if (currentState != null && !currentState.equals(ComboStateRegistry.NONE.get())) {
            currentState.tickAction((LivingEntity)maid);
        }
        if (canTrick && !canAirTrick) {
            MaidSlashBladeMovementUtils.TRICK_DOWN_CHECK.accept(maid);
        }
        if (MaidGuardHandler.isGuarding(maid)) {
            if (data.m_128451_("truePowerOfMaid.guardEscapeCounter") <= 0) {
                MaidSlashBladeMovementUtils.TRY_TRICK_DODGE.accept(maid);
                MaidGuardHandler.guardRefreshMaidTickCounter(maid);
            }
            state.setFallDecreaseRate(1.0f);
        }
        if (data.m_128471_("truePowerOfMaid.isPreEscaping") && data.m_128451_("truePowerOfMaid.preEscapeCounter") <= 0) {
            MaidSlashBladeMovementUtils.TRY_TRICK_DODGE.accept(maid);
            data.m_128379_("truePowerOfMaid.isPreEscaping", false);
        }
        MaidTickHandler.handleHealthAndExp(maid, state, hasTruePower);
        MaidTickHandler.handleSuperJudgementCut(maid, state, hasTruePower, data);
    }

    private static void handleHealthAndExp(EntityMaid maid, ISlashBladeState state, boolean hasTruePower) {
        int favorabilityLevel = Math.max(1, maid.getFavorabilityManager().getLevel() + 1);
        int cost = Math.max(1, Math.max(0, 4 - favorabilityLevel) / (hasTruePower ? 2 : 1));
        if (SlashBladeMaidBauble.Health.checkBauble(maid) && maid.m_21223_() < maid.m_21233_()) {
            boolean isGuarding = MaidGuardHandler.isGuarding(maid);
            if (!hasTruePower && !isGuarding && maid.m_9236_().m_46467_() % 10L != 0L) {
                return;
            }
            if (state.getProudSoulCount() >= cost) {
                state.setProudSoulCount(state.getProudSoulCount() - cost);
                if (hasTruePower) {
                    maid.m_21153_(Math.max(maid.m_21223_() + (float)(favorabilityLevel * (isGuarding ? 2 : 1)), maid.m_21233_()));
                } else {
                    maid.m_5634_((float)favorabilityLevel * 0.5f);
                }
            }
        }
        if (state.isBroken() && SlashBladeMaidBauble.Exp.checkBauble(maid) && maid.getExperience() >= cost) {
            maid.setExperience(maid.getExperience() - cost);
            state.setDamage(state.getDamage() - favorabilityLevel);
            if (state.getDamage() <= 0) {
                state.setBroken(false);
            }
        }
    }

    private static void handleSuperJudgementCut(EntityMaid maid, ISlashBladeState state, boolean hasTruePower, CompoundTag data) {
        if (hasTruePower && data.m_128451_("truePowerOfMaid.superJudgementCutCounter") <= 0) {
            Map.Entry currentLoc = state.resolvCurrentComboStateTicks((LivingEntity)maid);
            ResourceLocation csLoc = state.getSlashArts().doArts(SlashArts.ArtsType.Super, (LivingEntity)maid);
            if (csLoc != ComboStateRegistry.NONE.getId() && !((ResourceLocation)currentLoc.getValue()).equals((Object)csLoc)) {
                data.m_128405_("truePowerOfMaid.superJudgementCutCounter", 2400);
                AttributeInstance entityReachAttributeInstance = maid.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get());
                if (entityReachAttributeInstance == null) {
                    return;
                }
                double radius = TaskSlashBlade.getRadius(maid);
                int rank = maid.getCapability((Capability)ConcentrationRankCapabilityProvider.RANK_POINT).map((NonNullFunction)(NonNullFunction)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handleSuperJudgementCut$2(com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank ), (Lmods/flammpfeil/slashblade/capability/concentrationrank/IConcentrationRank;)Lmods/flammpfeil/slashblade/capability/concentrationrank/IConcentrationRank$ConcentrationRanks;)((EntityMaid)maid)).orElse(IConcentrationRank.ConcentrationRanks.NONE).level;
                double bonus = radius / Math.max(TargetSelector.getResolvedReach((LivingEntity)maid), 1.0) * (double)rank / 7.0;
                AttributeModifier entityReachBonus = new AttributeModifier(UUID.fromString("a7333e5f-d97e-465c-98c7-281a82396d6b"), "Maid SuperJudgementCut Transient Bonus", bonus, AttributeModifier.Operation.MULTIPLY_TOTAL);
                entityReachAttributeInstance.m_22118_(entityReachBonus);
                JudgementCut.doJudgementCutSuper((LivingEntity)maid);
                entityReachAttributeInstance.m_22130_(entityReachBonus);
            }
        }
    }

    public static void maidTickCounter(EntityMaid maid, boolean hasTruePower) {
        CompoundTag data = maid.getPersistentData();
        int truePower = hasTruePower ? 2 : 1;
        int favorabilityLevel = maid.getFavorabilityManager().getLevel() + 1;
        int decrement = favorabilityLevel * truePower;
        data.m_128405_("truePowerOfMaid.heavyRainSwordCounter", Math.max(0, data.m_128451_("truePowerOfMaid.heavyRainSwordCounter") - decrement));
        data.m_128405_("truePowerOfMaid.blisteringSwordCounter", Math.max(0, data.m_128451_("truePowerOfMaid.blisteringSwordCounter") - decrement));
        data.m_128405_("truePowerOfMaid.spiralSwordCounter", Math.max(0, data.m_128451_("truePowerOfMaid.spiralSwordCounter") - decrement));
        data.m_128405_("truePowerOfMaid.stormSwordCounter", Math.max(0, data.m_128451_("truePowerOfMaid.stormSwordCounter") - decrement));
        data.m_128405_("truePowerOfMaid.baseSummonedSwordCounter", Math.max(0, data.m_128451_("truePowerOfMaid.baseSummonedSwordCounter") - decrement));
        data.m_128405_("truePowerOfMaid.voidSlashCounter", Math.max(0, data.m_128451_("truePowerOfMaid.voidSlashCounter") - decrement));
        data.m_128405_("truePowerOfMaid.superJudgementCutCounter", Math.max(0, data.m_128451_("truePowerOfMaid.superJudgementCutCounter") - decrement));
        data.m_128405_("truePowerOfMaid.trickCooldown", Math.max(0, data.m_128451_("truePowerOfMaid.trickCooldown") - truePower));
        data.m_128405_("truePowerOfMaid.guardDamageCounter", Math.max(0, data.m_128451_("truePowerOfMaid.guardDamageCounter") - truePower));
        data.m_128405_("truePowerOfMaid.guardEscapeCounter", Math.max(0, data.m_128451_("truePowerOfMaid.guardEscapeCounter") - truePower));
        data.m_128405_("truePowerOfMaid.preEscapeCounter", Math.max(0, data.m_128451_("truePowerOfMaid.preEscapeCounter") - truePower));
        data.m_128405_("truePowerOfMaid.guardCooldown", Math.max(0, data.m_128451_("truePowerOfMaid.guardCooldown") - truePower));
        if (!data.m_128441_(TRUE_POWER_RANK)) {
            data.m_128356_(TRUE_POWER_RANK, 2300L);
        }
        data.m_128356_(TRUE_POWER_RANK, Math.min(2400L, data.m_128454_(TRUE_POWER_RANK) + (long)decrement));
        long cooldown = JustSlashArtManager.getJustCooldown((LivingEntity)maid);
        if (cooldown > 0L) {
            JustSlashArtManager.setJustCooldown((LivingEntity)maid, (long)(cooldown -= (long)truePower));
            if (cooldown == 0L) {
                JustSlashArtManager.resetJustCount((LivingEntity)maid);
            }
        }
    }

    public static void maidBonus(EntityMaid maid, boolean hasTruePower) {
        double radius = TargetSelector.getResolvedReach((LivingEntity)maid) * 2.0;
        radius *= radius;
        if (SlashBladeMaidBauble.MirageBlade.checkBauble(maid) || SlashBladeMaidBauble.JudgementCut.checkBauble(maid)) {
            radius *= 3.0;
        }
        AttributeModifier followRangeBonus = new AttributeModifier(UUID.fromString("5a138a12-3f1a-40ab-98cf-9532bd9881ce"), "Maid SlashBlade Bonus", radius, AttributeModifier.Operation.ADDITION);
        AttributeInstance followRangeAttributeInstance = maid.m_21051_(Attributes.f_22277_);
        if (followRangeAttributeInstance == null) {
            return;
        }
        followRangeAttributeInstance.m_22130_(followRangeBonus);
        followRangeAttributeInstance.m_22125_(followRangeBonus);
        IConcentrationRank.ConcentrationRanks rankBonus = maid.getCapability(ConcentrationRankCapabilityProvider.RANK_POINT).map(rp -> rp.getRank(maid.m_20193_().m_46467_())).orElse(IConcentrationRank.ConcentrationRanks.NONE);
        float rankDamageBonus = (float)rankBonus.level / 2.0f;
        if (IConcentrationRank.ConcentrationRanks.S.level <= rankBonus.level) {
            int refine = maid.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(ISlashBladeState::getRefine).orElse(0);
            int expLevel = (int)Math.floor((double)maid.getExperience() / 120.0);
            rankDamageBonus = (float)Math.max((double)rankDamageBonus, hasTruePower ? (double)refine : (double)Math.min(expLevel, refine) * (Double)SlashBladeConfig.REFINE_DAMAGE_MULTIPLIER.get());
        }
        AttributeModifier slashbladeDamageBonus = new AttributeModifier(UUID.fromString("5e800b9e-f7ba-4f48-a018-2acfe422dce6"), "Maid SlashBlade Bonus", (double)rankDamageBonus, AttributeModifier.Operation.ADDITION);
        AttributeInstance slashbladeDamageAttributeInstance = maid.m_21051_((Attribute)ModAttributes.SLASHBLADE_DAMAGE.get());
        if (slashbladeDamageAttributeInstance == null) {
            return;
        }
        slashbladeDamageAttributeInstance.m_22130_(slashbladeDamageBonus);
        slashbladeDamageAttributeInstance.m_22125_(slashbladeDamageBonus);
        AttributeModifier entityReachBonus = new AttributeModifier(UUID.fromString("5dd047e5-bb60-4ebf-93ba-34a1ece10128"), "Maid SlashBlade Bonus", hasTruePower ? 2.5 : 0.5, AttributeModifier.Operation.ADDITION);
        AttributeInstance entityReachAttributeInstance = maid.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get());
        if (entityReachAttributeInstance == null) {
            return;
        }
        entityReachAttributeInstance.m_22130_(entityReachBonus);
        entityReachAttributeInstance.m_22125_(entityReachBonus);
    }

    private static /* synthetic */ IConcentrationRank.ConcentrationRanks lambda$handleSuperJudgementCut$2(EntityMaid maid, IConcentrationRank cr) {
        return cr.getRank(maid.m_9236_().m_46467_());
    }
}

