/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.slashblade.maidpower.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.slasharts.SlashArts;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.KnockBacks;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.IForgeRegistry;
import net.mrqx.slashblade.maidpower.entity.ai.MaidSlashBladeAttack;
import net.mrqx.slashblade.maidpower.event.ChargeActionHandler;
import net.mrqx.slashblade.maidpower.event.api.MaidProgressComboEvent;
import net.mrqx.slashblade.maidpower.item.SlashBladeMaidBauble;
import net.mrqx.slashblade.maidpower.util.MaidSlashBladeMovementUtils;
import net.mrqx.truepower.registry.TruePowerComboStateRegistry;
import net.mrqx.truepower.util.JustSlashArtManager;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.util.TriConsumer;

public class MaidSlashBladeAttackUtils {
    public static final String VOID_SLASH_COUNTER_KEY = "truePowerOfMaid.voidSlashCounter";
    public static final String SUPER_JUDGEMENT_CUT_COUNTER_KEY = "truePowerOfMaid.superJudgementCutCounter";
    public static final BiFunction<EntityMaid, ISlashBladeState, Boolean> TRY_AERIAL_CLEAVE = MaidSlashBladeAttackUtils::tryAerialCleave;
    public static final BiConsumer<EntityMaid, ISlashBladeState> GROUND_ATTACK = MaidSlashBladeAttackUtils::groundAttack;
    public static final BiConsumer<EntityMaid, ISlashBladeState> AIR_ATTACK = MaidSlashBladeAttackUtils::airAttack;
    public static final TriConsumer<EntityMaid, ISlashBladeState, LivingEntity> RAPID_SLASH_ATTACK = MaidSlashBladeAttackUtils::rapidSlashAttack;
    public static final TriConsumer<EntityMaid, ISlashBladeState, LivingEntity> JUDGEMENT_CUT = MaidSlashBladeAttackUtils::judgementCut;
    public static final TriFunction<EntityMaid, ISlashBladeState, LivingEntity, Boolean> TRY_JUDGEMENT_CUT = MaidSlashBladeAttackUtils::tryJudgementCut;
    public static final TriConsumer<EntityMaid, ISlashBladeState, LivingEntity> VOID_SLASH = MaidSlashBladeAttackUtils::voidSlash;
    public static final TriConsumer<EntityMaid, ISlashBladeState, LivingEntity> NORMAL_SLASHBLADE_ATTACK = MaidSlashBladeAttackUtils::normalSlashBladeAttack;

    public static boolean isHoldingSlashBlade(Mob mob) {
        return !mob.m_21205_().m_41619_() && mob.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).isPresent();
    }

    public static boolean canInterruptCombo(EntityMaid maid) {
        return maid.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> {
            ResourceLocation currentLoc = state.resolvCurrentComboState((LivingEntity)maid);
            ComboState current = (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(currentLoc);
            if (current != null) {
                ComboState next = (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(current.getNextOfTimeout((LivingEntity)maid));
                if (SlashBladeMaidBauble.TruePower.checkBauble(maid)) {
                    return !MaidSlashBladeAttack.TRUE_POWER_UNINTERRUPTIBLE_COMBO.contains(current) && !MaidSlashBladeAttack.TRUE_POWER_UNINTERRUPTIBLE_COMBO.contains(next);
                }
                return !MaidSlashBladeAttack.UNINTERRUPTIBLE_COMBO.contains(current) && !MaidSlashBladeAttack.UNINTERRUPTIBLE_COMBO.contains(next);
            }
            return true;
        }).orElse(true);
    }

    private static boolean tryAerialCleave(EntityMaid maid, ISlashBladeState state) {
        if (maid.m_20096_() || !SlashBladeMaidBauble.ComboC.checkBauble(maid)) {
            return false;
        }
        state.updateComboSeq((LivingEntity)maid, ComboStateRegistry.AERIAL_CLEAVE.getId());
        return true;
    }

    private static void groundAttack(EntityMaid maid, ISlashBladeState state) {
        if (maid.m_20096_()) {
            state.updateComboSeq((LivingEntity)maid, ComboStateRegistry.COMBO_A1.getId());
        } else {
            TRY_AERIAL_CLEAVE.apply(maid, state);
        }
    }

    private static void airAttack(EntityMaid maid, ISlashBladeState state) {
        if (!state.resolvCurrentComboState((LivingEntity)maid).equals((Object)ComboStateRegistry.UPPERSLASH.getId())) {
            if (maid.m_20096_()) {
                if (SlashBladeMaidBauble.RapidSlash.checkBauble(maid)) {
                    state.updateComboSeq((LivingEntity)maid, ComboStateRegistry.RAPID_SLASH.getId());
                } else {
                    state.updateComboSeq((LivingEntity)maid, ComboStateRegistry.UPPERSLASH.getId());
                }
            } else {
                state.updateComboSeq((LivingEntity)maid, ComboStateRegistry.AERIAL_RAVE_A1.getId());
            }
        }
    }

    private static void rapidSlashAttack(EntityMaid maid, ISlashBladeState state, LivingEntity target) {
        ResourceLocation currentLoc = state.resolvCurrentComboState((LivingEntity)maid);
        ComboState current = (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(currentLoc);
        maid.m_7618_(EntityAnchorArgument.Anchor.FEET, target.m_20182_());
        if (current != null) {
            ResourceLocation next = current.getNext((LivingEntity)maid);
            if ((currentLoc.equals((Object)ComboStateRegistry.NONE.getId()) || next.equals((Object)ComboStateRegistry.NONE.getId())) && maid.m_20096_()) {
                state.updateComboSeq((LivingEntity)maid, ComboStateRegistry.RAPID_SLASH.getId());
            }
        }
    }

    private static void judgementCut(EntityMaid maid, ISlashBladeState state, LivingEntity target) {
        boolean canJudgementCut;
        ResourceLocation currentLoc = state.resolvCurrentComboState((LivingEntity)maid);
        boolean bl = canJudgementCut = !ChargeActionHandler.isJudgementCut(currentLoc) || SlashBladeMaidBauble.TruePower.checkBauble(maid);
        if (canJudgementCut) {
            SlashArts.ArtsType type;
            int elapsed;
            maid.m_7618_(EntityAnchorArgument.Anchor.FEET, target.m_20182_());
            if (SlashBladeMaidBauble.JustJudgementCut.checkBauble(maid)) {
                elapsed = 10;
                type = SlashArts.ArtsType.Jackpot;
            } else {
                elapsed = 20;
                type = SlashArts.ArtsType.Success;
            }
            ResourceLocation comboLoc = ((SlashArts)SlashArtsRegistry.JUDGEMENT_CUT.get()).doArts(type, (LivingEntity)maid);
            SlashBladeEvent.ChargeActionEvent event = new SlashBladeEvent.ChargeActionEvent((LivingEntity)maid, elapsed, state, comboLoc, type);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                comboLoc = event.getComboState();
                ComboState combo = (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(comboLoc);
                if (combo != null && comboLoc != ComboStateRegistry.NONE.getId()) {
                    state.updateComboSeq((LivingEntity)maid, comboLoc);
                }
            }
        }
    }

    private static Boolean tryJudgementCut(EntityMaid maid, ISlashBladeState state, LivingEntity target) {
        if (!SlashBladeMaidBauble.JudgementCut.checkBauble(maid) || JustSlashArtManager.getJustCooldown((LivingEntity)maid) > 0L) {
            return false;
        }
        ResourceLocation currentLoc = state.resolvCurrentComboState((LivingEntity)maid);
        ComboState current = (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(currentLoc);
        if (current != null) {
            ComboState next = (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(current.getNextOfTimeout((LivingEntity)maid));
            boolean just = SlashBladeMaidBauble.JustJudgementCut.checkBauble(maid);
            if (SlashBladeMaidBauble.TruePower.checkBauble(maid) && MaidSlashBladeAttack.TRUE_POWER_CHARGE_COMBO.contains(current)) {
                JUDGEMENT_CUT.accept((Object)maid, (Object)state, (Object)target);
                return true;
            }
            if (just && MaidSlashBladeAttack.QUICK_CHARGE_COMBO.contains(current)) {
                JUDGEMENT_CUT.accept((Object)maid, (Object)state, (Object)target);
                return true;
            }
            if (MaidSlashBladeAttack.CHARGE_COMBO.contains(current)) {
                JUDGEMENT_CUT.accept((Object)maid, (Object)state, (Object)target);
                return true;
            }
            return just && MaidSlashBladeAttack.QUICK_CHARGE_COMBO.contains(next);
        }
        return false;
    }

    private static void voidSlash(EntityMaid maid, ISlashBladeState state, LivingEntity target) {
        MaidSlashBladeMovementUtils.TRY_TRICK_TO_TARGET.accept(maid, target);
        state.updateComboSeq((LivingEntity)maid, TruePowerComboStateRegistry.VOID_SLASH.getId());
    }

    private static void normalSlashBladeAttack(EntityMaid maid, ISlashBladeState state, LivingEntity target) {
        ResourceLocation currentLoc = state.resolvCurrentComboState((LivingEntity)maid);
        ComboState current = (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(currentLoc);
        CompoundTag data = maid.getPersistentData();
        maid.m_7618_(EntityAnchorArgument.Anchor.FEET, target.m_20182_());
        if (current != null) {
            ResourceLocation nextLoc = current.getNext((LivingEntity)maid);
            if (currentLoc.equals((Object)ComboStateRegistry.NONE.getId()) || nextLoc.equals((Object)ComboStateRegistry.NONE.getId())) {
                JustSlashArtManager.resetJustCount((LivingEntity)maid);
                if (SlashBladeMaidBauble.VoidSlash.checkBauble(maid) && data.m_128451_(VOID_SLASH_COUNTER_KEY) <= 0) {
                    VOID_SLASH.accept((Object)maid, (Object)state, (Object)target);
                    data.m_128405_(VOID_SLASH_COUNTER_KEY, 1000);
                } else if (SlashBladeMaidBauble.AirCombo.checkBauble(maid)) {
                    AIR_ATTACK.accept(maid, state);
                } else {
                    GROUND_ATTACK.accept(maid, state);
                }
            } else if (current.equals(ComboStateRegistry.RAPID_SLASH.get()) && SlashBladeMaidBauble.AirCombo.checkBauble(maid) && MaidSlashBladeAttackUtils.canInterruptCombo(maid)) {
                List hits = AttackManager.areaAttack((LivingEntity)maid, (Consumer)KnockBacks.toss.action, (float)0.44f, (boolean)true, (boolean)true, (boolean)true);
                if (!hits.isEmpty()) {
                    state.updateComboSeq((LivingEntity)maid, ComboStateRegistry.RISING_STAR.getId());
                    AdvancementHelper.grantCriterion((LivingEntity)maid, (ResourceLocation)AdvancementHelper.ADVANCEMENT_RISING_STAR);
                }
            } else if (!nextLoc.equals((Object)currentLoc)) {
                MaidProgressComboEvent event = new MaidProgressComboEvent(maid, target, currentLoc, nextLoc);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (!event.isCanceled()) {
                    state.progressCombo((LivingEntity)maid);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BiConsumer<Long, Integer> setClientRank() {
        return (point, entityId) -> {
            Entity entity;
            if (Minecraft.m_91087_().f_91073_ != null && (entity = Minecraft.m_91087_().f_91073_.m_6815_(entityId.intValue())) != null) {
                entity.getCapability(CapabilityConcentrationRank.RANK_POINT).ifPresent(cr -> {
                    long time = entity.m_9236_().m_46467_();
                    IConcentrationRank.ConcentrationRanks oldRank = cr.getRank(time);
                    cr.setRawRankPoint(point.longValue());
                    cr.setLastUpdte(time);
                    if (oldRank.level < cr.getRank((long)time).level) {
                        cr.setLastRankRise(time);
                    }
                });
            }
        };
    }
}

