/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.slashblade.maidpower.client.renderer;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrqx.slashblade.maidpower.config.TruePowerOfMaidClientConfig;
import net.mrqx.slashblade.maidpower.task.TaskSlashBlade;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class MaidRankRenderer {
    public static final ResourceLocation RANK_IMG = new ResourceLocation("slashblade", "textures/gui/rank.png");

    @SubscribeEvent
    public static void onRenderLiving(RenderLivingEvent<?, ?> event) {
        EntityMaid maid;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid && (maid = (EntityMaid)livingEntity).getTask().getUid().equals((Object)TaskSlashBlade.UID)) {
            maid.getCapability(CapabilityConcentrationRank.RANK_POINT).ifPresent(cr -> {
                long now = maid.m_9236_().m_46467_();
                LivingEntityRenderer renderer = event.getRenderer();
                IConcentrationRank.ConcentrationRanks rank = cr.getRank(now);
                if (rank != IConcentrationRank.ConcentrationRanks.NONE) {
                    PoseStack poseStack = event.getPoseStack();
                    float maidHeight = maid.m_20206_() + 0.5f;
                    poseStack.m_85836_();
                    poseStack.m_85837_(0.0, (double)maidHeight, 0.0);
                    poseStack.m_252781_(renderer.f_114476_.m_253208_());
                    float size = ((Double)TruePowerOfMaidClientConfig.MAID_RANK_SIZE.get()).floatValue();
                    poseStack.m_85841_(-size, -size, size);
                    boolean depthTestEnabled = GL11.glIsEnabled((int)2929);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.disableDepthTest();
                    TextureManager texturemanager = Minecraft.m_91087_().m_91097_();
                    texturemanager.m_118506_(RANK_IMG).m_117960_(false, false);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)RANK_IMG);
                    boolean showTextRank = false;
                    long textTimeout = cr.getLastRankRise() + 20L;
                    if (now < textTimeout) {
                        showTextRank = true;
                    }
                    int x = (Integer)TruePowerOfMaidClientConfig.MAID_RANK_X.get();
                    int y = (Integer)TruePowerOfMaidClientConfig.MAID_RANK_Y.get();
                    int rankOffset = 32 * (rank.level - 1);
                    int textOffset = showTextRank ? 128 : 0;
                    int progress = (int)(33.0f * cr.getRankProgress(now));
                    int progressIcon = (int)(18.0f * cr.getRankProgress(now));
                    int progressIconInv = 17 - progressIcon;
                    MaidRankRenderer.drawTexturedQuad(poseStack, x, y, textOffset + 64, rankOffset, 64, 32, 0.0f);
                    MaidRankRenderer.drawTexturedQuad(poseStack, x, y + progressIconInv + 7, textOffset, rankOffset + progressIconInv + 7, 64, progressIcon, 0.0f);
                    MaidRankRenderer.drawTexturedQuad(poseStack, x, y + 32, 0, 240, 64, 16, 0.0f);
                    MaidRankRenderer.drawTexturedQuad(poseStack, x + 16, y + 32, 16, 224, progress, 16, 0.0f);
                    if (depthTestEnabled) {
                        RenderSystem.enableDepthTest();
                    } else {
                        RenderSystem.disableDepthTest();
                    }
                    poseStack.m_85849_();
                }
            });
        }
    }

    public static void drawTexturedQuad(PoseStack poseStack, int x, int y, int u, int v, int width, int height, float zLevel) {
        float f = 0.00390625f;
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder wr = tesselator.m_85915_();
        wr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f m = poseStack.m_85850_().m_252922_();
        wr.m_252986_(m, (float)x, (float)(y + height), zLevel).m_7421_(((float)u + 0.0f) * f, (float)(v + height) * f).m_5752_();
        wr.m_252986_(m, (float)(x + width), (float)(y + height), zLevel).m_7421_((float)(u + width) * f, (float)(v + height) * f).m_5752_();
        wr.m_252986_(m, (float)(x + width), (float)y, zLevel).m_7421_((float)(u + width) * f, (float)v * f).m_5752_();
        wr.m_252986_(m, (float)x, (float)y, zLevel).m_7421_((float)u * f, (float)v * f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)wr.m_231175_());
    }
}

