/*
 * Decompiled with CFR 0.152.
 */
package sol_valheim_reforged.configuration;

import net.neoforged.neoforge.common.ModConfigSpec;

public class CommonConfiguration {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<Double> BASE_HEALTH;
    public static final ModConfigSpec.ConfigValue<Double> BASE_REGEN_RATE;
    public static final ModConfigSpec.ConfigValue<Double> REGEN_COOLDOWN;
    public static final ModConfigSpec.ConfigValue<Double> FOOD_DURATION;
    public static final ModConfigSpec.ConfigValue<Boolean> BONUS_DURATION;
    public static final ModConfigSpec.ConfigValue<Boolean> TIMEOUT_DAMAGE;
    public static final ModConfigSpec.ConfigValue<Boolean> SLEEP_DEPLETION;
    public static final ModConfigSpec.ConfigValue<Boolean> ALLOW_SATURATION;

    static {
        BUILDER.push("starting health");
        BASE_HEALTH = BUILDER.comment("Number of hearts the player starts with (2 health = 1 heart) (range 2-20, default 6)").define("base_health", (Object)6.0);
        BUILDER.pop();
        BUILDER.push("regen factor");
        BASE_REGEN_RATE = BUILDER.comment("Time it takes (in ticks) for the player to passively regain 1 health (\u00bd heart) (range 20-200, default 100)").define("base_regen_rate", (Object)100.0);
        BUILDER.pop();
        BUILDER.push("regen cooldown");
        REGEN_COOLDOWN = BUILDER.comment("Delay (in ticks) before regeneration starts after taking damage (range 20-600, default 60) (0 to disable the cooldown)").define("regen_cooldown", (Object)60.0);
        BUILDER.pop();
        BUILDER.push("food duration");
        FOOD_DURATION = BUILDER.comment("Time (in seconds) that food should last per saturation level (range 60-600, default 180)").define("food_duration", (Object)180.0);
        BUILDER.pop();
        BUILDER.push("unstackable food duration");
        BONUS_DURATION = BUILDER.comment("Increased duration for food items that don't stack up to 64 (boolean, default = true)").define("bonus_duration", true);
        BUILDER.pop();
        BUILDER.push("food timeout damage");
        TIMEOUT_DAMAGE = BUILDER.comment("Damages the player when the timer of a food slot runs out (boolean, default = true)").define("timeout_damage", true);
        BUILDER.pop();
        BUILDER.push("food depletion during sleep");
        SLEEP_DEPLETION = BUILDER.comment("Sleeping consumes half the duration of current eaten foods (boolean, default = false)").define("sleep_depletion", false);
        BUILDER.pop();
        BUILDER.push("saturation handling");
        ALLOW_SATURATION = BUILDER.comment("Allows consumables to apply saturation and food-related effects (not recommended) (boolean, default = false)").define("allow_saturation", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

