/*
 * Decompiled with CFR 0.152.
 */
package sol_valheim_reforged.network;

import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import sol_valheim_reforged.SolValheimReforgedMod;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class SolValheimReforgedModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"sol_valheim_reforged");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        SolValheimReforgedMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"sol_valheim_reforged", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public ItemStack last_consumed_1 = ItemStack.EMPTY;
        public ItemStack last_consumed_2 = ItemStack.EMPTY;
        public ItemStack last_consumed_3 = ItemStack.EMPTY;
        public double last_consumed_1_duration = 0.0;
        public double last_consumed_2_duration = 0.0;
        public double last_consumed_3_duration = 0.0;
        public double health_boost_slot_1 = 0.0;
        public double health_boost_slot_2 = 0.0;
        public double health_boost_slot_3 = 0.0;
        public double regen_factor_slot_1 = 0.0;
        public double regen_factor_slot_2 = 0.0;
        public double regen_factor_slot_3 = 0.0;
        public double regen_factor = 100.0;
        public double overlay_x = 0.0;
        public double overlay_y = 0.0;
        public double regen_cooldown = 0.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.put("last_consumed_1", this.last_consumed_1.saveOptional(lookupProvider));
            nbt.put("last_consumed_2", this.last_consumed_2.saveOptional(lookupProvider));
            nbt.put("last_consumed_3", this.last_consumed_3.saveOptional(lookupProvider));
            nbt.putDouble("last_consumed_1_duration", this.last_consumed_1_duration);
            nbt.putDouble("last_consumed_2_duration", this.last_consumed_2_duration);
            nbt.putDouble("last_consumed_3_duration", this.last_consumed_3_duration);
            nbt.putDouble("health_boost_slot_1", this.health_boost_slot_1);
            nbt.putDouble("health_boost_slot_2", this.health_boost_slot_2);
            nbt.putDouble("health_boost_slot_3", this.health_boost_slot_3);
            nbt.putDouble("regen_factor_slot_1", this.regen_factor_slot_1);
            nbt.putDouble("regen_factor_slot_2", this.regen_factor_slot_2);
            nbt.putDouble("regen_factor_slot_3", this.regen_factor_slot_3);
            nbt.putDouble("regen_factor", this.regen_factor);
            nbt.putDouble("overlay_x", this.overlay_x);
            nbt.putDouble("overlay_y", this.overlay_y);
            nbt.putDouble("regen_cooldown", this.regen_cooldown);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.last_consumed_1 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("last_consumed_1"));
            this.last_consumed_2 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("last_consumed_2"));
            this.last_consumed_3 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("last_consumed_3"));
            this.last_consumed_1_duration = nbt.getDouble("last_consumed_1_duration");
            this.last_consumed_2_duration = nbt.getDouble("last_consumed_2_duration");
            this.last_consumed_3_duration = nbt.getDouble("last_consumed_3_duration");
            this.health_boost_slot_1 = nbt.getDouble("health_boost_slot_1");
            this.health_boost_slot_2 = nbt.getDouble("health_boost_slot_2");
            this.health_boost_slot_3 = nbt.getDouble("health_boost_slot_3");
            this.regen_factor_slot_1 = nbt.getDouble("regen_factor_slot_1");
            this.regen_factor_slot_2 = nbt.getDouble("regen_factor_slot_2");
            this.regen_factor_slot_3 = nbt.getDouble("regen_factor_slot_3");
            this.regen_factor = nbt.getDouble("regen_factor");
            this.overlay_x = nbt.getDouble("overlay_x");
            this.overlay_y = nbt.getDouble("overlay_y");
            this.regen_cooldown = nbt.getDouble("regen_cooldown");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.last_consumed_1 = original.last_consumed_1;
            clone.last_consumed_2 = original.last_consumed_2;
            clone.last_consumed_3 = original.last_consumed_3;
            clone.last_consumed_1_duration = original.last_consumed_1_duration;
            clone.last_consumed_2_duration = original.last_consumed_2_duration;
            clone.last_consumed_3_duration = original.last_consumed_3_duration;
            clone.health_boost_slot_1 = original.health_boost_slot_1;
            clone.health_boost_slot_2 = original.health_boost_slot_2;
            clone.health_boost_slot_3 = original.health_boost_slot_3;
            clone.regen_factor_slot_1 = original.regen_factor_slot_1;
            clone.regen_factor_slot_2 = original.regen_factor_slot_2;
            clone.regen_factor_slot_3 = original.regen_factor_slot_3;
            clone.regen_factor = original.regen_factor;
            clone.overlay_x = original.overlay_x;
            clone.overlay_y = original.overlay_y;
            clone.regen_cooldown = original.regen_cooldown;
            if (!event.isWasDeath()) {
                // empty if block
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }
    }
}

