/*
 * Decompiled with CFR 0.152.
 */
package sol_valheim_reforged.procedures;

import javax.annotation.Nullable;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import sol_valheim_reforged.configuration.CommonConfiguration;
import sol_valheim_reforged.network.SolValheimReforgedModVariables;
import sol_valheim_reforged.procedures.HealthCheckProcedure;
import sol_valheim_reforged.procedures.PlayerResetProcedure;

@EventBusSubscriber
public class FoodConsumedProcedure {
    @SubscribeEvent
    public static void onUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntity() != null) {
            FoodConsumedProcedure.execute((Event)event, (LevelAccessor)event.getEntity().level(), (Entity)event.getEntity(), event.getItem());
        }
    }

    public static void execute(LevelAccessor world, Entity entity, ItemStack itemstack) {
        FoodConsumedProcedure.execute(null, world, entity, itemstack);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, Entity entity, ItemStack itemstack) {
        if (entity == null) {
            return;
        }
        double local_duration = 0.0;
        double local_health_boost = 0.0;
        double local_regen_factor = 0.0;
        double food_duration = 0.0;
        if (itemstack.has(DataComponents.FOOD) && !itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"sol_valheim_reforged:not_food")))) {
            if (itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"sol_valheim_reforged:spoiled_food")))) {
                if (entity instanceof Player) {
                    Player _player = (Player)entity;
                    _player.getCooldowns().addCooldown(itemstack.getItem(), 600);
                }
                entity.hurt(new DamageSource(world.holderOrThrow(DamageTypes.STARVE)), 1.0f);
                PlayerResetProcedure.execute(entity);
            } else {
                if (itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"sol_valheim_reforged:low_nutrients")))) {
                    local_health_boost = 1.0;
                    local_regen_factor = 5.0;
                    local_duration = 6000.0;
                } else if (itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"sol_valheim_reforged:high_nutrients")))) {
                    local_health_boost = 14.0;
                    local_regen_factor = 70.0;
                    local_duration = 72000.0;
                } else {
                    local_health_boost = itemstack.has(DataComponents.FOOD) ? (double)itemstack.getFoodProperties(null).nutrition() : 0.0;
                    local_regen_factor = (itemstack.has(DataComponents.FOOD) ? itemstack.getFoodProperties(null).nutrition() : 0) * 5;
                    food_duration = Math.min(Math.max((Double)CommonConfiguration.FOOD_DURATION.get(), 60.0), 600.0) / 120.0;
                    local_duration = itemstack.getMaxStackSize() <= 16 && (Boolean)CommonConfiguration.BONUS_DURATION.get() == true ? Math.min(Math.max((double)(itemstack.has(DataComponents.FOOD) ? itemstack.getFoodProperties(null).saturation() : 0.0f) * food_duration * 1440.0, 6000.0), 72000.0) : Math.min(Math.max((double)(itemstack.has(DataComponents.FOOD) ? itemstack.getFoodProperties(null).saturation() : 0.0f) * food_duration * 1200.0, 6000.0), 72000.0);
                }
                if ((((SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES)).last_consumed_3.getItem() == ItemStack.EMPTY.getItem() || ((SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES)).last_consumed_3.getItem() == itemstack.getItem()) && ((SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES)).last_consumed_2.getItem() != itemstack.getItem() && ((SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES)).last_consumed_1.getItem() != itemstack.getItem()) {
                    _vars = (SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES);
                    _vars.last_consumed_3 = itemstack.copy();
                    _vars.syncPlayerVariables(entity);
                    _vars = (SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES);
                    _vars.last_consumed_3_duration = local_duration;
                    _vars.syncPlayerVariables(entity);
                    _vars = (SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES);
                    _vars.health_boost_slot_3 = local_health_boost;
                    _vars.syncPlayerVariables(entity);
                    _vars = (SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES);
                    _vars.regen_factor_slot_3 = local_regen_factor;
                    _vars.syncPlayerVariables(entity);
                    HealthCheckProcedure.execute(entity);
                    if (entity instanceof LivingEntity) {
                        float f;
                        _entity = (LivingEntity)entity;
                        if (entity instanceof LivingEntity) {
                            LivingEntity _livEnt = (LivingEntity)entity;
                            f = _livEnt.getHealth();
                        } else {
                            f = -1.0f;
                        }
                        _entity.setHealth(f + (float)(itemstack.has(DataComponents.FOOD) ? itemstack.getFoodProperties(null).nutrition() : 0));
                    }
                } else if ((((SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES)).last_consumed_2.getItem() == ItemStack.EMPTY.getItem() || ((SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES)).last_consumed_2.getItem() == itemstack.getItem()) && ((SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES)).last_consumed_3.getItem() != itemstack.getItem() && ((SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES)).last_consumed_1.getItem() != itemstack.getItem()) {
                    _vars = (SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES);
                    _vars.last_consumed_2 = itemstack.copy();
                    _vars.syncPlayerVariables(entity);
                    _vars = (SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES);
                    _vars.last_consumed_2_duration = local_duration;
                    _vars.syncPlayerVariables(entity);
                    _vars = (SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES);
                    _vars.health_boost_slot_2 = local_health_boost;
                    _vars.syncPlayerVariables(entity);
                    _vars = (SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES);
                    _vars.regen_factor_slot_2 = local_regen_factor;
                    _vars.syncPlayerVariables(entity);
                    HealthCheckProcedure.execute(entity);
                    if (entity instanceof LivingEntity) {
                        float f;
                        _entity = (LivingEntity)entity;
                        if (entity instanceof LivingEntity) {
                            LivingEntity _livEnt = (LivingEntity)entity;
                            f = _livEnt.getHealth();
                        } else {
                            f = -1.0f;
                        }
                        _entity.setHealth(f + (float)(itemstack.has(DataComponents.FOOD) ? itemstack.getFoodProperties(null).nutrition() : 0));
                    }
                } else if ((((SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES)).last_consumed_1.getItem() == ItemStack.EMPTY.getItem() || ((SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES)).last_consumed_1.getItem() == itemstack.getItem()) && ((SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES)).last_consumed_3.getItem() != itemstack.getItem() && ((SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES)).last_consumed_2.getItem() != itemstack.getItem()) {
                    _vars = (SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES);
                    _vars.last_consumed_1 = itemstack.copy();
                    _vars.syncPlayerVariables(entity);
                    _vars = (SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES);
                    _vars.last_consumed_1_duration = local_duration;
                    _vars.syncPlayerVariables(entity);
                    _vars = (SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES);
                    _vars.health_boost_slot_1 = local_health_boost;
                    _vars.syncPlayerVariables(entity);
                    _vars = (SolValheimReforgedModVariables.PlayerVariables)entity.getData(SolValheimReforgedModVariables.PLAYER_VARIABLES);
                    _vars.regen_factor_slot_1 = local_regen_factor;
                    _vars.syncPlayerVariables(entity);
                    HealthCheckProcedure.execute(entity);
                    if (entity instanceof LivingEntity) {
                        float f;
                        _entity = (LivingEntity)entity;
                        if (entity instanceof LivingEntity) {
                            LivingEntity _livEnt = (LivingEntity)entity;
                            f = _livEnt.getHealth();
                        } else {
                            f = -1.0f;
                        }
                        _entity.setHealth(f + (float)(itemstack.has(DataComponents.FOOD) ? itemstack.getFoodProperties(null).nutrition() : 0));
                    }
                }
                if (!((Boolean)CommonConfiguration.ALLOW_SATURATION.get()).booleanValue()) {
                    Entity _ent = entity;
                    if (!_ent.level().isClientSide() && _ent.getServer() != null) {
                        _ent.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, _ent.position(), _ent.getRotationVector(), _ent.level() instanceof ServerLevel ? (ServerLevel)_ent.level() : null, 4, _ent.getName().getString(), _ent.getDisplayName(), _ent.level().getServer(), _ent), "effect clear @s farmersdelight:nourishment");
                    }
                    if (!(_ent = entity).level().isClientSide() && _ent.getServer() != null) {
                        _ent.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, _ent.position(), _ent.getRotationVector(), _ent.level() instanceof ServerLevel ? (ServerLevel)_ent.level() : null, 4, _ent.getName().getString(), _ent.getDisplayName(), _ent.level().getServer(), _ent), "effect clear @s farmersdelight:comfort");
                    }
                    if (!(_ent = entity).level().isClientSide() && _ent.getServer() != null) {
                        _ent.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, _ent.position(), _ent.getRotationVector(), _ent.level() instanceof ServerLevel ? (ServerLevel)_ent.level() : null, 4, _ent.getName().getString(), _ent.getDisplayName(), _ent.level().getServer(), _ent), "effect clear @s minecraft:saturation");
                    }
                }
            }
        }
    }
}

