/*
 * Decompiled with CFR 0.152.
 */
package sol_valheim_reforged.procedures;

import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import sol_valheim_reforged.configuration.CommonConfiguration;

@EventBusSubscriber(value={Dist.CLIENT})
public class TooltipsProcedure {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        TooltipsProcedure.execute((Event)event, event.getItemStack(), event.getToolTip());
    }

    public static void execute(ItemStack itemstack, List<Component> tooltip) {
        TooltipsProcedure.execute(null, itemstack, tooltip);
    }

    private static void execute(@Nullable Event event, ItemStack itemstack, List<Component> tooltip) {
        if (tooltip == null) {
            return;
        }
        double food_duration = 0.0;
        double local_regen_factor = 0.0;
        double local_duration = 0.0;
        double local_health_boost = 0.0;
        if (itemstack.getFoodProperties(null) != null && itemstack.getFoodProperties(null).nutrition() > 0 && itemstack.getFoodProperties(null).saturation() > 0.0f && !itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"sol_valheim_reforged:not_food")))) {
            if (itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"sol_valheim_reforged:spoiled_food")))) {
                tooltip.add((Component)Component.literal((String)"\u00a7a\u2620 Empties your stomach"));
            } else if (itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"sol_valheim_reforged:low_nutrients")))) {
                tooltip.add((Component)Component.literal((String)"\u00a7c\u2764 0.5 Hearts"));
                tooltip.add((Component)Component.literal((String)"\u00a74\u2600 5 Regen"));
                tooltip.add((Component)Component.literal((String)"\u00a76\u231a 5 Minutes"));
            } else if (itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"sol_valheim_reforged:high_nutrients")))) {
                tooltip.add((Component)Component.literal((String)"\u00a7c\u2764 7 Hearts"));
                tooltip.add((Component)Component.literal((String)"\u00a74\u2600 70 Regen"));
                tooltip.add((Component)Component.literal((String)"\u00a76\u231a 60 Minutes"));
            } else {
                tooltip.add((Component)Component.literal((String)new DecimalFormat("\u00a7c\u2764 #0.# Hearts").format((double)(itemstack.has(DataComponents.FOOD) ? itemstack.getFoodProperties(null).nutrition() : 0) * 0.5)));
                tooltip.add((Component)Component.literal((String)new DecimalFormat("\u00a74\u2600 ## Regen").format((itemstack.has(DataComponents.FOOD) ? itemstack.getFoodProperties(null).nutrition() : 0) * 5)));
                food_duration = Math.min(Math.max((Double)CommonConfiguration.FOOD_DURATION.get(), 60.0), 600.0) / 120.0;
                if (itemstack.getMaxStackSize() <= 16 && ((Boolean)CommonConfiguration.BONUS_DURATION.get()).booleanValue()) {
                    tooltip.add((Component)Component.literal((String)new DecimalFormat("\u00a76\u231a ## Minutes").format(Math.min(Math.max((double)(itemstack.has(DataComponents.FOOD) ? itemstack.getFoodProperties(null).saturation() : 0.0f) * 1.2 * food_duration, 5.0), 60.0))));
                } else {
                    tooltip.add((Component)Component.literal((String)new DecimalFormat("\u00a76\u231a ## Minutes").format(Math.min(Math.max((double)(itemstack.has(DataComponents.FOOD) ? itemstack.getFoodProperties(null).saturation() : 0.0f) * food_duration, 5.0), 60.0))));
                }
            }
            if (itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"sol_valheim_reforged:always_edible")))) {
                tooltip.add((Component)Component.literal((String)"\u00a77Always edible"));
            }
        } else if (itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"sol_valheim_reforged:cakes"))) || itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"sol_valheim_reforged:sliceable_food")))) {
            tooltip.add((Component)Component.literal((String)"\u00a77Heals 2 \u00a7c\u2764 \u00a77per slice"));
        }
    }
}

