/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.vitalVials.Commands;

import io.github.b4n9z.vitalVials.Managers.EffectDataManager;
import io.github.b4n9z.vitalVials.Managers.HealthManager;
import io.github.b4n9z.vitalVials.Managers.TransactionManager;
import io.github.b4n9z.vitalVials.VitalVials;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RefundEffectCommand
implements CommandExecutor {
    private final VitalVials plugin;

    public RefundEffectCommand(VitalVials plugin) {
        this.plugin = plugin;
    }

    /*
     * Unable to fully structure code
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            player = (Player)sender;
            if (this.plugin.getConfigManager().canUse((CommandSender)player, "refundEffect")) {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7fUsage:\u00a7c /VitalVials\u00a7b refundEffect\u00a7f <effectName> [level]");
                    return true;
                }
                TransactionManager.closeTransaction((CommandSender)player);
                playerId = player.getUniqueId();
                playerData = this.plugin.getDataManager().getPlayerEffectData(playerId);
                if (playerData.isEmpty()) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have any active effects.");
                    return true;
                }
                effectName = args[1];
                effectInfo = this.plugin.getConfigManager().getEffects().get(effectName);
                if (effectInfo == null) {
                    player.sendMessage(String.valueOf(ChatColor.WHITE) + "Invalid effect name: " + String.valueOf(ChatColor.RED) + effectName);
                    return true;
                }
                if (effectInfo.getRefundPercentage() < 0.0) {
                    sender.sendMessage("\u00a7cRefund for " + effectName + " is disabled.");
                    return true;
                }
                level = playerData.getOrDefault(effectName, -1);
                if (level == -1) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have this effect.");
                    return true;
                }
                if (args.length == 3) {
                    try {
                        refundLevels = Integer.parseInt(args[2]);
                        if (refundLevels <= 0) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "Refund level must be greater than 0.");
                            return true;
                        }
                        newLevel = level - refundLevels;
                        if (newLevel >= 0) ** GOTO lbl39
                        newLevel = -1;
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid level number: " + args[2]);
                        return true;
                    }
                } else {
                    newLevel = level - 1;
                }
lbl39:
                // 3 sources

                if (newLevel < -1) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid level you want to refund: " + String.valueOf(ChatColor.WHITE) + (args.length >= 3 ? args[2] : "1") + " is is higher than your level!");
                    return true;
                }
                this.confirmRefund(player, effectInfo, newLevel);
                return true;
            }
        }
        return true;
    }

    private void confirmRefund(Player player, EffectDataManager effectInfo, Integer newLevel) {
        if (this.plugin.getConfigManager().canUse((CommandSender)player, "refundEffect")) {
            String transactionId = TransactionManager.generateTransactionId((CommandSender)player, "refundEffect");
            TransactionManager.openTransaction(this.plugin, (CommandSender)player, transactionId);
            int level = this.plugin.getDataManager().getPlayerEffectLevel(player.getUniqueId(), effectInfo.getId());
            int levelRefund = level - newLevel;
            double refundAmount = this.plugin.getConfigManager().getRefundCostFromTo(effectInfo, level, newLevel);
            String healthType = effectInfo.getPriceType().equals("MAX_HEALTH") ? " Max" : "";
            String levelRefundText = newLevel == -1 ? "\u00a7f all level back to\u00a7a 0\u00a7f(refunded\u00a7a " + levelRefund + "\u00a7f levels, will remove this effect entirely)" : "\u00a7f back to level\u00a7a " + (newLevel + 1) + "\u00a7f(\u00a7a" + (level + 1) + " \u2192 " + levelRefund + "\u00a7f, refunded\u00a7a " + levelRefund + "\u00a7f levels)";
            TextComponent message = new TextComponent("\u00a7fAre\u00a7b you\u00a7f sure\u00a7b you\u00a7f want to refund\u00a7e " + effectInfo.getId() + levelRefundText + " for\u00a7b " + String.valueOf(ChatColor.RED) + refundAmount / 2.0 + healthType + " Hearts \u2764 \u00a7f/\u00a7c " + refundAmount + healthType + " Health Points \u2665\u00a7f? ");
            TextComponent yes = new TextComponent("[YES]");
            yes.setColor(net.md_5.bungee.api.ChatColor.GREEN);
            yes.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/vitalvials confirmRefund " + String.valueOf(player.getUniqueId()) + " " + effectInfo.getId() + " " + transactionId + " " + newLevel));
            TextComponent no = new TextComponent("[NO]");
            no.setColor(net.md_5.bungee.api.ChatColor.RED);
            no.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/vitalvials cancelRefund " + transactionId));
            TextComponent newline = new TextComponent("\n");
            message.addExtra((BaseComponent)newline);
            message.addExtra((BaseComponent)yes);
            message.addExtra(" ");
            message.addExtra((BaseComponent)no);
            player.spigot().sendMessage((BaseComponent)message);
        }
    }

    public boolean confirmRefundCommand(CommandSender sender, String[] args) {
        if (!this.plugin.getConfigManager().canUse(sender, "refundEffect")) {
            sender.sendMessage("\u00a7fYou\u00a7c don't have permission\u00a7f to use this command.");
            return false;
        }
        if (args.length != 5) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /VitalVials\u00a7b confirmRefund\u00a7f <playerUUID> <effectName> <transactionId> <newLevel>");
            return false;
        }
        UUID playerId = UUID.fromString(args[1]);
        Player player = this.plugin.getServer().getPlayer(playerId);
        if (player == null) {
            sender.sendMessage("\u00a7cPlayer is not online.");
            return true;
        }
        if (!TransactionManager.isValidTransaction((CommandSender)player, args[3])) {
            sender.sendMessage("\u00a7cThis confirmation has expired or is invalid. Please try again.");
            return false;
        }
        String effectName = args[2];
        int newLevel = Integer.parseInt(args[4]);
        EffectDataManager effectInfo = this.plugin.getConfigManager().getEffects().get(effectName);
        try {
            int level = this.plugin.getDataManager().getPlayerEffectLevel(playerId, effectName);
            if (level == -1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have this effect or this effect not save in player data.");
                return true;
            }
            if (newLevel == level) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You must refund at least 1 level.");
                return true;
            }
            if (newLevel > level) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid target level: higher than current level.");
                return true;
            }
            if (newLevel < -1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid level you want to refund: " + String.valueOf(ChatColor.WHITE) + newLevel + "1 is lower than 0!");
                return true;
            }
            int levelRefund = level - newLevel;
            double refundAmount = this.plugin.getConfigManager().getRefundCostFromTo(effectInfo, level, newLevel);
            String healthType = effectInfo.getPriceType().equals("MAX_HEALTH") ? " Max" : "";
            double currentHealth = HealthManager.getMaxHealth(player);
            double currentHealthPoints = HealthManager.getHealth(player);
            double maxHPSetting = this.plugin.getConfigManager().getMaxHPValue();
            double newMaxHealth = currentHealth + refundAmount;
            double newHealthPoints = currentHealthPoints + refundAmount;
            if (this.plugin.getConfigManager().isMaxHPEnabled() && (newMaxHealth > maxHPSetting || newHealthPoints > maxHPSetting || newHealthPoints > currentHealth)) {
                if (healthType.isEmpty() && newHealthPoints > currentHealth) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot refund this effect because your HP can't be higher than " + currentHealth / 2.0 + " Hearts \u2764 \u00a7f/\u00a7c " + currentHealth + " Health Points \u2665\u00a7f!");
                    return true;
                }
                if (!healthType.isEmpty() && newMaxHealth > maxHPSetting) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot refund this effect because your" + healthType + " HP can't be higher than " + maxHPSetting / 2.0 + " Hearts \u2764 \u00a7f/\u00a7c " + maxHPSetting + " Health Points \u2665\u00a7f!");
                    return true;
                }
            }
            if (effectInfo.getPriceType().equals("MAX_HEALTH")) {
                HealthManager.setMaxHealth(currentHealth + refundAmount, player);
            } else {
                HealthManager.setHealth(currentHealthPoints + refundAmount, player);
            }
            if (newLevel == -1) {
                this.plugin.getDataManager().removePlayerEffect(playerId, effectName);
            } else {
                this.plugin.getDataManager().updatePlayerEffect(playerId, effectName, newLevel);
            }
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.getEffectManager().applyAllEffects(player), 5L);
            String strEnd = newLevel == -1 ? "(refund " + levelRefund + " level, remove this effect entirely)" : " back to level " + String.valueOf(ChatColor.LIGHT_PURPLE) + (newLevel + 1) + "(" + (level + 1) + " \u2192 " + (newLevel + 1) + ", refunded " + levelRefund + " level)";
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have refunded " + String.valueOf(ChatColor.AQUA) + effectName + String.valueOf(ChatColor.WHITE) + strEnd + String.valueOf(ChatColor.WHITE) + " for " + String.valueOf(ChatColor.RED) + refundAmount / 2.0 + healthType + " Hearts \u2764 \u00a7f/\u00a7c " + refundAmount + healthType + " Health Points \u2665\u00a7f!");
            this.plugin.sendColoredMessageToConsole("\u00a7b" + player.getName() + "\u00a7f has refunded " + String.valueOf(ChatColor.AQUA) + effectName + String.valueOf(ChatColor.WHITE) + strEnd + String.valueOf(ChatColor.WHITE) + " for " + String.valueOf(ChatColor.RED) + refundAmount / 2.0 + healthType + " Hearts \u2764 \u00a7f/\u00a7c " + refundAmount + healthType + " Health Points \u2665\u00a7f!");
            this.plugin.getCustomScoreboardManager().updateScoreboard(player);
            TransactionManager.closeTransaction((CommandSender)player);
        }
        catch (Exception e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to refund effect: " + String.valueOf(ChatColor.WHITE) + e.getMessage());
        }
        return true;
    }

    public boolean cancelRefundCommand(CommandSender sender, String[] args) {
        if (args.length != 2) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /VitalVials\u00a7b cancelRefund\u00a7f <transactionId>");
            return false;
        }
        String transactionId = args[1];
        if (!transactionId.isEmpty() && TransactionManager.isValidTransaction(sender, transactionId)) {
            TransactionManager.closeTransaction(sender);
            sender.sendMessage("\u00a7bRefund Effect\u00a7f has been\u00a7c cancelled.");
        } else {
            sender.sendMessage("\u00a7cNo active transaction to cancel or invalid transaction ID.");
        }
        return true;
    }
}

