/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.vitalVials.Commands;

import io.github.b4n9z.vitalVials.Managers.EffectDataManager;
import io.github.b4n9z.vitalVials.Managers.TransactionManager;
import io.github.b4n9z.vitalVials.VitalVials;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ScoreboardCommand
implements CommandExecutor {
    private final VitalVials plugin;
    private static final String TITLE = String.valueOf(ChatColor.BLACK) + "VitalVials Scoreboard Sorting";
    private final NamespacedKey itemKey;

    public ScoreboardCommand(VitalVials plugin) {
        this.plugin = plugin;
        this.itemKey = new NamespacedKey((Plugin)plugin, "vvShortItem_b4n9z");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7fCan't execute this command as console.");
            return true;
        }
        Player player = (Player)sender;
        if (!this.plugin.getConfigManager().canUse((CommandSender)player, "scoreboard")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 2) {
            player.sendMessage("\u00a7fUsage:\u00a7c /VitalVials\u00a7b scoreboard\u00a7f <on|off|editShort>");
            return true;
        }
        String sub = args[1].toLowerCase();
        if (args.length == 2) {
            if (sub.equals("on") || sub.equals("off")) {
                boolean status = sub.equals("on");
                this.plugin.getDataManager().setScoreboardEnabled(player.getUniqueId(), status);
                if (this.plugin.getDataManager().isScoreboardEnabled(player.getUniqueId())) {
                    this.plugin.getCustomScoreboardManager().createScoreboard(player);
                }
                this.plugin.getCustomScoreboardManager().updateScoreboard(player);
                player.sendMessage(String.valueOf(ChatColor.WHITE) + "Scoreboard " + (status ? String.valueOf(ChatColor.GREEN) + "enabled" : String.valueOf(ChatColor.RED) + "disabled"));
                return true;
            }
            if (sub.equalsIgnoreCase("editShort")) {
                this.openShortGUI(player);
                return true;
            }
        }
        player.sendMessage(String.valueOf(ChatColor.WHITE) + "Unknown subcommand.");
        return true;
    }

    private void openShortGUI(Player player) {
        if (!this.plugin.getConfigManager().canUse((CommandSender)player, "scoreboard")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to edit scoreboard order.");
            return;
        }
        String transactionId = TransactionManager.generateTransactionId((CommandSender)player, "shortScoreboardEffect");
        TransactionManager.openTransaction(this.plugin, (CommandSender)player, transactionId);
        List<String> order = this.plugin.getDataManager().getScoreboardOrder(player.getUniqueId());
        Map<String, Integer> playerData = this.plugin.getDataManager().getPlayerEffectData(player.getUniqueId());
        if (playerData == null) {
            playerData = Map.of();
        }
        ArrayList<EffectDataManager> effects = new ArrayList<EffectDataManager>();
        for (String effectName : order) {
            EffectDataManager ed;
            if (!playerData.containsKey(effectName) || (ed = this.plugin.getConfigManager().getEffects().get(effectName)) == null || !ed.isEnabled() || ed.getAutoActivate() || ed.getCooldownPerUpgrade(playerData.get(effectName)) <= 0) continue;
            effects.add(ed);
        }
        int slotsNeeded = effects.size() + 1;
        int rows = (int)Math.ceil((double)slotsNeeded / 9.0);
        rows = Math.max(1, Math.min(rows, 6));
        int inventorySize = rows * 9;
        Inventory inv = Bukkit.createInventory(null, (int)inventorySize, (String)TITLE);
        int idx = 0;
        for (EffectDataManager ed : effects) {
            ItemStack item = this.createShortItem(ed, player);
            if (item == null) continue;
            inv.setItem(idx++, item);
        }
        ItemStack saveItem = new ItemStack(Material.CHEST);
        ItemMeta saveMeta = saveItem.getItemMeta();
        if (saveMeta != null) {
            saveMeta.setDisplayName("\u00a7cSave");
            saveMeta.setLore(List.of("\u00a7cClick to save shorting."));
            NamespacedKey transactionKey = new NamespacedKey((Plugin)this.plugin, "vvSaveItemTransaction_b4n9z");
            saveMeta.getPersistentDataContainer().set(transactionKey, PersistentDataType.STRING, (Object)transactionId);
            saveItem.setItemMeta(saveMeta);
        }
        inv.setItem(inventorySize - 1, saveItem);
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        if (fillerMeta != null) {
            fillerMeta.setDisplayName(" ");
            filler.setItemMeta(fillerMeta);
        }
        for (int i = 0; i < inv.getSize(); ++i) {
            if (inv.getItem(i) != null) continue;
            inv.setItem(i, filler);
        }
        player.openInventory(inv);
    }

    private ItemStack createShortItem(EffectDataManager effect, Player player) {
        ItemStack item = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        if (meta == null) {
            return null;
        }
        int currentLevel = this.plugin.getDataManager().getPlayerEffectLevel(player.getUniqueId(), effect.getId());
        int duration = effect.getDurationPerUpgrade(currentLevel);
        int durationTick = duration <= -1 ? duration : duration * 20;
        try {
            PotionEffectType pet = effect.getPotionEffectType();
            if (pet != null) {
                PotionEffect pe = new PotionEffect(pet, durationTick, currentLevel, !effect.hasParticles(), effect.hasParticles());
                meta.addCustomEffect(pe, true);
            }
        }
        catch (Exception pet) {
            // empty catch block
        }
        meta.setColor(effect.getPotionEffectType().getColor());
        String displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)effect.getName());
        meta.setDisplayName(displayName);
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(effect.getLore());
        lore.add(String.valueOf(ChatColor.YELLOW) + "\u300b" + String.valueOf(ChatColor.WHITE) + "Cooldown : " + String.valueOf(ChatColor.YELLOW) + effect.getCooldownPerUpgrade(currentLevel) + "s");
        lore.add(String.valueOf(ChatColor.GRAY) + "\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015");
        lore.add(String.valueOf(ChatColor.GREEN) + "Left-Click to short upward " + String.valueOf(ChatColor.YELLOW) + "\u25c8" + String.valueOf(ChatColor.GREEN) + " Right-Click to short downward");
        lore.add(String.valueOf(ChatColor.GRAY) + "\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015");
        meta.setLore(lore);
        meta.getPersistentDataContainer().set(this.itemKey, PersistentDataType.STRING, (Object)effect.getId());
        item.setItemMeta((ItemMeta)meta);
        return item;
    }
}

