/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.vitalVials.Commands;

import io.github.b4n9z.vitalVials.Managers.EffectDataManager;
import io.github.b4n9z.vitalVials.Managers.HealthManager;
import io.github.b4n9z.vitalVials.Managers.TransactionManager;
import io.github.b4n9z.vitalVials.VitalVials;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public class ShopCommand
implements CommandExecutor {
    private final VitalVials plugin;
    private final NamespacedKey shopEffectKey;
    private final NamespacedKey cancelBuyItemEffectKey;
    private final NamespacedKey cancelBuyItemTransactionKey;
    private final NamespacedKey confirmBuyItemEffectKey;
    private final NamespacedKey confirmBuyItemTransactionKey;
    private final NamespacedKey nextLevelItemEffectKey;
    private final NamespacedKey nextLevelItemTransactionKey;
    private final NamespacedKey prevLevelItemEffectKey;
    private final NamespacedKey prevLevelItemTransactionKey;

    public ShopCommand(VitalVials plugin) {
        this.plugin = plugin;
        this.shopEffectKey = new NamespacedKey((Plugin)plugin, "vvShopItem_b4n9z");
        this.cancelBuyItemEffectKey = new NamespacedKey((Plugin)plugin, "vvCancelBuyItemEffect_b4n9z");
        this.cancelBuyItemTransactionKey = new NamespacedKey((Plugin)plugin, "vvCancelBuyItemTransaction_b4n9z");
        this.confirmBuyItemEffectKey = new NamespacedKey((Plugin)plugin, "vvConfirmBuyItemEffect_b4n9z");
        this.confirmBuyItemTransactionKey = new NamespacedKey((Plugin)plugin, "vvConfirmBuyItemTransaction_b4n9z");
        this.nextLevelItemEffectKey = new NamespacedKey((Plugin)plugin, "vvNextLevelItemEffect_b4n9z");
        this.nextLevelItemTransactionKey = new NamespacedKey((Plugin)plugin, "vvNextLevelItemTransaction_b4n9z");
        this.prevLevelItemEffectKey = new NamespacedKey((Plugin)plugin, "vvPrevLevelItemEffect_b4n9z");
        this.prevLevelItemTransactionKey = new NamespacedKey((Plugin)plugin, "vvPrevLevelItemTransaction_b4n9z");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (!this.plugin.getConfigManager().canUse((CommandSender)player, "shop")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        this.openShopGUI(player);
        return true;
    }

    private void openShopGUI(Player player) {
        List<EffectDataManager> upgradeableEffects = this.plugin.getConfigManager().effectsPlayerCanUpgrade(player);
        int inventorySize = (int)(Math.ceil((double)(upgradeableEffects.size() + 8) / 9.0) * 9.0);
        Inventory shop = Bukkit.createInventory(null, (int)Math.min(54, Math.max(9, inventorySize)), (String)(String.valueOf(ChatColor.BLACK) + "VitalVials Shop"));
        for (EffectDataManager effect : upgradeableEffects) {
            int nextLevel;
            int currentLevel;
            ItemStack item = this.createShopItem(effect, currentLevel = this.plugin.getDataManager().getPlayerEffectLevel(player.getUniqueId(), effect.getId()), nextLevel = currentLevel + 1);
            if (item == null) continue;
            shop.addItem(new ItemStack[]{item});
        }
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        if (fillerMeta != null) {
            fillerMeta.setDisplayName(" ");
            filler.setItemMeta(fillerMeta);
        }
        for (int i = 0; i < shop.getSize(); ++i) {
            if (shop.getItem(i) != null) continue;
            shop.setItem(i, filler);
        }
        player.openInventory(shop);
    }

    private void openBuyGUI(Player player, EffectDataManager effectInfo, int nextLevel) {
        if (this.plugin.getConfigManager().canUse((CommandSender)player, "shop")) {
            ItemStack confirmItem;
            ItemMeta confirmItemMeta;
            ItemStack cancelItem;
            ItemMeta cancelItemMeta;
            ItemStack prevLevelItem;
            ItemMeta prevLevelItemMeta;
            ItemStack nextLevelItem;
            ItemMeta nextLevelItemMeta;
            if (!effectInfo.isEnabled()) {
                return;
            }
            String transactionId = TransactionManager.generateTransactionId((CommandSender)player, "shopEffect");
            TransactionManager.openTransaction(this.plugin, (CommandSender)player, transactionId);
            Inventory shop = Bukkit.createInventory(null, (int)27, (String)(String.valueOf(ChatColor.BLACK) + "VitalVials Confirm Buy"));
            int currentLevel = this.plugin.getDataManager().getPlayerEffectLevel(player.getUniqueId(), effectInfo.getId());
            ItemStack item = this.createShopItem(effectInfo, currentLevel, nextLevel);
            if (item != null) {
                shop.setItem(13, item);
            }
            if ((nextLevelItemMeta = (nextLevelItem = new ItemStack(Material.FIRE_CHARGE)).getItemMeta()) != null) {
                nextLevelItemMeta.setDisplayName("\u00a7aNext Level");
                nextLevelItemMeta.setLore(List.of("\u00a7aClick to upgrade to the next level."));
                nextLevelItemMeta.getPersistentDataContainer().set(this.nextLevelItemEffectKey, PersistentDataType.STRING, (Object)effectInfo.getId());
                nextLevelItemMeta.getPersistentDataContainer().set(this.nextLevelItemTransactionKey, PersistentDataType.STRING, (Object)transactionId);
                NamespacedKey nextLevelItemNextLevelKey = new NamespacedKey((Plugin)this.plugin, effectInfo.getId() + "nextLevel" + String.valueOf(player.getUniqueId()));
                nextLevelItemMeta.getPersistentDataContainer().set(nextLevelItemNextLevelKey, PersistentDataType.INTEGER, (Object)(nextLevel + 1));
                nextLevelItemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP, ItemFlag.HIDE_ARMOR_TRIM, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE, ItemFlag.HIDE_DYE, ItemFlag.HIDE_PLACED_ON});
                nextLevelItem.setItemMeta(nextLevelItemMeta);
            }
            if ((prevLevelItemMeta = (prevLevelItem = new ItemStack(Material.SNOWBALL)).getItemMeta()) != null) {
                prevLevelItemMeta.setDisplayName("\u00a7cPrevious Level");
                prevLevelItemMeta.setLore(List.of("\u00a7cClick to downgrade to the previous level."));
                prevLevelItemMeta.getPersistentDataContainer().set(this.prevLevelItemEffectKey, PersistentDataType.STRING, (Object)effectInfo.getId());
                prevLevelItemMeta.getPersistentDataContainer().set(this.prevLevelItemTransactionKey, PersistentDataType.STRING, (Object)transactionId);
                NamespacedKey prevLevelItemNextLevelKey = new NamespacedKey((Plugin)this.plugin, effectInfo.getId() + "prevLevel" + String.valueOf(player.getUniqueId()));
                prevLevelItemMeta.getPersistentDataContainer().set(prevLevelItemNextLevelKey, PersistentDataType.INTEGER, (Object)(nextLevel - 1));
                prevLevelItemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP, ItemFlag.HIDE_ARMOR_TRIM, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE, ItemFlag.HIDE_DYE, ItemFlag.HIDE_PLACED_ON});
                prevLevelItem.setItemMeta(prevLevelItemMeta);
            }
            if ((cancelItemMeta = (cancelItem = new ItemStack(Material.RED_STAINED_GLASS_PANE)).getItemMeta()) != null) {
                cancelItemMeta.setDisplayName("\u00a7cCancel");
                cancelItemMeta.setLore(List.of("\u00a7cClick to cancel the transaction."));
                cancelItemMeta.getPersistentDataContainer().set(this.cancelBuyItemEffectKey, PersistentDataType.STRING, (Object)effectInfo.getId());
                cancelItemMeta.getPersistentDataContainer().set(this.cancelBuyItemTransactionKey, PersistentDataType.STRING, (Object)transactionId);
                cancelItem.setItemMeta(cancelItemMeta);
            }
            if ((confirmItemMeta = (confirmItem = new ItemStack(Material.LIME_STAINED_GLASS_PANE)).getItemMeta()) != null) {
                confirmItemMeta.setDisplayName("\u00a7aConfirm Buy");
                confirmItemMeta.setLore(List.of("\u00a7aClick to confirm the transaction."));
                confirmItemMeta.getPersistentDataContainer().set(this.confirmBuyItemEffectKey, PersistentDataType.STRING, (Object)effectInfo.getId());
                confirmItemMeta.getPersistentDataContainer().set(this.confirmBuyItemTransactionKey, PersistentDataType.STRING, (Object)transactionId);
                NamespacedKey confirmBuyItemNextLevelKey = new NamespacedKey((Plugin)this.plugin, effectInfo.getId() + "nextLevel" + String.valueOf(player.getUniqueId()));
                confirmItemMeta.getPersistentDataContainer().set(confirmBuyItemNextLevelKey, PersistentDataType.INTEGER, (Object)nextLevel);
                confirmItem.setItemMeta(confirmItemMeta);
            }
            if (nextLevel + 1 <= effectInfo.getMaxLevel() - 1) {
                shop.setItem(15, nextLevelItem);
            }
            if (currentLevel < nextLevel - 1) {
                shop.setItem(11, prevLevelItem);
            }
            shop.setItem(21, cancelItem);
            shop.setItem(23, confirmItem);
            ItemStack filler = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
            ItemMeta fillerMeta = filler.getItemMeta();
            if (fillerMeta != null) {
                fillerMeta.setDisplayName(" ");
                filler.setItemMeta(fillerMeta);
            }
            for (int i = 0; i < shop.getSize(); ++i) {
                if (shop.getItem(i) != null) continue;
                shop.setItem(i, filler);
            }
            player.openInventory(shop);
        }
    }

    private ItemStack createShopItem(EffectDataManager effect, int currentLevel, int nextLevel) {
        ItemStack item = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        if (meta == null) {
            return null;
        }
        if (nextLevel > effect.getMaxLevel() - 1) {
            return null;
        }
        int duration = effect.getDurationPerUpgrade(nextLevel);
        double cost = effect.getCostFromTo(currentLevel, nextLevel);
        try {
            PotionEffect potionEffect = new PotionEffect(effect.getPotionEffectType(), duration == -1 ? duration : duration * 20, nextLevel, !effect.hasParticles(), effect.hasParticles());
            meta.addCustomEffect(potionEffect, true);
        }
        catch (IllegalArgumentException e) {
            meta.setBasePotionType(PotionType.STRENGTH);
        }
        meta.setColor(effect.getPotionEffectType().getColor());
        String displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)effect.getName());
        String healthType = effect.getPriceType().equals("MAX_HEALTH") ? " Max" : "";
        meta.setDisplayName(displayName);
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(effect.getLore());
        lore.add(String.valueOf(ChatColor.YELLOW) + "\u300b" + String.valueOf(ChatColor.WHITE) + "Price : " + String.valueOf(ChatColor.RED) + cost / 2.0 + healthType + " Hearts \u2764 / " + cost + healthType + " Health Points \u2665");
        lore.add(String.valueOf(ChatColor.YELLOW) + "\u300b" + String.valueOf(ChatColor.WHITE) + "Cooldown : " + String.valueOf(ChatColor.YELLOW) + effect.getCooldownPerUpgrade(nextLevel) + "s");
        lore.add(String.valueOf(ChatColor.YELLOW) + "\u300b" + String.valueOf(ChatColor.WHITE) + "Max Level Upgrade : " + String.valueOf(ChatColor.YELLOW) + effect.getMaxLevel());
        lore.add(String.valueOf(ChatColor.RED) + " (" + effect.getPriceType() + " \u25c8 " + (effect.isSaveEffectData() ? "Data Saved" : "Data Not Saved") + " \u25c8 " + (String)(effect.getRefundPercentage() < 0.0 ? "Cannot Refund" : effect.getRefundPercentage() + "% Refund") + ")");
        lore.add("\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015");
        if (effect.getAutoActivate()) {
            lore.add(String.valueOf(ChatColor.BLUE) + " \u226b " + String.valueOf(ChatColor.AQUA) + " Auto Activated : " + String.valueOf(ChatColor.LIGHT_PURPLE) + "true");
        }
        if (this.plugin.getConfigManager().hasActivationTypes(effect, "rightClick")) {
            lore.add(String.valueOf(ChatColor.BLUE) + " \u226b " + String.valueOf(ChatColor.AQUA) + " Applied to Yourself When Right Click Using: " + String.valueOf(ChatColor.LIGHT_PURPLE) + this.plugin.getConfigManager().getActivationTypes(effect).get("rightClick"));
        }
        if (this.plugin.getConfigManager().hasActivationTypes(effect, "leftClick")) {
            lore.add(String.valueOf(ChatColor.BLUE) + " \u226b " + String.valueOf(ChatColor.AQUA) + " Applied to Yourself When Left Click Using: " + String.valueOf(ChatColor.LIGHT_PURPLE) + this.plugin.getConfigManager().getActivationTypes(effect).get("leftClick"));
        }
        if (this.plugin.getConfigManager().hasActivationTypes(effect, "YouAreHittingEnemy")) {
            lore.add(String.valueOf(ChatColor.BLUE) + " \u226b " + String.valueOf(ChatColor.AQUA) + " Applied to Enemies When You Hit an Enemy Using : " + String.valueOf(ChatColor.LIGHT_PURPLE) + this.plugin.getConfigManager().getActivationTypes(effect).get("YouAreHittingEnemy"));
        }
        if (this.plugin.getConfigManager().hasActivationTypes(effect, "enemyHitYou")) {
            lore.add(String.valueOf(ChatColor.BLUE) + " \u226b " + String.valueOf(ChatColor.AQUA) + " Applied to Enemy When Enemy Hits You Using : " + String.valueOf(ChatColor.LIGHT_PURPLE) + this.plugin.getConfigManager().getActivationTypes(effect).get("enemyHitYou"));
        }
        lore.add("\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015");
        lore.add(String.valueOf(ChatColor.YELLOW) + "Click to purchase!");
        meta.setLore(lore);
        meta.getPersistentDataContainer().set(this.shopEffectKey, PersistentDataType.STRING, (Object)effect.getId());
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public void handleShopClick(Player player, ItemStack clickedItem) {
        if (clickedItem == null || !clickedItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null) {
            return;
        }
        Map<String, Integer> playerEffects = this.plugin.getDataManager().getPlayerEffectData(player.getUniqueId());
        String effectId = (String)meta.getPersistentDataContainer().get(this.shopEffectKey, PersistentDataType.STRING);
        if (effectId != null) {
            player.closeInventory();
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.openBuyGUI(player, this.plugin.getConfigManager().getEffects().get(effectId), playerEffects.getOrDefault(effectId, -1) + 1), 5L);
        }
        String nextLevelTransactionId = (String)meta.getPersistentDataContainer().get(this.nextLevelItemTransactionKey, PersistentDataType.STRING);
        String nextLevelEffectId = (String)meta.getPersistentDataContainer().get(this.nextLevelItemEffectKey, PersistentDataType.STRING);
        if (nextLevelEffectId != null) {
            EffectDataManager effectInfo = this.plugin.getConfigManager().getEffects().get(nextLevelEffectId);
            int playerLevel = playerEffects.getOrDefault(nextLevelEffectId, -1);
            NamespacedKey nextLevelItemNextLevelKey = new NamespacedKey((Plugin)this.plugin, effectInfo.getId() + "nextLevel" + String.valueOf(player.getUniqueId()));
            Integer nextLevel = (Integer)meta.getPersistentDataContainer().get(nextLevelItemNextLevelKey, PersistentDataType.INTEGER);
            if (nextLevel != null && nextLevel <= effectInfo.getMaxLevel() - 1 && nextLevel > playerLevel && nextLevelTransactionId != null && TransactionManager.isValidTransaction((CommandSender)player, nextLevelTransactionId)) {
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.openBuyGUI(player, this.plugin.getConfigManager().getEffects().get(nextLevelEffectId), nextLevel), 5L);
            }
        }
        String prevLevelTransactionId = (String)meta.getPersistentDataContainer().get(this.prevLevelItemTransactionKey, PersistentDataType.STRING);
        String prevLevelEffectId = (String)meta.getPersistentDataContainer().get(this.prevLevelItemEffectKey, PersistentDataType.STRING);
        if (prevLevelEffectId != null) {
            EffectDataManager effectInfo = this.plugin.getConfigManager().getEffects().get(prevLevelEffectId);
            int playerLevel = playerEffects.getOrDefault(prevLevelEffectId, -1);
            NamespacedKey prevLevelItemNextLevelKey = new NamespacedKey((Plugin)this.plugin, effectInfo.getId() + "prevLevel" + String.valueOf(player.getUniqueId()));
            Integer prevLevel = (Integer)meta.getPersistentDataContainer().get(prevLevelItemNextLevelKey, PersistentDataType.INTEGER);
            if (prevLevel != null && prevLevel > playerLevel && prevLevel <= effectInfo.getMaxLevel() - 1 && prevLevelTransactionId != null && TransactionManager.isValidTransaction((CommandSender)player, prevLevelTransactionId)) {
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.openBuyGUI(player, this.plugin.getConfigManager().getEffects().get(prevLevelEffectId), prevLevel), 5L);
            }
        }
        String cancelTransactionId = (String)meta.getPersistentDataContainer().get(this.cancelBuyItemTransactionKey, PersistentDataType.STRING);
        String cancelEffectId = (String)meta.getPersistentDataContainer().get(this.cancelBuyItemEffectKey, PersistentDataType.STRING);
        if (cancelEffectId != null) {
            if (cancelTransactionId != null && TransactionManager.isValidTransaction((CommandSender)player, cancelTransactionId)) {
                TransactionManager.closeTransaction((CommandSender)player);
                player.sendMessage("\u00a7bBuy Effect\u00a7f has been\u00a7c cancelled.");
            } else {
                player.sendMessage("\u00a7cNo active transaction to cancel or invalid transaction ID.");
            }
            this.runShopCommandLater(player);
        }
        String confirmTransactionId = (String)meta.getPersistentDataContainer().get(this.confirmBuyItemTransactionKey, PersistentDataType.STRING);
        String confirmEffectId = (String)meta.getPersistentDataContainer().get(this.confirmBuyItemEffectKey, PersistentDataType.STRING);
        if (confirmEffectId != null) {
            EffectDataManager effectInfo = this.plugin.getConfigManager().getEffects().get(confirmEffectId);
            int playerLevel = playerEffects.getOrDefault(confirmEffectId, -1);
            NamespacedKey confirmBuyItemNextLevelKey = new NamespacedKey((Plugin)this.plugin, effectInfo.getId() + "nextLevel" + String.valueOf(player.getUniqueId()));
            Integer nextLevel = (Integer)meta.getPersistentDataContainer().get(confirmBuyItemNextLevelKey, PersistentDataType.INTEGER);
            if (nextLevel != null && nextLevel > playerLevel && nextLevel <= effectInfo.getMaxLevel() - 1 && confirmTransactionId != null && TransactionManager.isValidTransaction((CommandSender)player, confirmTransactionId)) {
                this.confirmBuy(player, confirmEffectId, confirmTransactionId, nextLevel);
            }
        }
    }

    private void runShopCommandLater(Player player) {
        player.closeInventory();
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            try {
                player.performCommand("vitalvials shop");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 5L);
    }

    public void confirmBuy(Player player, String effectId, String transactionId, int nextLevel) {
        if (!this.plugin.getConfigManager().canUse((CommandSender)player, "shop")) {
            player.sendMessage("\u00a7fYou\u00a7c don't have permission\u00a7f to use this command.");
            return;
        }
        if (!TransactionManager.isValidTransaction((CommandSender)player, transactionId)) {
            player.sendMessage("\u00a7cThis confirmation has expired or is invalid. Please try again.");
            this.runShopCommandLater(player);
            return;
        }
        UUID playerId = player.getUniqueId();
        EffectDataManager effectInfo = this.plugin.getConfigManager().getEffects().get(effectId);
        Map<String, Integer> playerEffects = this.plugin.getDataManager().getPlayerEffectData(playerId);
        try {
            if (effectInfo == null || !effectInfo.isEnabled()) {
                player.sendMessage(String.valueOf(ChatColor.WHITE) + "Invalid effect name: " + String.valueOf(ChatColor.RED) + effectId);
                this.runShopCommandLater(player);
                return;
            }
            int price = effectInfo.getCostFromTo(playerEffects.getOrDefault(effectId, -1), nextLevel);
            String healthType = effectInfo.getPriceType().equals("MAX_HEALTH") ? " Max" : "";
            double currentHealth = HealthManager.getHealth(player);
            double currentMaxHealth = HealthManager.getMaxHealth(player);
            double newHealth = currentHealth - (double)price;
            double newMaxHealth = currentMaxHealth - (double)price;
            if (effectInfo.getPriceType().equals("MAX_HEALTH") && (currentMaxHealth < (double)price || newMaxHealth <= this.plugin.getConfigManager().getMinHPValue()) || !effectInfo.getPriceType().equals("MAX_HEALTH") && (currentHealth < (double)price || newHealth <= this.plugin.getConfigManager().getMinHPValue())) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have enough" + healthType + " health to buy/upgrade " + String.valueOf(ChatColor.AQUA) + effectId + String.valueOf(ChatColor.WHITE) + " for " + String.valueOf(ChatColor.RED) + price / 2 + healthType + " Hearts \u2764 \u00a7f/\u00a7c " + price + healthType + " Health Points \u2665\u00a7f!");
                this.runShopCommandLater(player);
                return;
            }
            if (nextLevel > effectInfo.getMaxLevel() - 1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You have reached the maximum level for this effect!");
                this.runShopCommandLater(player);
                return;
            }
            playerEffects.put(effectId, nextLevel);
            if (effectInfo.getPriceType().equals("MAX_HEALTH")) {
                HealthManager.setMaxHealth(newMaxHealth, player);
            } else {
                HealthManager.setHealth(newHealth, player);
            }
            if (effectInfo.isSaveEffectData()) {
                this.plugin.getDataManager().savePlayerEffectData(playerId, playerEffects);
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.getEffectManager().applyAllEffects(player), 5L);
            } else {
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.getEffectManager().applyEffect(player, effectId, nextLevel), 5L);
            }
            this.plugin.getCustomScoreboardManager().updateScoreboard(player);
            player.closeInventory();
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You bought/upgraded " + String.valueOf(ChatColor.AQUA) + effectId + String.valueOf(ChatColor.WHITE) + " for " + String.valueOf(ChatColor.RED) + price / 2 + healthType + " Hearts \u2764 \u00a7f/\u00a7c " + price + healthType + " Health Points \u2665\u00a7f!");
            this.plugin.sendColoredMessageToConsole("\u00a7b" + player.getName() + "\u00a7f has bought/upgraded " + String.valueOf(ChatColor.AQUA) + effectId + String.valueOf(ChatColor.WHITE) + " for " + String.valueOf(ChatColor.RED) + price / 2 + healthType + " Hearts \u2764 \u00a7f/\u00a7c " + price + healthType + " Health Points \u2665\u00a7f!");
            TransactionManager.closeTransaction((CommandSender)player);
            this.runShopCommandLater(player);
        }
        catch (Exception e) {
            player.closeInventory();
            player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to buy/upgrade effect: " + String.valueOf(ChatColor.WHITE) + e.getMessage());
            this.runShopCommandLater(player);
        }
    }
}

