/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.vitalVials.Managers;

import io.github.b4n9z.vitalVials.Managers.ActivationDataManager;
import io.github.b4n9z.vitalVials.Managers.EffectDataManager;
import io.github.b4n9z.vitalVials.VitalVials;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ConfigManager {
    private final Plugin plugin;
    private final VitalVials pluginMain;
    private FileConfiguration effectsConfig;
    private final Map<String, EffectDataManager> effects = new LinkedHashMap<String, EffectDataManager>();
    private FileConfiguration activationConfig;
    private final Map<String, ActivationDataManager> activations = new HashMap<String, ActivationDataManager>();
    private final Map<String, Map<String, String>> allActivationTypes = new HashMap<String, Map<String, String>>();
    private boolean isMaxHPEnabled;
    private double maxHPValue;
    private double minHPValue;
    private boolean isDefaultShowScoreboardEnabled;
    private int periodUpdateScoreboard;
    private static final String PERM_PREFIX = "vv.";
    private final Map<String, Boolean> permissionOverrides = new HashMap<String, Boolean>();

    public ConfigManager(Plugin plugin) {
        this.plugin = plugin;
        this.pluginMain = (VitalVials)plugin;
        this.loadConfig();
    }

    public void loadConfig() {
        try {
            String effectFileName = this.plugin.getConfig().getString("effects", "effects.yml");
            File effectFile = new File(this.plugin.getDataFolder(), effectFileName);
            if (!effectFile.exists()) {
                this.plugin.saveResource(effectFileName, false);
            }
            this.effectsConfig = YamlConfiguration.loadConfiguration((File)effectFile);
            this.loadAllEffects();
            String activationFileName = this.plugin.getConfig().getString("activation", "activation.yml");
            File activationFile = new File(this.plugin.getDataFolder(), activationFileName);
            if (!activationFile.exists()) {
                this.plugin.saveResource(activationFileName, false);
            }
            this.activationConfig = YamlConfiguration.loadConfiguration((File)activationFile);
            this.loadAllActivations();
            this.loadAllActivationTypes();
            this.isMaxHPEnabled = this.plugin.getConfig().getBoolean("maxHP.enabled", true);
            this.maxHPValue = this.plugin.getConfig().getDouble("maxHP.value", 20.0);
            this.minHPValue = this.plugin.getConfig().getDouble("minHP", 2.0);
            this.isDefaultShowScoreboardEnabled = this.plugin.getConfig().getBoolean("scoreboard.defaultShowScoreboard", true);
            this.periodUpdateScoreboard = this.plugin.getConfig().getInt("scoreboard.periodUpdate", 10);
            this.permissionOverrides.put("reload", this.plugin.getConfig().getBoolean("permissionsAllPlayer.reload", false));
            this.permissionOverrides.put("shop", this.plugin.getConfig().getBoolean("permissionsAllPlayer.shop", true));
            this.permissionOverrides.put("buyEffect", this.plugin.getConfig().getBoolean("permissionsAllPlayer.buyEffect", true));
            this.permissionOverrides.put("scoreboard", this.plugin.getConfig().getBoolean("permissionsAllPlayer.scoreboard", true));
            this.permissionOverrides.put("viewStatus", this.plugin.getConfig().getBoolean("permissionsAllPlayer.viewStatus", true));
            this.permissionOverrides.put("refundEffect", this.plugin.getConfig().getBoolean("permissionsAllPlayer.refundEffect", true));
            this.permissionOverrides.put("removeData", this.plugin.getConfig().getBoolean("permissionsAllPlayer.removeData", false));
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage("\u00a7cFailed to load config:\u00a7f " + e.getMessage());
        }
    }

    private void loadAllEffects() {
        this.effects.clear();
        ArrayList shortKey = new ArrayList(this.effectsConfig.getKeys(false));
        shortKey.sort(String.CASE_INSENSITIVE_ORDER);
        for (String key : shortKey) {
            ConfigurationSection section = this.effectsConfig.getConfigurationSection(key);
            if (section == null) continue;
            EffectDataManager data = new EffectDataManager(key, section);
            this.effects.put(key, data);
        }
    }

    public Map<String, EffectDataManager> getEffects() {
        return this.effects;
    }

    public List<String> getAllEffectsEnabled() {
        ArrayList<String> enabledEffects = new ArrayList<String>();
        for (EffectDataManager effect : this.effects.values()) {
            if (!effect.isEnabled()) continue;
            enabledEffects.add(effect.getId());
        }
        return enabledEffects;
    }

    private void loadAllActivations() {
        this.activations.clear();
        Set allKeys = this.activationConfig.getKeys(false);
        for (String key : allKeys) {
            ConfigurationSection section = this.activationConfig.getConfigurationSection(key);
            if (section == null) continue;
            ActivationDataManager data = new ActivationDataManager(key, section);
            this.activations.put(key, data);
        }
    }

    public Map<String, ActivationDataManager> getActivations() {
        return this.activations;
    }

    public boolean isRightToolForEffect(Material material, EffectDataManager effect, String type) {
        ActivationDataManager activation;
        String materialString = material.name();
        if (!this.activations.containsKey(materialString) && materialString.contains("_")) {
            String[] split = materialString.split("_");
            if (this.activations.containsKey(split[split.length - 1])) {
                materialString = split[split.length - 1];
            } else {
                return false;
            }
        }
        if ((activation = this.activations.get(materialString)) == null) {
            return false;
        }
        if (type.equals("rightClick") && activation.getRightClick().contains(effect.getId())) {
            return true;
        }
        if (type.equals("leftClick") && activation.getLeftClick().contains(effect.getId())) {
            return true;
        }
        if (type.equals("YouAreHittingEnemy") && activation.getYouAreHittingEnemy().contains(effect.getId())) {
            return true;
        }
        return type.equals("enemyHitYou") && activation.getEnemyIsHittingYou().contains(effect.getId());
    }

    public boolean isAllToolsForEffect(EffectDataManager effect, String type) {
        ActivationDataManager activation = this.activations.get("ALL_ITEMS");
        if (type.equals("rightClick") && activation.getRightClick().contains(effect.getId())) {
            return true;
        }
        if (type.equals("leftClick") && activation.getLeftClick().contains(effect.getId())) {
            return true;
        }
        if (type.equals("YouAreHittingEnemy") && activation.getYouAreHittingEnemy().contains(effect.getId())) {
            return true;
        }
        return type.equals("enemyHitYou") && activation.getEnemyIsHittingYou().contains(effect.getId());
    }

    public void loadAllActivationTypes() {
        this.allActivationTypes.clear();
        for (EffectDataManager effect : this.effects.values()) {
            String effectName = effect.getId();
            HashMap activationTypes = new HashMap();
            activationTypes.put("rightClick", new ArrayList());
            activationTypes.put("leftClick", new ArrayList());
            activationTypes.put("YouAreHittingEnemy", new ArrayList());
            activationTypes.put("enemyHitYou", new ArrayList());
            for (Map.Entry<String, ActivationDataManager> entry : this.activations.entrySet()) {
                if (entry.getValue().getRightClick().contains(effectName)) {
                    ((List)activationTypes.get("rightClick")).add(entry.getKey());
                }
                if (entry.getValue().getLeftClick().contains(effectName)) {
                    ((List)activationTypes.get("leftClick")).add(entry.getKey());
                }
                if (entry.getValue().getYouAreHittingEnemy().contains(effectName)) {
                    ((List)activationTypes.get("YouAreHittingEnemy")).add(entry.getKey());
                }
                if (!entry.getValue().getEnemyIsHittingYou().contains(effectName)) continue;
                ((List)activationTypes.get("enemyHitYou")).add(entry.getKey());
            }
            HashMap<String, String> stringMap = new HashMap<String, String>();
            for (Map.Entry entry : activationTypes.entrySet()) {
                if (((List)entry.getValue()).isEmpty()) continue;
                stringMap.put((String)entry.getKey(), String.join((CharSequence)", ", (Iterable)entry.getValue()));
            }
            this.allActivationTypes.put(effectName, stringMap);
        }
    }

    public Map<String, String> getActivationTypes(EffectDataManager effect) {
        return this.allActivationTypes.get(effect.getId());
    }

    public boolean hasActivationTypes(EffectDataManager effect, String type) {
        Map<String, String> activationTypes = this.getActivationTypes(effect);
        return activationTypes.containsKey(type);
    }

    public List<EffectDataManager> effectsPlayerCanUpgrade(Player player) {
        Map<String, Integer> playerData = this.pluginMain.getDataManager().getPlayerEffectData(player.getUniqueId());
        return this.effects.values().stream().filter(EffectDataManager::isEnabled).filter(effect -> effect.getMaxLevel() - 1 > playerData.getOrDefault(effect.getId(), -1)).toList();
    }

    public boolean isMaxHPEnabled() {
        return this.isMaxHPEnabled;
    }

    public double getMaxHPValue() {
        return this.maxHPValue;
    }

    public double getMinHPValue() {
        return this.minHPValue;
    }

    public double getRefundCost(EffectDataManager effect, int level) {
        double upgradeCost = 0.0;
        for (int i = 0; i <= level; ++i) {
            double cost = effect.getCostPerUpgrade(i);
            upgradeCost += cost;
        }
        return Math.floor(upgradeCost * effect.getRefundPercent());
    }

    public double getRefundCostFromTo(EffectDataManager effect, int from, int to) {
        return (double)effect.getCostFromTo(to, from) * effect.getRefundPercent();
    }

    public boolean isDefaultShowScoreboardEnabled() {
        return this.isDefaultShowScoreboardEnabled;
    }

    public int getPeriodUpdateScoreboard() {
        return this.periodUpdateScoreboard;
    }

    public boolean canUse(CommandSender sender, String perm) {
        if (!this.permissionOverrides.containsKey(perm)) {
            this.plugin.getLogger().warning("Unknown permission key used in canUse(): " + perm);
        }
        if (this.permissionOverrides.getOrDefault(perm, false).booleanValue()) {
            return true;
        }
        return sender.hasPermission(PERM_PREFIX + perm) || sender.hasPermission("vv.admin");
    }

    public boolean isValidUUID(String str) {
        try {
            UUID.fromString(str);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

