/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.vitalVials.Managers;

import io.github.b4n9z.vitalVials.Managers.EffectDataManager;
import io.github.b4n9z.vitalVials.VitalVials;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class CustomScoreboardManager {
    private final VitalVials plugin;
    private final Map<UUID, Objective> playerObjectives = new HashMap<UUID, Objective>();
    private final Map<UUID, BukkitTask> updateTasks = new ConcurrentHashMap<UUID, BukkitTask>();
    private static final String PREFIX = String.valueOf(ChatColor.GOLD) + "\u226b " + String.valueOf(ChatColor.YELLOW);
    private static final String HEADER = String.valueOf(ChatColor.WHITE) + "\u300b\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u300a";
    private static final String TITLE = String.valueOf(ChatColor.YELLOW) + "Effects " + String.valueOf(ChatColor.GOLD) + "\u226b";
    private static final String NO_EFFECTS = String.valueOf(ChatColor.GOLD) + "\u226b " + String.valueOf(ChatColor.RED) + "No active effects";
    private static final String FOOTER = String.valueOf(ChatColor.WHITE) + "\u226b\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u226a";

    public CustomScoreboardManager(VitalVials plugin) {
        this.plugin = plugin;
    }

    public void createScoreboard(Player player) {
        this.stopUpdating(player.getUniqueId());
        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
        if (scoreboardManager == null) {
            return;
        }
        Scoreboard scoreboard = scoreboardManager.getNewScoreboard();
        Objective objective = scoreboard.registerNewObjective("vv_effects", Criteria.DUMMY, String.valueOf(ChatColor.GOLD) + "\u226b " + String.valueOf(ChatColor.YELLOW) + "Server Stats" + String.valueOf(ChatColor.GOLD) + " \u226a");
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.playerObjectives.put(player.getUniqueId(), objective);
        player.setScoreboard(scoreboard);
        this.startUpdating(player);
    }

    public void updateScoreboard(Player player) {
        UUID playerId = player.getUniqueId();
        if (!this.plugin.getDataManager().isScoreboardEnabled(player.getUniqueId())) {
            this.removeScoreboard(player);
            return;
        }
        if (!player.isOnline()) {
            return;
        }
        Map<String, Integer> playerData = this.plugin.getDataManager().getPlayerEffectData(playerId);
        if (playerData == null) {
            return;
        }
        List<String> order = this.plugin.getDataManager().getScoreboardOrder(playerId);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            LinkedHashMap<Object, Object> entries = new LinkedHashMap<Object, Object>();
            entries.put("header", HEADER);
            entries.put("title", TITLE);
            boolean hasEffects = false;
            for (String effectName : order) {
                if (!playerData.containsKey(effectName)) continue;
                int level = (Integer)playerData.get(effectName);
                EffectDataManager effect = this.plugin.getConfigManager().getEffects().get(effectName);
                if (effect == null || !effect.isEnabled() || effect.getAutoActivate() || effect.getCooldownPerUpgrade(level) <= 0) continue;
                boolean onCooldown = this.plugin.getEffectManager().isOnCooldown(player.getUniqueId(), effectName);
                String entryText = PREFIX + String.valueOf(onCooldown ? ChatColor.RED : "") + effectName + ": " + String.valueOf(onCooldown ? ChatColor.WHITE : ChatColor.GREEN) + (level + 1);
                entries.put("effect_" + effectName, entryText);
                hasEffects = true;
            }
            if (!hasEffects) {
                entries.put("no_effects", NO_EFFECTS);
            }
            entries.put("footer", FOOTER);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if (!player.isOnline()) {
                    return;
                }
                Objective objective = this.playerObjectives.get(playerId);
                if (objective == null || objective.getScoreboard() == null) {
                    return;
                }
                for (String entry : objective.getScoreboard().getEntries()) {
                    objective.getScoreboard().resetScores(entry);
                }
                int currentScore = entries.size();
                for (Map.Entry entry : entries.entrySet()) {
                    objective.getScore((String)entry.getValue()).setScore(currentScore--);
                }
            });
        });
    }

    public void removeScoreboard(Player player) {
        this.stopUpdating(player.getUniqueId());
        this.playerObjectives.remove(player.getUniqueId());
        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
        if (scoreboardManager != null) {
            player.setScoreboard(scoreboardManager.getNewScoreboard());
        }
    }

    public void startUpdating(final Player player) {
        this.stopUpdating(player.getUniqueId());
        this.updateScoreboard(player);
        this.updateTasks.put(player.getUniqueId(), new BukkitRunnable(){

            public void run() {
                if (!player.isOnline()) {
                    CustomScoreboardManager.this.stopUpdating(player.getUniqueId());
                    return;
                }
                CustomScoreboardManager.this.updateScoreboard(player);
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, (long)this.plugin.getConfigManager().getPeriodUpdateScoreboard() * 20L));
    }

    public void stopUpdating(UUID playerId) {
        BukkitTask task = this.updateTasks.remove(playerId);
        if (task != null) {
            task.cancel();
        }
    }
}

