/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.vitalVials;

import io.github.b4n9z.vitalVials.Commands.MainCommand;
import io.github.b4n9z.vitalVials.Commands.MainCommandCompleter;
import io.github.b4n9z.vitalVials.Listeners.ClickItemListener;
import io.github.b4n9z.vitalVials.Listeners.EntityDamageByEntityListener;
import io.github.b4n9z.vitalVials.Listeners.InventoryGUIClickListener;
import io.github.b4n9z.vitalVials.Listeners.PlayerDrinkMilkListener;
import io.github.b4n9z.vitalVials.Listeners.PlayerJoinListener;
import io.github.b4n9z.vitalVials.Listeners.PlayerQuitListener;
import io.github.b4n9z.vitalVials.Listeners.PlayerRespawnListener;
import io.github.b4n9z.vitalVials.Listeners.TotemListener;
import io.github.b4n9z.vitalVials.Listeners.WorldChangeListener;
import io.github.b4n9z.vitalVials.Managers.ConfigManager;
import io.github.b4n9z.vitalVials.Managers.CustomScoreboardManager;
import io.github.b4n9z.vitalVials.Managers.DataManager;
import io.github.b4n9z.vitalVials.Managers.EffectManager;
import io.github.b4n9z.vitalVials.bStats.Metrics;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class VitalVials
extends JavaPlugin {
    private ConfigManager configManager;
    private DataManager dataManager;
    private EffectManager effectManager;
    private CustomScoreboardManager customScoreboardManager;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadMetrics(27411);
        this.loadConfigManager();
        this.loadDataManager();
        this.loadEffectManager();
        this.loadCustomScoreboardManager();
        this.registerEvents();
        this.registerCommands();
        this.getLogger().info("VitalVials has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("VitalVials has been disabled!");
    }

    public void loadMetrics(int pluginId) {
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("chart_id", () -> "My value"));
    }

    public void loadConfigManager() {
        this.configManager = new ConfigManager((Plugin)this);
    }

    public ConfigManager getConfigManager() {
        if (this.configManager == null) {
            throw new IllegalStateException("ConfigManager not initialized");
        }
        return this.configManager;
    }

    public void loadDataManager() {
        this.dataManager = new DataManager(this);
    }

    public DataManager getDataManager() {
        if (this.dataManager == null) {
            throw new IllegalStateException("DataManager not initialized");
        }
        return this.dataManager;
    }

    public void loadEffectManager() {
        this.effectManager = new EffectManager(this);
    }

    public EffectManager getEffectManager() {
        if (this.effectManager == null) {
            throw new IllegalStateException("EffectManager not initialized");
        }
        return this.effectManager;
    }

    public void loadCustomScoreboardManager() {
        this.customScoreboardManager = new CustomScoreboardManager(this);
    }

    public CustomScoreboardManager getCustomScoreboardManager() {
        if (this.customScoreboardManager == null) {
            throw new IllegalStateException("CustomScoreboardManager not initialized");
        }
        return this.customScoreboardManager;
    }

    public void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerRespawnListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerQuitListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldChangeListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDrinkMilkListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TotemListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityDamageByEntityListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ClickItemListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryGUIClickListener(this), (Plugin)this);
    }

    private void registerCommands() {
        MainCommand mainCommand = new MainCommand(this);
        Objects.requireNonNull(this.getCommand("VitalVials")).setExecutor((CommandExecutor)mainCommand);
        Objects.requireNonNull(this.getCommand("vv")).setExecutor((CommandExecutor)mainCommand);
        Objects.requireNonNull(this.getCommand("VitalVials")).setTabCompleter((TabCompleter)new MainCommandCompleter(this));
        Objects.requireNonNull(this.getCommand("vv")).setTabCompleter((TabCompleter)new MainCommandCompleter(this));
    }

    public void sendColoredMessageToConsole(String message) {
        ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
        console.sendMessage(message);
    }
}

