#version 120

// Bloom settings
#define BLOOM_ENABLED 1 // Enable bloom effect [0 1]
#define BLOOM_RADIUS 10.0 // Bloom blur radius [2.5 5.0 10.0 15.0 20.0]

uniform sampler2D colortex3; // Horizontally blurred bloom from composite2
uniform float viewWidth;
uniform float viewHeight;

/* RENDERTARGETS:2 */

varying vec2 texcoord;

// Vertical gaussian blur
vec3 gaussianBlurVertical(sampler2D tex, vec2 texcoord) {
    #if BLOOM_ENABLED == 0
    return vec3(0.0);
    #endif
    
    vec2 pixelSize = vec2(1.0 / viewWidth, 1.0 / viewHeight);
    vec3 result = vec3(0.0);
    float totalWeight = 0.0;
    
    // Gaussian weights
    float weights[5] = float[](0.227027, 0.1945946, 0.1216216, 0.054054, 0.016216);
    
    // Center sample
    result += texture2D(tex, texcoord).rgb * weights[0];
    totalWeight += weights[0];
    
    // Vertical samples
    for (int i = 1; i < 5; i++) {
        vec2 offset = vec2(0.0, 1.0) * pixelSize * float(i) * BLOOM_RADIUS;
        result += texture2D(tex, texcoord + offset).rgb * weights[i];
        result += texture2D(tex, texcoord - offset).rgb * weights[i];
        totalWeight += weights[i] * 2.0;
    }
    
    return result / totalWeight;
}

void main() {
    // Vertical blur of the horizontally blurred bloom
    vec3 finalBloom = gaussianBlurVertical(colortex3, texcoord);
    
    // Store final blurred bloom back in colortex2
    gl_FragData[0] = vec4(finalBloom, 1.0);
}