// DRAWING STYLE SYSTEM
#define DRAWING_STYLE 1 // Drawing Style [1 2]

// Style-dependent settings resolution
#if DRAWING_STYLE == 1
    // Pencil on Paper Style
    #define STYLE_TEXTURE_PAPER 1
#elif DRAWING_STYLE == 2
    // Colorful Sketch Style
    #define STYLE_TEXTURE_PAPER 0
#else
    // Fallback to Pencil style
    #define STYLE_TEXTURE_PAPER 1
#endif

// Shadow settings
#define ENABLE_SHADOWS 1 // Enable shadow mapping [0 1]
#define COLORED_SHADOWS 1 // Enable colored shadows [0 1]
#define SHADOW_BRIGHTNESS 0.60 //Light levels are multiplied by this number when the surface is in shadows [0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]

//texture settings - Updated to use style system:
#define Shininess 1.0 //Water shine intensity [0.0 0.25 0.5 0.75 1.0]
#define TEXTURE_PAPER_STYLE STYLE_TEXTURE_PAPER // Enable paper style [0 1]
#define TEXTURE_GRAYSCALE_STRENGTH 1.0 // How much to convert texture to grayscale [0.0 0.125 0.25 0.375 0.5 0.625 0.75 0.875 1.0]
#define ENABLE_TEXTURE_OUTLINES 0 // Enable texture outlines [0 1]
#define TEXTURE_OUTLINE_STRENGTH 0.8 // Outline intensity [0.0 0.5 0.8 1.0 1.5]
#define ENABLE_DIRECTIONAL_LIGHTING 1 // Enable directional lighitng [0 1]
#define ENABLE_VORONOI_DISTORTION 0 // Enable voronoi distortion [0 1]
#define OUTLINE_THICKNESS 0.5 // Edge thickness [0.5 1.0 1.5 2.0 3.0]
#define TEXTURE_PAPER_WHITENESS 0.9 // How white the paper is [0.5 0.6 0.7 0.8 0.9 1.0]
#define GRAY_BIAS_STRENGTH 0.7 // How much to bias grays toward white [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define GRAY_BIAS_RANGE_MIN 0.15 // Lower bound for gray detection [0.1 0.125 0.15 0.175 0.2 0.225 0.25 0.275 0.3 0.325 0.35 0.375 0.4]
#define GRAY_BIAS_RANGE_MAX 0.9 // Upper bound for gray detection [0.6 0.65 0.7 0.75 0.8 0.85 0.9]
#define GRAY_BIAS_BRIGHTNESS_LIFT 0.6 // How much to brighten biased areas [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

// Soft shadow settings
#define SOFT_SHADOWS 1 // Enable soft shadows [0 1]
#define PCF_SAMPLE 16 //[8 16 32 64]
#define PCF_BLUR_RADIUS 2.0 //[1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

const int shadowMapResolution = 1024; //[512 1024 2048 4096 8192]
const int noiseTextureResolution = 256;
const float sunPathRotation = 30.0; //[-30.0 -20.0 -10.0 0.0 10.0 20.0 30.0]
const bool shadowHardwareFiltering = false;
const float shadowDistance = 256.0; //[64.0 96.0 128.0 160.0 192.0 224.0 256.0 288.0 320.0 352.0 384.0 416.0 448.0 480.0 512.0]

#define SHADOW_DISTORTION 1 // Enable shadow map distortion [0 1]
#define SHADOW_DISTORT_REDUCTION 0.15 // Distortion Reduction [0.05 0.10 0.15 0.20 0.25 0.30]
#define FAR_DISTANCE_BIAS_START 16.0 // Distance where extra bias scaling starts [16.0 24.0 32.0 40.0 48.0 56.0 64.0]
#define FAR_DISTANCE_BIAS_RANGE 48.0 // Range over which bias scales [32.0 48.0 64.0 80.0 96.0 112.0 128.0]
#define FAR_DISTANCE_BIAS_MAX 4.0 // Maximum bias multiplier for far distances [2.0 3.0 4.0 5.0]

vec3 distortShadow(vec3 pos) {
    #if SHADOW_DISTORTION == 1
        float factor = length(pos.xy) + SHADOW_DISTORT_REDUCTION;
        return vec3(pos.xy / factor, pos.z * 0.5);
    #else
        return pos;
    #endif
}