/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.api.protocol.packets.data;

import com.velocitypowered.api.network.ProtocolVersion;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.image.BufferedImage;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

@SuppressFBWarnings(value={"MS_EXPOSE_REP"})
public class MapPalette {
    private static final Map<MapVersion, byte[]> REMAP_BUFFERS = new EnumMap<MapVersion, byte[]>(MapVersion.class);
    private static final byte[] MAIN_BUFFER = MapPalette.readBuffer("/mapping/colors_main_map");
    @Deprecated
    public static final byte WHITE = 34;
    public static final byte TRANSPARENT = 0;

    private static byte[] readBuffer(String filename) {
        byte[] byArray;
        block8: {
            InputStream stream = MapPalette.class.getResourceAsStream(filename);
            try {
                byArray = Objects.requireNonNull(stream).readAllBytes();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
            stream.close();
        }
        return byArray;
    }

    public static int[] imageToBytes(BufferedImage image) {
        return MapPalette.imageToBytes(image, ProtocolVersion.MINIMUM_VERSION);
    }

    public static int[] imageToBytes(BufferedImage image, ProtocolVersion version) {
        int[] result = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        return MapPalette.imageToBytes(result, result, version);
    }

    public static int[] imageToBytes(int[] image, ProtocolVersion version) {
        return MapPalette.imageToBytes(image, new int[image.length], version);
    }

    public static int[] imageToBytes(int[] from, int[] to, ProtocolVersion version) {
        for (int i = 0; i < from.length; ++i) {
            to[i] = MapPalette.tryFastMatchColor(from[i], version);
        }
        return to;
    }

    public static byte[] imageToBytes(int[] from, byte[] to, ProtocolVersion version) {
        for (int i = 0; i < from.length; ++i) {
            to[i] = MapPalette.tryFastMatchColor(from[i], version);
        }
        return to;
    }

    public static byte tryFastMatchColor(int rgb, ProtocolVersion version) {
        if (MapPalette.getAlpha(rgb) < 128) {
            return 0;
        }
        MapVersion mapVersion = MapVersion.fromProtocolVersion(version);
        byte originalColorID = MAIN_BUFFER[rgb & 0xFFFFFF];
        if (mapVersion == MapVersion.MAXIMUM_VERSION) {
            return originalColorID;
        }
        return MapPalette.remapByte(REMAP_BUFFERS.get((Object)mapVersion), originalColorID);
    }

    private static int getAlpha(int rgb) {
        return (rgb & 0xFF000000) >>> 24;
    }

    public static int[] convertImage(int[] image, MapVersion version) {
        return MapPalette.convertImage(image, new int[image.length], version);
    }

    public static int[] convertImage(int[] from, int[] to, MapVersion version) {
        byte[] remapBuffer = REMAP_BUFFERS.get((Object)version);
        for (int i = 0; i < from.length; ++i) {
            to[i] = MapPalette.remapByte(remapBuffer, (byte)from[i]);
        }
        return to;
    }

    public static byte[] convertImage(byte[] from, byte[] to, MapVersion version) {
        byte[] remapBuffer = REMAP_BUFFERS.get((Object)version);
        for (int i = 0; i < from.length; ++i) {
            to[i] = MapPalette.remapByte(remapBuffer, from[i]);
        }
        return to;
    }

    public static byte[] convertImage(int[] from, byte[] to, MapVersion version) {
        byte[] remapBuffer = REMAP_BUFFERS.get((Object)version);
        for (int i = 0; i < from.length; ++i) {
            to[i] = MapPalette.remapByte(remapBuffer, (byte)from[i]);
        }
        return to;
    }

    private static byte remapByte(byte[] remapBuffer, byte oldByte) {
        return remapBuffer[Byte.toUnsignedInt(oldByte)];
    }

    static {
        for (MapVersion version : MapVersion.values()) {
            REMAP_BUFFERS.put(version, MapPalette.readBuffer("/mapping/colors_" + version.toString().toLowerCase(Locale.ROOT) + "_map"));
        }
    }

    public static enum MapVersion {
        MINIMUM_VERSION(EnumSet.range(ProtocolVersion.MINECRAFT_1_7_2, ProtocolVersion.MINECRAFT_1_7_6)),
        MINECRAFT_1_8(EnumSet.range(ProtocolVersion.MINECRAFT_1_8, ProtocolVersion.MINECRAFT_1_11_1)),
        MINECRAFT_1_12(EnumSet.range(ProtocolVersion.MINECRAFT_1_12, ProtocolVersion.MINECRAFT_1_15_2)),
        MINECRAFT_1_16(EnumSet.range(ProtocolVersion.MINECRAFT_1_16, ProtocolVersion.MINECRAFT_1_16_4)),
        MINECRAFT_1_17(EnumSet.range(ProtocolVersion.MINECRAFT_1_17, ProtocolVersion.MAXIMUM_VERSION));

        private static final EnumMap<ProtocolVersion, MapVersion> VERSIONS_MAP;
        public static final MapVersion MAXIMUM_VERSION;
        private final EnumSet<ProtocolVersion> versions;

        private MapVersion(EnumSet<ProtocolVersion> versions) {
            this.versions = versions;
        }

        public EnumSet<ProtocolVersion> getVersions() {
            return this.versions;
        }

        public static MapVersion fromProtocolVersion(ProtocolVersion version) {
            return VERSIONS_MAP.get(version);
        }

        static {
            VERSIONS_MAP = new EnumMap(ProtocolVersion.class);
            MAXIMUM_VERSION = MINECRAFT_1_17;
            for (MapVersion value : MapVersion.values()) {
                value.versions.forEach(version -> VERSIONS_MAP.put((ProtocolVersion)version, value));
            }
        }
    }
}

