/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.file;

import net.elytrium.limboapi.api.LimboFactory;
import net.elytrium.limboapi.api.chunk.VirtualWorld;
import net.elytrium.limboapi.api.file.WorldFile;
import net.kyori.adventure.nbt.CompoundBinaryTag;

public class MCEditSchematicFile
implements WorldFile {
    private final short width;
    private final short height;
    private final short length;
    private final byte[] blocks;
    private byte[] addBlocks = new byte[0];

    public MCEditSchematicFile(CompoundBinaryTag tag) {
        this.width = tag.getShort("Width");
        this.height = tag.getShort("Height");
        this.length = tag.getShort("Length");
        this.blocks = tag.getByteArray("Blocks");
        if (tag.keySet().contains("AddBlocks")) {
            this.addBlocks = tag.getByteArray("AddBlocks");
        }
    }

    @Override
    public void toWorld(LimboFactory factory, VirtualWorld world, int offsetX, int offsetY, int offsetZ, int lightLevel) {
        short[] blockIDs = new short[this.blocks.length];
        for (int index = 0; index < blockIDs.length; ++index) {
            blockIDs[index] = index >> 1 >= this.addBlocks.length ? (short)(this.blocks[index] & 0xFF) : ((index & 1) == 0 ? (short)(((this.addBlocks[index >> 1] & 0xF) << 8) + (this.addBlocks[index] & 0xFF)) : (short)(((this.addBlocks[index >> 1] & 0xF0) << 4) + (this.addBlocks[index] & 0xFF)));
        }
        for (int posX = 0; posX < this.width; ++posX) {
            for (int posY = 0; posY < this.height; ++posY) {
                for (int posZ = 0; posZ < this.length; ++posZ) {
                    int index = (posY * this.length + posZ) * this.width + posX;
                    world.setBlock(posX + offsetX, posY + offsetY, posZ + offsetZ, factory.createSimpleBlock(blockIDs[index]));
                }
            }
        }
        world.fillSkyLight(lightLevel);
    }
}

