/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.file;

import java.util.HashMap;
import net.elytrium.limboapi.api.LimboFactory;
import net.elytrium.limboapi.api.chunk.VirtualBlock;
import net.elytrium.limboapi.api.chunk.VirtualWorld;
import net.elytrium.limboapi.api.file.WorldFile;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;

public class StructureNbtFile
implements WorldFile {
    private final ListBinaryTag blocks;
    private final ListBinaryTag palette;

    public StructureNbtFile(CompoundBinaryTag tag) {
        this.blocks = tag.getList("blocks");
        this.palette = tag.getList("palette");
    }

    @Override
    public void toWorld(LimboFactory factory, VirtualWorld world, int offsetX, int offsetY, int offsetZ, int lightLevel) {
        VirtualBlock[] palettedBlocks = new VirtualBlock[this.palette.size()];
        for (int i = 0; i < this.palette.size(); ++i) {
            CompoundBinaryTag map = this.palette.getCompound(i);
            HashMap<String, String> propertiesMap = null;
            if (map.keySet().contains("Properties")) {
                propertiesMap = new HashMap<String, String>();
                CompoundBinaryTag properties = map.getCompound("Properties");
                for (String entry : properties.keySet()) {
                    propertiesMap.put(entry, properties.getString(entry));
                }
            }
            palettedBlocks[i] = factory.createSimpleBlock(map.getString("Name"), propertiesMap);
        }
        for (BinaryTag binaryTag : this.blocks) {
            CompoundBinaryTag blockMap = (CompoundBinaryTag)binaryTag;
            ListBinaryTag posTag = blockMap.getList("pos");
            VirtualBlock block = palettedBlocks[blockMap.getInt("state")];
            int x = offsetX + posTag.getInt(0);
            int y = offsetY + posTag.getInt(1);
            int z = offsetZ + posTag.getInt(2);
            world.setBlock(x, y, z, block);
            CompoundBinaryTag blockEntityNbt = blockMap.getCompound("nbt");
            if (blockEntityNbt.keySet().isEmpty()) continue;
            world.setBlockEntity(x, y, z, blockEntityNbt, factory.getBlockEntity(block.getModernStringID()));
        }
        world.fillSkyLight(lightLevel);
    }
}

