/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.file;

import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.elytrium.limboapi.api.LimboFactory;
import net.elytrium.limboapi.api.chunk.VirtualBlock;
import net.elytrium.limboapi.api.chunk.VirtualWorld;
import net.elytrium.limboapi.api.file.WorldFile;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;

public class WorldEditSchemFile
implements WorldFile {
    private final short width;
    private final short height;
    private final short length;
    private final int[] blocks;
    private final CompoundBinaryTag palette;
    private final ListBinaryTag blockEntities;

    public WorldEditSchemFile(CompoundBinaryTag tag) {
        this.width = tag.getShort("Width");
        this.height = tag.getShort("Height");
        this.length = tag.getShort("Length");
        this.palette = tag.getCompound("Palette");
        ByteBuf blockDataBuf = Unpooled.wrappedBuffer((byte[])tag.getByteArray("BlockData"));
        this.blocks = new int[this.width * this.height * this.length];
        for (int i = 0; i < this.blocks.length; ++i) {
            this.blocks[i] = ProtocolUtils.readVarInt((ByteBuf)blockDataBuf);
        }
        this.blockEntities = tag.getList("BlockEntities");
    }

    @Override
    public void toWorld(LimboFactory factory, VirtualWorld world, int offsetX, int offsetY, int offsetZ, int lightLevel) {
        VirtualBlock[] palettedBlocks = new VirtualBlock[this.palette.keySet().size()];
        this.palette.forEach(entry -> {
            palettedBlocks[((IntBinaryTag)entry.getValue()).value()] = factory.createSimpleBlock((String)entry.getKey());
        });
        for (int posX = 0; posX < this.width; ++posX) {
            for (int posY = 0; posY < this.height; ++posY) {
                for (int posZ = 0; posZ < this.length; ++posZ) {
                    int index = (posY * this.length + posZ) * this.width + posX;
                    world.setBlock(posX + offsetX, posY + offsetY, posZ + offsetZ, palettedBlocks[this.blocks[index]]);
                }
            }
        }
        for (BinaryTag blockEntity : this.blockEntities) {
            CompoundBinaryTag blockEntityData = (CompoundBinaryTag)blockEntity;
            int[] posTag = blockEntityData.getIntArray("Pos");
            world.setBlockEntity(offsetX + posTag[0], offsetY + posTag[1], offsetZ + posTag[2], blockEntityData, factory.getBlockEntity(blockEntityData.getString("Id")));
        }
        world.fillSkyLight(lightLevel);
    }
}

