/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.injection.login.confirmation;

import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.LoginAcknowledgedPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.elytrium.commons.utils.reflection.ReflectionException;
import net.elytrium.limboapi.LimboAPI;

public class LoginConfirmHandler
implements MinecraftSessionHandler {
    private static final MethodHandle TEARDOWN_METHOD;
    private final LimboAPI plugin;
    private final CompletableFuture<Object> confirmation = new CompletableFuture();
    private final List<MinecraftPacket> queuedPackets = new ArrayList<MinecraftPacket>();
    private final MinecraftConnection connection;
    private ConnectedPlayer player;

    public LoginConfirmHandler(LimboAPI plugin, MinecraftConnection connection) {
        this.plugin = plugin;
        this.connection = connection;
    }

    public void setPlayer(ConnectedPlayer player) {
        this.player = player;
    }

    public boolean isDone() {
        return this.confirmation.isDone();
    }

    public CompletableFuture<Void> thenRun(Runnable runnable) {
        return this.confirmation.thenRun(runnable);
    }

    public void waitForConfirmation(Runnable runnable) {
        this.thenRun(() -> {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                LimboAPI.getLogger().error("Failed to confirm transition for " + String.valueOf(this.player), throwable);
            }
            try {
                ChannelHandlerContext ctx = this.connection.getChannel().pipeline().context((ChannelHandler)this.connection);
                for (MinecraftPacket packet : this.queuedPackets) {
                    try {
                        this.connection.channelRead(ctx, (Object)packet);
                    }
                    catch (Throwable throwable) {
                        LimboAPI.getLogger().error("{}: exception handling exception in {}", new Object[]{ctx.channel().remoteAddress(), this.connection.getActiveSessionHandler(), throwable});
                    }
                }
                this.queuedPackets.clear();
            }
            catch (Throwable throwable) {
                LimboAPI.getLogger().error("Failed to process packet queue for " + String.valueOf(this.player), throwable);
            }
        });
    }

    public boolean handle(LoginAcknowledgedPacket packet) {
        this.plugin.setState(this.connection, StateRegistry.CONFIG);
        this.confirmation.complete(this);
        return true;
    }

    public void handleGeneric(MinecraftPacket packet) {
        if (this.connection.getState() == StateRegistry.CONFIG) {
            this.queuedPackets.add((MinecraftPacket)ReferenceCountUtil.retain((Object)packet));
        }
    }

    public void handleUnknown(ByteBuf buf) {
        this.connection.close(true);
    }

    public void disconnected() {
        block6: {
            try {
                if (this.player == null) break block6;
                try {
                    TEARDOWN_METHOD.invokeExact(this.player);
                }
                catch (Throwable e) {
                    throw new ReflectionException(e);
                }
            }
            finally {
                for (MinecraftPacket packet : this.queuedPackets) {
                    ReferenceCountUtil.release((Object)packet);
                }
            }
        }
    }

    static {
        try {
            TEARDOWN_METHOD = MethodHandles.privateLookupIn(ConnectedPlayer.class, MethodHandles.lookup()).findVirtual(ConnectedPlayer.class, "teardown", MethodType.methodType(Void.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }
}

