/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.injection.packet;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.backend.BackendPlaySessionHandler;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.UpsertPlayerInfoPacket;
import io.netty.util.collection.IntObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.elytrium.commons.utils.reflection.ReflectionException;
import net.elytrium.limboapi.LimboAPI;
import net.elytrium.limboapi.protocol.LimboProtocol;

public class UpsertPlayerInfoHook
extends UpsertPlayerInfoPacket {
    private static final MethodHandle SERVER_CONN_FIELD;
    private final LimboAPI plugin;

    private UpsertPlayerInfoHook(LimboAPI plugin) {
        this.plugin = plugin;
    }

    public boolean handle(MinecraftSessionHandler handler) {
        if (handler instanceof BackendPlaySessionHandler) {
            try {
                ConnectedPlayer player = SERVER_CONN_FIELD.invokeExact((BackendPlaySessionHandler)handler).getPlayer();
                UUID initialID = this.plugin.getInitialID((Player)player);
                List items = this.getEntries();
                for (int i = 0; i < items.size(); ++i) {
                    UpsertPlayerInfoPacket.Entry item = (UpsertPlayerInfoPacket.Entry)items.get(i);
                    if (!player.getUniqueId().equals(item.getProfileId())) continue;
                    UpsertPlayerInfoPacket.Entry fixedEntry = new UpsertPlayerInfoPacket.Entry(initialID);
                    fixedEntry.setDisplayName(item.getDisplayName());
                    fixedEntry.setGameMode(item.getGameMode());
                    fixedEntry.setLatency(item.getLatency());
                    fixedEntry.setDisplayName(item.getDisplayName());
                    if (item.getProfile() != null && item.getProfile().getId().equals(player.getUniqueId())) {
                        fixedEntry.setProfile(new GameProfile(initialID, item.getProfile().getName(), item.getProfile().getProperties()));
                    } else {
                        fixedEntry.setProfile(item.getProfile());
                    }
                    fixedEntry.setListed(item.isListed());
                    fixedEntry.setListOrder(item.getListOrder());
                    fixedEntry.setChatSession(item.getChatSession());
                    items.set(i, fixedEntry);
                }
            }
            catch (Throwable e) {
                throw new ReflectionException(e);
            }
        }
        return super.handle(handler);
    }

    public static void init(LimboAPI plugin, StateRegistry.PacketRegistry registry) throws ReflectiveOperationException {
        Map playProtocolRegistryVersions = (Map)LimboProtocol.VERSIONS_FIELD.get(registry);
        playProtocolRegistryVersions.forEach((protocolVersion, protocolRegistry) -> {
            try {
                IntObjectMap packetIDToSupplier = (IntObjectMap)LimboProtocol.PACKET_ID_TO_SUPPLIER_FIELD.get(protocolRegistry);
                Object2IntMap packetClassToID = (Object2IntMap)LimboProtocol.PACKET_CLASS_TO_ID_FIELD.get(protocolRegistry);
                int id = packetClassToID.getInt(UpsertPlayerInfoPacket.class);
                packetClassToID.put(UpsertPlayerInfoHook.class, id);
                packetIDToSupplier.put(id, () -> new UpsertPlayerInfoHook(plugin));
            }
            catch (ReflectiveOperationException e) {
                throw new ReflectionException(e);
            }
        });
    }

    static {
        try {
            SERVER_CONN_FIELD = MethodHandles.privateLookupIn(BackendPlaySessionHandler.class, MethodHandles.lookup()).findGetter(BackendPlaySessionHandler.class, "serverConn", VelocityServerConnection.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ReflectionException(e);
        }
    }
}

