/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.protocol.data;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.elytrium.limboapi.api.chunk.VirtualBiome;
import net.elytrium.limboapi.api.chunk.util.CompactStorage;
import net.elytrium.limboapi.material.Biome;
import net.elytrium.limboapi.mcprotocollib.BitStorage116;
import net.elytrium.limboapi.protocol.data.StorageUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BiomeStorage118 {
    private final ProtocolVersion version;
    private List<VirtualBiome> palette = new ArrayList<VirtualBiome>();
    private Map<Integer, VirtualBiome> rawToBiome = new HashMap<Integer, VirtualBiome>();
    private CompactStorage storage;

    public BiomeStorage118(ProtocolVersion version) {
        this.version = version;
        for (Biome biome : Biome.values()) {
            this.palette.add(biome);
            this.rawToBiome.put(biome.getID(), biome);
        }
        this.storage = new BitStorage116(3, 64);
    }

    private BiomeStorage118(ProtocolVersion version, List<VirtualBiome> palette, Map<Integer, VirtualBiome> rawToBiome, CompactStorage storage) {
        this.version = version;
        this.palette = palette;
        this.rawToBiome = rawToBiome;
        this.storage = storage;
    }

    public void set(int posX, int posY, int posZ, @NonNull VirtualBiome biome) {
        int id = this.getIndex(biome);
        this.storage.set(BiomeStorage118.index(posX, posY, posZ), id);
    }

    public void set(int index, @NonNull VirtualBiome biome) {
        int id = this.getIndex(biome);
        this.storage.set(index, id);
    }

    public @NonNull VirtualBiome get(int posX, int posY, int posZ) {
        return this.get(BiomeStorage118.index(posX, posY, posZ));
    }

    private VirtualBiome get(int index) {
        int id = this.storage.get(index);
        if (this.storage.getBitsPerEntry() > 8) {
            return this.rawToBiome.get(id);
        }
        return this.palette.get(id);
    }

    public void write(ByteBuf buf, ProtocolVersion version) {
        buf.writeByte(this.storage.getBitsPerEntry());
        if (this.storage.getBitsPerEntry() <= 8) {
            ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.palette.size());
            for (VirtualBiome biome : this.palette) {
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)biome.getID());
            }
        }
        this.storage.write(buf, version);
    }

    public int getDataLength(ProtocolVersion version) {
        int length = 1;
        if (this.storage.getBitsPerEntry() <= 8) {
            length += ProtocolUtils.varIntBytes((int)this.palette.size());
            for (VirtualBiome biome : this.palette) {
                length += ProtocolUtils.varIntBytes((int)biome.getID());
            }
        }
        return length + this.storage.getDataLength(version);
    }

    public BiomeStorage118 copy() {
        return new BiomeStorage118(this.version, new ArrayList<VirtualBiome>(this.palette), new HashMap<Integer, VirtualBiome>(this.rawToBiome), this.storage.copy());
    }

    private int getIndex(VirtualBiome biome) {
        if (this.storage.getBitsPerEntry() > 8) {
            int raw = biome.getID();
            this.rawToBiome.put(raw, biome);
            return raw;
        }
        int id = this.palette.indexOf(biome);
        if (id == -1) {
            if (this.palette.size() >= 1 << this.storage.getBitsPerEntry()) {
                this.resize(this.storage.getBitsPerEntry() + 1);
                return this.getIndex(biome);
            }
            this.palette.add(biome);
            id = this.palette.size() - 1;
        }
        return id;
    }

    private void resize(int newSize) {
        newSize = StorageUtils.fixBitsPerEntry(this.version, newSize);
        BitStorage116 newStorage = new BitStorage116(newSize, 64);
        for (int i = 0; i < 64; ++i) {
            newStorage.set(i, newSize > 8 ? this.palette.get(this.storage.get(i)).getID() : this.storage.get(i));
        }
        this.storage = newStorage;
    }

    public String toString() {
        return "BiomeStorage118{version=" + String.valueOf(this.version) + ", palette=" + String.valueOf(this.palette) + ", rawToBiome=" + String.valueOf(this.rawToBiome) + ", storage=" + String.valueOf(this.storage) + "}";
    }

    private static int index(int posX, int posY, int posZ) {
        return posY << 4 | posZ << 2 | posX;
    }
}

