/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.protocol.packets.c2s;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import net.elytrium.limboapi.server.LimboSessionHandlerImpl;

public class MovePositionOnlyPacket
implements MinecraftPacket {
    private double posX;
    private double posY;
    private double posZ;
    private boolean onGround;
    private boolean collideHorizontally;

    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        this.posX = buf.readDouble();
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) < 0) {
            buf.skipBytes(8);
        }
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        if (protocolVersion.lessThan((Object)ProtocolVersion.MINECRAFT_1_21_2)) {
            this.onGround = buf.readBoolean();
        } else {
            short flags = buf.readUnsignedByte();
            this.onGround = (flags & 1) != 0;
            this.collideHorizontally = (flags & 2) != 0;
        }
    }

    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        throw new IllegalStateException();
    }

    public boolean handle(MinecraftSessionHandler handler) {
        if (handler instanceof LimboSessionHandlerImpl) {
            return ((LimboSessionHandlerImpl)handler).handle(this);
        }
        return true;
    }

    public int decodeExpectedMaxLength(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        return version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) < 0 ? 33 : 25;
    }

    public int decodeExpectedMinLength(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        return 25;
    }

    public String toString() {
        return "PlayerPosition{posX=" + this.posX + ", posY=" + this.posY + ", posZ=" + this.posZ + ", onGround=" + this.onGround + ", collideHorizontally=" + this.collideHorizontally + "}";
    }

    public double getX() {
        return this.posX;
    }

    public double getY() {
        return this.posY;
    }

    public double getZ() {
        return this.posZ;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean isCollideHorizontally() {
        return this.collideHorizontally;
    }
}

