/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.protocol.packets.s2c;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import net.elytrium.limboapi.LimboAPI;
import net.elytrium.limboapi.api.chunk.VirtualBlock;
import net.elytrium.limboapi.api.chunk.VirtualBlockEntity;
import net.elytrium.limboapi.api.chunk.data.ChunkSnapshot;
import net.elytrium.limboapi.api.chunk.data.LightSection;
import net.elytrium.limboapi.api.chunk.util.CompactStorage;
import net.elytrium.limboapi.api.material.Block;
import net.elytrium.limboapi.api.protocol.packets.data.BiomeData;
import net.elytrium.limboapi.material.Biome;
import net.elytrium.limboapi.mcprotocollib.BitStorage116;
import net.elytrium.limboapi.mcprotocollib.BitStorage19;
import net.elytrium.limboapi.protocol.util.NetworkSection;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;

public class ChunkDataPacket
implements MinecraftPacket {
    private final ChunkSnapshot chunk;
    private final NetworkSection[] sections;
    private final int mask;
    private final int maxSections;
    private final int nonNullSections;
    private final BiomeData biomeData;
    private final CompoundBinaryTag heightmap114;
    private final CompoundBinaryTag heightmap116;
    private final Map<Integer, long[]> heightmap1215;

    public ChunkDataPacket(ChunkSnapshot chunkSnapshot, boolean hasLegacySkyLight, int maxSections) {
        this.maxSections = maxSections;
        this.sections = new NetworkSection[maxSections];
        this.chunk = chunkSnapshot;
        int mask = 0;
        int nonNullSections = 0;
        for (int i = 0; i < this.chunk.getSections().length; ++i) {
            NetworkSection section;
            if (this.chunk.getSections()[i] == null) continue;
            ++nonNullSections;
            mask |= 1 << i;
            LightSection light = this.chunk.getLight()[i];
            this.sections[i] = section = new NetworkSection(i, this.chunk.getSections()[i], light.getBlockLight(), hasLegacySkyLight ? light.getSkyLight() : null, this.chunk.getBiomes());
        }
        this.nonNullSections = nonNullSections;
        this.mask = mask;
        this.heightmap114 = this.createHeightMap(true);
        this.heightmap116 = this.createHeightMap(false);
        this.heightmap1215 = new HashMap<Integer, long[]>();
        for (Map.Entry entry : this.heightmap116) {
            this.heightmap1215.put(this.findHeightMapId((String)entry.getKey()), ((LongArrayBinaryTag)entry.getValue()).value());
        }
        this.biomeData = new BiomeData(this.chunk);
    }

    private int findHeightMapId(String key) {
        return switch (key) {
            case "WORLD_SURFACE" -> 1;
            case "MOTION_BLOCKING" -> 4;
            default -> throw new IllegalArgumentException("Unsupported heightmap: " + key);
        };
    }

    public ChunkDataPacket() {
        throw new IllegalStateException();
    }

    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (!this.chunk.isFullChunk()) {
            Preconditions.checkState((version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_17) < 0 ? 1 : 0) != 0);
        }
        buf.writeInt(this.chunk.getPosX());
        buf.writeInt(this.chunk.getPosZ());
        if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_17) >= 0) {
            if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_17_1) <= 0) {
                long[] lArray = this.create117Mask();
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)lArray.length);
                for (long l : lArray) {
                    buf.writeLong(l);
                }
            }
        } else {
            buf.writeBoolean(this.chunk.isFullChunk());
            if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_16) >= 0 && version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_16_2) < 0) {
                buf.writeBoolean(true);
            }
            if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) > 0) {
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.mask);
            } else {
                buf.writeShort(this.mask == 0 ? 1 : this.mask);
            }
        }
        if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_14) >= 0) {
            if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_16) < 0) {
                ProtocolUtils.writeBinaryTag((ByteBuf)buf, (ProtocolVersion)version, (BinaryTag)this.heightmap114);
            } else if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_21_5) < 0) {
                ProtocolUtils.writeBinaryTag((ByteBuf)buf, (ProtocolVersion)version, (BinaryTag)this.heightmap116);
            } else {
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.heightmap1215.size());
                for (Map.Entry<Integer, long[]> entry : this.heightmap1215.entrySet()) {
                    ProtocolUtils.writeVarInt((ByteBuf)buf, (int)entry.getKey());
                    ProtocolUtils.writeVarInt((ByteBuf)buf, (int)entry.getValue().length);
                    for (long l : entry.getValue()) {
                        buf.writeLong(l);
                    }
                }
            }
        }
        if (this.chunk.isFullChunk() && version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_15) >= 0 && version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_17_1) <= 0) {
            if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_16_2) >= 0) {
                void var6_17;
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.biomeData.getPost115Biomes().length);
                int[] nArray = this.biomeData.getPost115Biomes();
                int entry = nArray.length;
                boolean bl = false;
                while (var6_17 < entry) {
                    b = nArray[var6_17];
                    ProtocolUtils.writeVarInt((ByteBuf)buf, (int)b);
                    ++var6_17;
                }
            } else {
                void var6_19;
                int[] nArray = this.biomeData.getPost115Biomes();
                int entry = nArray.length;
                boolean bl = false;
                while (var6_19 < entry) {
                    b = nArray[var6_19];
                    buf.writeInt(b);
                    ++var6_19;
                }
            }
        }
        ByteBuf byteBuf = this.createChunkData(version);
        try {
            if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) >= 0) {
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)byteBuf.readableBytes());
                buf.writeBytes(byteBuf);
                if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_9_4) >= 0) {
                    List<VirtualBlockEntity.Entry> blockEntityEntries = this.chunk.getBlockEntityEntries();
                    ProtocolUtils.writeVarInt((ByteBuf)buf, (int)blockEntityEntries.size());
                    for (VirtualBlockEntity.Entry blockEntityEntry : blockEntityEntries) {
                        CompoundBinaryTag blockEntityNbt = blockEntityEntry.getNbt();
                        if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_18) >= 0) {
                            buf.writeByte((blockEntityEntry.getPosX() & 0xF) << 4 | blockEntityEntry.getPosZ() & 0xF);
                            buf.writeShort(blockEntityEntry.getPosY());
                            ProtocolUtils.writeVarInt((ByteBuf)buf, (int)blockEntityEntry.getID(version));
                        } else {
                            blockEntityNbt.putString("id", blockEntityEntry.getBlockEntity().getModernID());
                            blockEntityNbt.putInt("x", blockEntityEntry.getPosX());
                            blockEntityNbt.putInt("y", blockEntityEntry.getPosY());
                            blockEntityNbt.putInt("z", blockEntityEntry.getPosZ());
                        }
                        ProtocolUtils.writeBinaryTag((ByteBuf)buf, (ProtocolVersion)version, (BinaryTag)blockEntityNbt);
                    }
                }
                if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_17_1) > 0) {
                    long[] mask2 = this.create117Mask();
                    if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_20) < 0) {
                        buf.writeBoolean(true);
                    }
                    ProtocolUtils.writeVarInt((ByteBuf)buf, (int)mask2.length);
                    for (long m : mask2) {
                        buf.writeLong(m);
                    }
                    ProtocolUtils.writeVarInt((ByteBuf)buf, (int)mask2.length);
                    for (long m : mask2) {
                        buf.writeLong(m);
                    }
                    ProtocolUtils.writeVarInt((ByteBuf)buf, (int)0);
                    ProtocolUtils.writeVarInt((ByteBuf)buf, (int)0);
                    ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.chunk.getLight().length);
                    for (LightSection section : this.chunk.getLight()) {
                        ProtocolUtils.writeByteArray((ByteBuf)buf, (byte[])section.getSkyLight().getData());
                    }
                    ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.chunk.getLight().length);
                    for (LightSection section : this.chunk.getLight()) {
                        ProtocolUtils.writeByteArray((ByteBuf)buf, (byte[])section.getBlockLight().getData());
                    }
                }
            } else {
                this.write17(buf, byteBuf);
            }
        }
        finally {
            byteBuf.release();
        }
    }

    private ByteBuf createChunkData(ProtocolVersion version) {
        int dataLength = 0;
        for (NetworkSection networkSection : this.sections) {
            if (networkSection == null) continue;
            dataLength += networkSection.getDataLength(version);
        }
        if (this.chunk.isFullChunk() && version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_15) < 0) {
            dataLength += version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_13) < 0 ? 256 : 1024;
        }
        if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_18) >= 0) {
            int emptySectionSize = version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_21_5) >= 0 ? 6 : 8;
            dataLength += (this.maxSections - this.nonNullSections) * emptySectionSize;
        }
        ByteBuf data = Unpooled.buffer((int)dataLength);
        for (int pass = 0; pass < 4; ++pass) {
            for (NetworkSection section : this.sections) {
                if (section != null) {
                    section.writeData(data, pass, version);
                    continue;
                }
                if (pass != 0 || version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_18) < 0) continue;
                data.writeShort(0);
                data.writeByte(0);
                ProtocolUtils.writeVarInt((ByteBuf)data, (int)Block.AIR.getID());
                if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_21_5) < 0) {
                    ProtocolUtils.writeVarInt((ByteBuf)data, (int)0);
                }
                data.writeByte(0);
                ProtocolUtils.writeVarInt((ByteBuf)data, (int)Biome.PLAINS.getID());
                if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_21_5) >= 0) continue;
                ProtocolUtils.writeVarInt((ByteBuf)data, (int)0);
            }
        }
        if (this.chunk.isFullChunk() && version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_15) < 0) {
            for (byte b : this.biomeData.getPre115Biomes()) {
                if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_13) < 0) {
                    data.writeByte((int)b);
                    continue;
                }
                data.writeInt((int)b);
            }
        }
        if (dataLength != data.readableBytes()) {
            LimboAPI.getLogger().warn("Data length mismatch: " + dataLength + " != " + data.readableBytes() + ". Version: " + String.valueOf(version));
        }
        return data;
    }

    private CompoundBinaryTag createHeightMap(boolean pre116) {
        CompactStorage surface = pre116 ? new BitStorage19(9, 256) : new BitStorage116(9, 256);
        CompactStorage motionBlocking = pre116 ? new BitStorage19(9, 256) : new BitStorage116(9, 256);
        for (int posY = 0; posY < 256; ++posY) {
            for (int posX = 0; posX < 16; ++posX) {
                for (int posZ = 0; posZ < 16; ++posZ) {
                    VirtualBlock block = this.chunk.getBlock(posX, posY, posZ);
                    if (!block.isAir()) {
                        surface.set(posX + (posZ << 4), posY + 1);
                    }
                    if (!block.isMotionBlocking()) continue;
                    motionBlocking.set(posX + (posZ << 4), posY + 1);
                }
            }
        }
        return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putLongArray("MOTION_BLOCKING", motionBlocking.getData())).putLongArray("WORLD_SURFACE", surface.getData())).build();
    }

    private long[] create117Mask() {
        return BitSet.valueOf(new long[]{this.mask}).toLongArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write17(ByteBuf out, ByteBuf data) {
        out.writeShort(0);
        byte[] uncompressed = new byte[data.readableBytes()];
        data.readBytes(uncompressed);
        ByteBuf compressed = Unpooled.buffer();
        Deflater deflater = new Deflater(9);
        try {
            deflater.setInput(uncompressed);
            deflater.finish();
            byte[] buffer = new byte[1024];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                compressed.writeBytes(buffer, 0, count);
            }
            out.writeInt(compressed.readableBytes());
            out.writeBytes(compressed);
        }
        finally {
            deflater.end();
            compressed.release();
        }
    }

    public boolean handle(MinecraftSessionHandler handler) {
        return true;
    }
}

