/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.protocol.packets.s2c;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;

public class DefaultSpawnPositionPacket
implements MinecraftPacket {
    private final int posX;
    private final int posY;
    private final int posZ;
    private final float angle;

    public DefaultSpawnPositionPacket(int posX, int posY, int posZ, float angle) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.angle = angle;
    }

    public DefaultSpawnPositionPacket() {
        throw new IllegalStateException();
    }

    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        throw new IllegalStateException();
    }

    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) < 0) {
            buf.writeInt(this.posX);
            buf.writeInt(this.posY);
            buf.writeInt(this.posZ);
        } else {
            long location = protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_14) < 0 ? ((long)this.posX & 0x3FFFFFFL) << 38 | ((long)this.posY & 0xFFFL) << 26 | (long)this.posZ & 0x3FFFFFFL : ((long)this.posX & 0x3FFFFFFL) << 38 | ((long)this.posZ & 0x3FFFFFFL) << 12 | (long)this.posY & 0xFFFL;
            buf.writeLong(location);
            if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_17) >= 0) {
                buf.writeFloat(this.angle);
            }
        }
    }

    public boolean handle(MinecraftSessionHandler handler) {
        return true;
    }

    public String toString() {
        return "DefaultSpawnPosition{posX=" + this.posX + ", posY=" + this.posY + ", posZ=" + this.posZ + ", angle=" + this.angle + "}";
    }
}

