/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.server;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.DisconnectPacket;
import net.elytrium.limboapi.LimboAPI;
import net.elytrium.limboapi.Settings;
import net.elytrium.limboapi.api.protocol.PreparedPacket;
import net.kyori.adventure.text.Component;

public class CachedPackets {
    private final LimboAPI plugin;
    private PreparedPacket tooBigPacket;
    private PreparedPacket invalidPing;
    private PreparedPacket invalidSwitch;
    private PreparedPacket playTimeOut;
    private PreparedPacket configTimeOut;
    private boolean cached;

    public CachedPackets(LimboAPI plugin) {
        this.plugin = plugin;
    }

    public void createPackets() {
        if (this.cached) {
            this.dispose();
        }
        this.tooBigPacket = this.plugin.createPreparedPacket().prepare(version -> this.createDisconnectPacket(Settings.IMP.MAIN.MESSAGES.TOO_BIG_PACKET, (ProtocolVersion)version)).build();
        this.invalidPing = this.plugin.createPreparedPacket().prepare(version -> this.createDisconnectPacket(Settings.IMP.MAIN.MESSAGES.INVALID_PING, (ProtocolVersion)version)).build();
        this.invalidSwitch = this.plugin.createConfigPreparedPacket().prepare(version -> this.createDisconnectPacket(Settings.IMP.MAIN.MESSAGES.INVALID_SWITCH, (ProtocolVersion)version), ProtocolVersion.MINECRAFT_1_20_2).build();
        this.playTimeOut = this.plugin.createPreparedPacket().prepare(version -> this.createDisconnectPacket(Settings.IMP.MAIN.MESSAGES.TIME_OUT, (ProtocolVersion)version)).build();
        this.configTimeOut = this.plugin.createConfigPreparedPacket().prepare(version -> this.createDisconnectPacket(Settings.IMP.MAIN.MESSAGES.TIME_OUT, (ProtocolVersion)version), ProtocolVersion.MINECRAFT_1_20_2).build();
        this.cached = true;
    }

    private DisconnectPacket createDisconnectPacket(String message, ProtocolVersion version) {
        return DisconnectPacket.create((Component)LimboAPI.getSerializer().deserialize(message), (ProtocolVersion)version, (StateRegistry)StateRegistry.PLAY);
    }

    public PreparedPacket getTooBigPacket() {
        return this.tooBigPacket;
    }

    public PreparedPacket getInvalidPing() {
        return this.invalidPing;
    }

    public PreparedPacket getInvalidSwitch() {
        return this.invalidSwitch;
    }

    public PreparedPacket getTimeOut(StateRegistry stateRegistry) {
        if (stateRegistry == StateRegistry.CONFIG) {
            return this.configTimeOut;
        }
        return this.playTimeOut;
    }

    public void dispose() {
        this.tooBigPacket.release();
        this.invalidPing.release();
        this.invalidSwitch.release();
        this.playTimeOut.release();
        this.configTimeOut.release();
    }
}

