/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.tree.RootCommandNode;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.proxy.command.registrar.BrigadierCommandRegistrar;
import com.velocitypowered.proxy.command.registrar.CommandRegistrar;
import com.velocitypowered.proxy.command.registrar.RawCommandRegistrar;
import com.velocitypowered.proxy.command.registrar.SimpleCommandRegistrar;
import com.velocitypowered.proxy.connection.ConnectionTypes;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ClientPlaySessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.registry.DimensionInfo;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.VelocityConnectionEvent;
import com.velocitypowered.proxy.protocol.packet.AvailableCommandsPacket;
import com.velocitypowered.proxy.protocol.packet.BossBarPacket;
import com.velocitypowered.proxy.protocol.packet.JoinGamePacket;
import com.velocitypowered.proxy.protocol.packet.LegacyPlayerListItemPacket;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import com.velocitypowered.proxy.protocol.packet.RespawnPacket;
import com.velocitypowered.proxy.protocol.packet.UpsertPlayerInfoPacket;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import com.velocitypowered.proxy.protocol.packet.config.FinishedUpdatePacket;
import com.velocitypowered.proxy.protocol.packet.config.RegistrySyncPacket;
import com.velocitypowered.proxy.protocol.packet.config.StartUpdatePacket;
import com.velocitypowered.proxy.protocol.packet.config.TagsUpdatePacket;
import com.velocitypowered.proxy.protocol.packet.title.GenericTitlePacket;
import com.velocitypowered.proxy.server.VelocityRegisteredServer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.ScheduledFuture;
import it.unimi.dsi.fastutil.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import net.elytrium.commons.utils.reflection.ReflectionException;
import net.elytrium.limboapi.LimboAPI;
import net.elytrium.limboapi.Settings;
import net.elytrium.limboapi.api.Limbo;
import net.elytrium.limboapi.api.LimboSessionHandler;
import net.elytrium.limboapi.api.chunk.Dimension;
import net.elytrium.limboapi.api.chunk.VirtualChunk;
import net.elytrium.limboapi.api.chunk.VirtualWorld;
import net.elytrium.limboapi.api.command.LimboCommandMeta;
import net.elytrium.limboapi.api.player.GameMode;
import net.elytrium.limboapi.api.protocol.PacketDirection;
import net.elytrium.limboapi.api.protocol.PreparedPacket;
import net.elytrium.limboapi.api.protocol.packets.PacketMapping;
import net.elytrium.limboapi.injection.login.confirmation.LoginConfirmHandler;
import net.elytrium.limboapi.injection.packet.MinecraftLimitedCompressDecoder;
import net.elytrium.limboapi.material.Biome;
import net.elytrium.limboapi.protocol.LimboProtocol;
import net.elytrium.limboapi.protocol.packets.s2c.ChangeGameStatePacket;
import net.elytrium.limboapi.protocol.packets.s2c.ChunkDataPacket;
import net.elytrium.limboapi.protocol.packets.s2c.DefaultSpawnPositionPacket;
import net.elytrium.limboapi.protocol.packets.s2c.PositionRotationPacket;
import net.elytrium.limboapi.protocol.packets.s2c.TimeUpdatePacket;
import net.elytrium.limboapi.protocol.packets.s2c.UpdateViewPositionPacket;
import net.elytrium.limboapi.server.LimboPlayerImpl;
import net.elytrium.limboapi.server.LimboSessionHandlerImpl;
import net.elytrium.limboapi.server.world.SimpleTagManager;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.kyori.adventure.text.Component;

public class LimboImpl
implements Limbo {
    private static final ImmutableSet<String> LEVELS = ImmutableSet.of((Object)Dimension.OVERWORLD.getKey(), (Object)Dimension.NETHER.getKey(), (Object)Dimension.THE_END.getKey());
    private static final MethodHandle PARTIAL_HASHED_SEED_FIELD;
    private static final MethodHandle CURRENT_DIMENSION_DATA_FIELD;
    private static final MethodHandle ROOT_NODE_FIELD;
    private static final MethodHandle GRACEFUL_DISCONNECT_FIELD;
    private static final MethodHandle REGISTRY_FIELD;
    private static final MethodHandle LEVEL_NAMES_FIELDS;
    private static final CompoundBinaryTag CHAT_TYPE_119;
    private static final CompoundBinaryTag CHAT_TYPE_1191;
    private static final CompoundBinaryTag DAMAGE_TYPE_1194;
    private static final CompoundBinaryTag DAMAGE_TYPE_120;
    private final Map<Class<? extends LimboSessionHandler>, PreparedPacket> brandMessages = new HashMap<Class<? extends LimboSessionHandler>, PreparedPacket>(2);
    private final LimboAPI plugin;
    private final VirtualWorld world;
    private final LongAdder currentOnline = new LongAdder();
    private final RootCommandNode<CommandSource> commandNode = new RootCommandNode();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final List<PreparedPacket> queuedToRelease = new ArrayList<PreparedPacket>();
    private final List<CommandRegistrar<?>> registrars = ImmutableList.of((Object)new BrigadierCommandRegistrar(this.commandNode, this.lock.writeLock()), (Object)new SimpleCommandRegistrar(this.commandNode, this.lock.writeLock()), (Object)new RawCommandRegistrar(this.commandNode, this.lock.writeLock()));
    private String limboName;
    private Integer readTimeout;
    private Long worldTicks;
    private short gameMode = GameMode.ADVENTURE.getID();
    private Integer maxSuppressPacketLength;
    private PreparedPacket joinPackets;
    private PreparedPacket fastRejoinPackets;
    private PreparedPacket safeRejoinPackets;
    private PreparedPacket postJoinPackets;
    private PreparedPacket firstChunks;
    private List<PreparedPacket> delayedChunks;
    private PreparedPacket respawnPackets;
    protected PreparedPacket configTransitionPackets;
    protected PreparedPacket configPackets;
    protected StateRegistry localStateRegistry;
    private boolean shouldRespawn = true;
    private boolean shouldRejoin = true;
    private boolean shouldUpdateTags = true;
    private boolean reducedDebugInfo;
    private int viewDistance;
    private int simulationDistance;
    private volatile boolean built;
    private boolean disposeScheduled;

    public LimboImpl(LimboAPI plugin, VirtualWorld world) {
        this.reducedDebugInfo = Settings.IMP.MAIN.REDUCED_DEBUG_INFO;
        this.viewDistance = Settings.IMP.MAIN.VIEW_DISTANCE;
        this.simulationDistance = Settings.IMP.MAIN.SIMULATION_DISTANCE;
        this.built = true;
        this.disposeScheduled = false;
        this.plugin = plugin;
        this.world = world;
        this.localStateRegistry = LimboProtocol.getLimboStateRegistry();
        this.refresh();
    }

    protected void refresh() {
        JoinGamePacket legacyJoinGame = this.createLegacyJoinGamePacket();
        JoinGamePacket joinGame = this.createJoinGamePacket(ProtocolVersion.MINECRAFT_1_16);
        JoinGamePacket joinGame1162 = this.createJoinGamePacket(ProtocolVersion.MINECRAFT_1_16_2);
        JoinGamePacket joinGame1182 = this.createJoinGamePacket(ProtocolVersion.MINECRAFT_1_18_2);
        JoinGamePacket joinGame119 = this.createJoinGamePacket(ProtocolVersion.MINECRAFT_1_19);
        JoinGamePacket joinGame1191 = this.createJoinGamePacket(ProtocolVersion.MINECRAFT_1_19_1);
        JoinGamePacket joinGame1194 = this.createJoinGamePacket(ProtocolVersion.MINECRAFT_1_19_4);
        JoinGamePacket joinGame120 = this.createJoinGamePacket(ProtocolVersion.MINECRAFT_1_20);
        JoinGamePacket joinGame121 = this.createJoinGamePacket(ProtocolVersion.MINECRAFT_1_21);
        JoinGamePacket joinGame1212 = this.createJoinGamePacket(ProtocolVersion.MINECRAFT_1_21_2);
        PreparedPacket joinPackets = this.plugin.createPreparedPacket().prepare(legacyJoinGame, ProtocolVersion.MINIMUM_VERSION, ProtocolVersion.MINECRAFT_1_15_2).prepare(joinGame, ProtocolVersion.MINECRAFT_1_16, ProtocolVersion.MINECRAFT_1_16_1).prepare(joinGame1162, ProtocolVersion.MINECRAFT_1_16_2, ProtocolVersion.MINECRAFT_1_18).prepare(joinGame1182, ProtocolVersion.MINECRAFT_1_18_2, ProtocolVersion.MINECRAFT_1_18_2).prepare(joinGame119, ProtocolVersion.MINECRAFT_1_19, ProtocolVersion.MINECRAFT_1_19).prepare(joinGame1191, ProtocolVersion.MINECRAFT_1_19_1, ProtocolVersion.MINECRAFT_1_19_3).prepare(joinGame1194, ProtocolVersion.MINECRAFT_1_19_4, ProtocolVersion.MINECRAFT_1_19_4).prepare(joinGame120, ProtocolVersion.MINECRAFT_1_20, ProtocolVersion.MINECRAFT_1_20_5).prepare(joinGame121, ProtocolVersion.MINECRAFT_1_21, ProtocolVersion.MINECRAFT_1_21).prepare(joinGame1212, ProtocolVersion.MINECRAFT_1_21_2);
        PreparedPacket fastRejoinPackets = this.plugin.createPreparedPacket();
        this.createFastClientServerSwitch(legacyJoinGame, ProtocolVersion.MINECRAFT_1_7_2).forEach(minecraftPacket -> fastRejoinPackets.prepare(minecraftPacket, ProtocolVersion.MINIMUM_VERSION, ProtocolVersion.MINECRAFT_1_15_2));
        this.createFastClientServerSwitch(joinGame, ProtocolVersion.MINECRAFT_1_16).forEach(minecraftPacket -> fastRejoinPackets.prepare(minecraftPacket, ProtocolVersion.MINECRAFT_1_16, ProtocolVersion.MINECRAFT_1_16_1));
        this.createFastClientServerSwitch(joinGame1162, ProtocolVersion.MINECRAFT_1_16_2).forEach(minecraftPacket -> fastRejoinPackets.prepare(minecraftPacket, ProtocolVersion.MINECRAFT_1_16_2, ProtocolVersion.MINECRAFT_1_18));
        this.createFastClientServerSwitch(joinGame1182, ProtocolVersion.MINECRAFT_1_18_2).forEach(minecraftPacket -> fastRejoinPackets.prepare(minecraftPacket, ProtocolVersion.MINECRAFT_1_18_2, ProtocolVersion.MINECRAFT_1_18_2));
        this.createFastClientServerSwitch(joinGame119, ProtocolVersion.MINECRAFT_1_19).forEach(minecraftPacket -> fastRejoinPackets.prepare(minecraftPacket, ProtocolVersion.MINECRAFT_1_19, ProtocolVersion.MINECRAFT_1_19));
        this.createFastClientServerSwitch(joinGame1191, ProtocolVersion.MINECRAFT_1_19_1).forEach(minecraftPacket -> fastRejoinPackets.prepare(minecraftPacket, ProtocolVersion.MINECRAFT_1_19_1, ProtocolVersion.MINECRAFT_1_19_3));
        this.createFastClientServerSwitch(joinGame1194, ProtocolVersion.MINECRAFT_1_19_4).forEach(minecraftPacket -> fastRejoinPackets.prepare(minecraftPacket, ProtocolVersion.MINECRAFT_1_19_4, ProtocolVersion.MINECRAFT_1_19_4));
        this.createFastClientServerSwitch(joinGame120, ProtocolVersion.MINECRAFT_1_20).forEach(minecraftPacket -> fastRejoinPackets.prepare(minecraftPacket, ProtocolVersion.MINECRAFT_1_20, ProtocolVersion.MINECRAFT_1_20_5));
        this.createFastClientServerSwitch(joinGame121, ProtocolVersion.MINECRAFT_1_21).forEach(minecraftPacket -> fastRejoinPackets.prepare(minecraftPacket, ProtocolVersion.MINECRAFT_1_21, ProtocolVersion.MINECRAFT_1_21));
        this.createFastClientServerSwitch(joinGame1212, ProtocolVersion.MINECRAFT_1_21_2).forEach(minecraftPacket -> fastRejoinPackets.prepare(minecraftPacket, ProtocolVersion.MINECRAFT_1_21_2));
        this.joinPackets = this.addPostJoin(joinPackets);
        this.fastRejoinPackets = this.addPostJoin(fastRejoinPackets);
        this.safeRejoinPackets = this.addPostJoin(this.plugin.createPreparedPacket().prepare(this.createSafeClientServerSwitch(legacyJoinGame)));
        this.postJoinPackets = this.addPostJoin(this.plugin.createPreparedPacket());
        this.configTransitionPackets = this.plugin.createPreparedPacket().prepare(StartUpdatePacket.INSTANCE, ProtocolVersion.MINECRAFT_1_20_2).build();
        PreparedPacket configPackets = this.plugin.createConfigPreparedPacket();
        configPackets.prepare(this::createRegistrySyncLegacy, ProtocolVersion.MINECRAFT_1_20_2, ProtocolVersion.MINECRAFT_1_20_3);
        this.createRegistrySyncModern(configPackets, ProtocolVersion.MINECRAFT_1_20_5, ProtocolVersion.MINECRAFT_1_20_5);
        this.createRegistrySyncModern(configPackets, ProtocolVersion.MINECRAFT_1_21, ProtocolVersion.MINECRAFT_1_21);
        this.createRegistrySyncModern(configPackets, ProtocolVersion.MINECRAFT_1_21_2, ProtocolVersion.MINECRAFT_1_21_4);
        this.createRegistrySyncModern(configPackets, ProtocolVersion.MINECRAFT_1_21_5, ProtocolVersion.MAXIMUM_VERSION);
        if (this.shouldUpdateTags) {
            configPackets.prepare(this::createTagsUpdate, ProtocolVersion.MINECRAFT_1_20_2);
        }
        configPackets.prepare(FinishedUpdatePacket.INSTANCE, ProtocolVersion.MINECRAFT_1_20_2);
        this.configPackets = configPackets.build();
        this.firstChunks = this.createFirstChunks();
        this.delayedChunks = this.createDelayedChunksPackets();
        PreparedPacket respawnPackets = this.plugin.createPreparedPacket().prepare(this.createPlayerPosAndLook(this.world.getSpawnX(), this.world.getSpawnY(), this.world.getSpawnZ(), this.world.getYaw(), this.world.getPitch())).prepare(this.createUpdateViewPosition((int)this.world.getSpawnX(), (int)this.world.getSpawnZ()), ProtocolVersion.MINECRAFT_1_14);
        if (this.shouldUpdateTags) {
            respawnPackets.prepare(SimpleTagManager::getUpdateTagsPacket, ProtocolVersion.MINECRAFT_1_13, ProtocolVersion.MINECRAFT_1_20);
        }
        this.respawnPackets = respawnPackets.build();
        this.built = true;
    }

    private ChangeGameStatePacket createLevelChunksLoadStartGameState() {
        return new ChangeGameStatePacket(13, 0.0f);
    }

    private RegistrySyncPacket createRegistrySyncLegacy(ProtocolVersion version) {
        JoinGamePacket join = this.createJoinGamePacket(version);
        ByteBuf encodedRegistry = this.plugin.getPreparedPacketFactory().getPreparedPacketAllocator().ioBuffer();
        ProtocolUtils.writeBinaryTag((ByteBuf)encodedRegistry, (ProtocolVersion)version, (BinaryTag)join.getRegistry());
        RegistrySyncPacket sync = new RegistrySyncPacket();
        sync.replace(encodedRegistry);
        return sync;
    }

    private void createRegistrySyncModern(PreparedPacket packet, ProtocolVersion from, ProtocolVersion to) {
        JoinGamePacket join = this.createJoinGamePacket(from);
        CompoundBinaryTag registryTag = join.getRegistry();
        for (String key : registryTag.keySet()) {
            CompoundBinaryTag entry = registryTag.getCompound(key);
            String type = entry.getString("type");
            ListBinaryTag values = entry.getList("value", BinaryTagTypes.COMPOUND);
            Pair emptyTag = null;
            Pair[] tags = new Pair[]{};
            for (BinaryTag elementTag : values) {
                CompoundBinaryTag element = (CompoundBinaryTag)elementTag;
                int id = element.getInt("id");
                if (id >= tags.length) {
                    tags = Arrays.copyOf(tags, id + 1);
                }
                tags[id] = Pair.of((Object)element.getString("name"), (Object)element.getCompound("element"));
                if (emptyTag != null) continue;
                emptyTag = tags[id];
            }
            for (int i = 0; i < tags.length; ++i) {
                if (tags[i] != null) continue;
                tags[i] = Pair.of((Object)("limboapi_padding_" + i), (Object)((BinaryTag)emptyTag.value()));
            }
            Pair[] patchedTags = tags;
            packet.prepare(version -> {
                ByteBuf registry = this.plugin.getPreparedPacketFactory().getPreparedPacketAllocator().ioBuffer();
                ProtocolUtils.writeString((ByteBuf)registry, (CharSequence)type);
                ProtocolUtils.writeVarInt((ByteBuf)registry, (int)patchedTags.length);
                for (Pair tag : patchedTags) {
                    ProtocolUtils.writeString((ByteBuf)registry, (CharSequence)((CharSequence)tag.left()));
                    registry.writeBoolean(tag.right() != null);
                    if (tag.right() == null) continue;
                    ProtocolUtils.writeBinaryTag((ByteBuf)registry, (ProtocolVersion)version, (BinaryTag)((BinaryTag)tag.right()));
                }
                RegistrySyncPacket sync = new RegistrySyncPacket();
                sync.replace(registry);
                return sync;
            }, from, to);
        }
    }

    private TagsUpdatePacket createTagsUpdate(ProtocolVersion version) {
        return new TagsUpdatePacket(SimpleTagManager.getUpdateTagsPacket(version).toVelocityTags());
    }

    private PreparedPacket addPostJoin(PreparedPacket packet) {
        return packet.prepare(this.createAvailableCommandsPacket(), ProtocolVersion.MINECRAFT_1_13).prepare(this.createDefaultSpawnPositionPacket()).prepare(this.createLevelChunksLoadStartGameState(), ProtocolVersion.MINECRAFT_1_20_3).prepare(this.createWorldTicksPacket()).prepare(this::createBrandMessage).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void spawnPlayer(Player apiPlayer, LimboSessionHandler handler) {
        VelocityServerConnection server;
        if (!this.built) {
            LimboImpl limboImpl = this;
            synchronized (limboImpl) {
                if (!this.built) {
                    List<PreparedPacket> packets = this.takeSnapshot();
                    try {
                        this.refresh();
                    }
                    finally {
                        List<PreparedPacket> changed = this.takeSnapshot();
                        for (PreparedPacket preparedPacket : packets) {
                            if (changed.contains(preparedPacket)) continue;
                            this.queuedToRelease.add(preparedPacket);
                        }
                    }
                }
            }
        }
        ConnectedPlayer player = (ConnectedPlayer)apiPlayer;
        MinecraftConnection connection = player.getConnection();
        boolean shouldSpawnPlayerImmediately = true;
        MinecraftSessionHandler minecraftSessionHandler = player.getConnection().getActiveSessionHandler();
        if (minecraftSessionHandler instanceof ClientPlaySessionHandler) {
            ClientPlaySessionHandler sessionHandler = (ClientPlaySessionHandler)minecraftSessionHandler;
            connection.eventLoop().execute(() -> {
                player.getTabList().clearAll();
                for (UUID serverBossBar : sessionHandler.getServerBossBars()) {
                    player.getConnection().delayedWrite((Object)BossBarPacket.createRemovePacket((UUID)serverBossBar, null));
                }
                sessionHandler.getServerBossBars().clear();
                if (player.getProtocolVersion().noLessThan((Object)ProtocolVersion.MINECRAFT_1_8)) {
                    player.getConnection().delayedWrite((Object)GenericTitlePacket.constructTitlePacket((GenericTitlePacket.ActionType)GenericTitlePacket.ActionType.RESET, (ProtocolVersion)player.getProtocolVersion()));
                    player.clearPlayerListHeaderAndFooter();
                }
                player.getConnection().flush();
            });
        }
        if (connection.getState() != this.localStateRegistry && (server = player.getConnectedServer()) != null) {
            VelocityRegisteredServer velocityRegisteredServer = server.getServer();
            MinecraftConnection serverConnection = server.getConnection();
            if (serverConnection != null) {
                try {
                    GRACEFUL_DISCONNECT_FIELD.invokeExact(server, true);
                }
                catch (Throwable e) {
                    throw new ReflectionException(e);
                }
                connection.eventLoop().execute(() -> this.lambda$spawnPlayer$13(serverConnection, player, handler, (RegisteredServer)velocityRegisteredServer));
                shouldSpawnPlayerImmediately = false;
            }
            player.setConnectedServer(null);
            this.plugin.setLimboJoined((Player)player);
        }
        if (shouldSpawnPlayerImmediately) {
            this.spawnPlayerLocal(player, handler, null);
        }
    }

    protected void spawnPlayerLocal(Class<? extends LimboSessionHandler> handlerClass, LimboSessionHandlerImpl sessionHandler, ConnectedPlayer player, MinecraftConnection connection) {
        if (!connection.eventLoop().inEventLoop()) {
            connection.eventLoop().execute(() -> this.spawnPlayerLocal(handlerClass, sessionHandler, player, connection));
            return;
        }
        connection.setActiveSessionHandler(connection.getState(), (MinecraftSessionHandler)sessionHandler);
        if (connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_2) >= 0) {
            if (connection.getState() != StateRegistry.CONFIG) {
                if (this.shouldRejoin) {
                    connection.write((Object)this.configTransitionPackets);
                    return;
                }
            } else {
                connection.delayedWrite((Object)this.configPackets);
                this.plugin.setEncoderState(connection, this.localStateRegistry);
            }
        }
        sessionHandler.onConfig(new LimboPlayerImpl(this.plugin, this, player));
        if (connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_2) < 0 || connection.getState() != StateRegistry.CONFIG && !this.shouldRejoin) {
            this.onSpawn(handlerClass, connection, player, sessionHandler);
        }
        connection.flush();
    }

    private void spawnPlayerLocal(ConnectedPlayer player, LimboSessionHandler handler, RegisteredServer previousServer) {
        MinecraftConnection connection = player.getConnection();
        connection.eventLoop().execute(() -> {
            MinecraftLimitedCompressDecoder decoder;
            connection.flush();
            ChannelPipeline pipeline = connection.getChannel().pipeline();
            Class<?> handlerClass = handler.getClass();
            if (this.limboName == null) {
                this.limboName = handlerClass.getSimpleName();
            }
            if (Settings.IMP.MAIN.LOGGING_ENABLED) {
                LimboAPI.getLogger().info(player.getUsername() + " (" + String.valueOf(player.getRemoteAddress()) + ") has connected to the " + this.limboName + " Limbo");
            }
            if (pipeline.get("minecraft-encoder") != null) {
                if (this.readTimeout != null) {
                    pipeline.replace("read-timeout", "limboapi-read-timeout", (ChannelHandler)new ReadTimeoutHandler((long)this.readTimeout.intValue(), TimeUnit.MILLISECONDS));
                }
                boolean compressionEnabled = false;
                if (pipeline.get("fastprepare-encoder") == null) {
                    if (this.plugin.isCompressionEnabled() && connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) >= 0) {
                        if (pipeline.get("frame-encoder") != null) {
                            if (!Settings.IMP.MAIN.COMPATIBILITY_MODE) {
                                pipeline.remove("frame-encoder");
                            }
                        } else if (Settings.IMP.MAIN.COMPATIBILITY_MODE) {
                            if (pipeline.context("compression-decoder") != null) {
                                this.plugin.fixDecompressor(pipeline, this.plugin.getServer().getConfiguration().getCompressionThreshold(), false);
                            }
                        } else {
                            ChannelHandler minecraftCompressDecoder = pipeline.remove("compression-decoder");
                            if (minecraftCompressDecoder != null) {
                                this.plugin.fixDecompressor(pipeline, this.plugin.getServer().getConfiguration().getCompressionThreshold(), false);
                                pipeline.replace("compression-encoder", "compression-encoder", (ChannelHandler)new ChannelOutboundHandlerAdapter());
                                compressionEnabled = true;
                            }
                        }
                    } else if (!Settings.IMP.MAIN.COMPATIBILITY_MODE) {
                        pipeline.remove("frame-encoder");
                    }
                    this.plugin.inject3rdParty((Player)player, connection, pipeline);
                    if (compressionEnabled) {
                        pipeline.fireUserEventTriggered((Object)VelocityConnectionEvent.COMPRESSION_ENABLED);
                    } else {
                        pipeline.fireUserEventTriggered((Object)VelocityConnectionEvent.COMPRESSION_DISABLED);
                    }
                }
            } else {
                connection.close();
                return;
            }
            if (this.maxSuppressPacketLength != null && (decoder = (MinecraftLimitedCompressDecoder)pipeline.get(MinecraftLimitedCompressDecoder.class)) != null) {
                decoder.setUncompressedCap(this.maxSuppressPacketLength);
            }
            LimboSessionHandlerImpl sessionHandler = new LimboSessionHandlerImpl(this.plugin, this, player, handler, connection.getState(), connection.getActiveSessionHandler(), previousServer, () -> this.limboName);
            MinecraftSessionHandler patt0$temp = connection.getActiveSessionHandler();
            if (patt0$temp instanceof LoginConfirmHandler) {
                LoginConfirmHandler confirm = (LoginConfirmHandler)patt0$temp;
                confirm.waitForConfirmation(() -> {
                    this.currentOnline.increment();
                    this.spawnPlayerLocal(handlerClass, sessionHandler, player, connection);
                });
            } else {
                this.currentOnline.increment();
                this.spawnPlayerLocal(handlerClass, sessionHandler, player, connection);
            }
        });
    }

    protected void onSpawn(Class<? extends LimboSessionHandler> handlerClass, MinecraftConnection connection, ConnectedPlayer player, LimboSessionHandlerImpl sessionHandler) {
        LegacyPlayerListItemPacket playerInfoPacket;
        this.plugin.setState(connection, this.localStateRegistry);
        if (this.plugin.isLimboJoined((Player)player)) {
            if (this.shouldRejoin) {
                sessionHandler.setJoinGameTriggered(true);
                if (connection.getType() == ConnectionTypes.LEGACY_FORGE) {
                    connection.delayedWrite((Object)this.safeRejoinPackets);
                } else {
                    connection.delayedWrite((Object)this.fastRejoinPackets);
                }
            } else {
                connection.delayedWrite((Object)this.postJoinPackets);
            }
        } else {
            sessionHandler.setJoinGameTriggered(true);
            connection.delayedWrite((Object)this.joinPackets);
        }
        UUID uuid = this.plugin.getInitialID((Player)player);
        if (connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_19_1) <= 0) {
            playerInfoPacket = new LegacyPlayerListItemPacket(0, List.of(new LegacyPlayerListItemPacket.Item(uuid).setName(player.getUsername()).setGameMode((int)this.gameMode).setProperties(player.getGameProfileProperties())));
        } else {
            UpsertPlayerInfoPacket.Entry playerInfoEntry = new UpsertPlayerInfoPacket.Entry(uuid);
            playerInfoEntry.setDisplayName(new ComponentHolder(player.getProtocolVersion(), (Component)Component.text((String)player.getUsername())));
            playerInfoEntry.setGameMode((int)this.gameMode);
            playerInfoEntry.setProfile(player.getGameProfile());
            playerInfoPacket = new UpsertPlayerInfoPacket(EnumSet.of(UpsertPlayerInfoPacket.Action.UPDATE_DISPLAY_NAME, UpsertPlayerInfoPacket.Action.UPDATE_GAME_MODE, UpsertPlayerInfoPacket.Action.ADD_PLAYER), List.of(playerInfoEntry));
        }
        connection.delayedWrite((Object)playerInfoPacket);
        connection.delayedWrite((Object)this.getBrandMessage(handlerClass));
        this.plugin.setLimboJoined((Player)player);
        if (this.shouldRespawn) {
            this.respawnPlayer((Player)player);
        }
        sessionHandler.onSpawn();
    }

    @Override
    public void respawnPlayer(Player player) {
        final MinecraftConnection connection = ((ConnectedPlayer)player).getConnection();
        connection.delayedWrite((Object)this.respawnPackets);
        if (this.firstChunks != null) {
            connection.write((Object)this.firstChunks);
        }
        if (!this.delayedChunks.isEmpty()) {
            final AtomicReference<ScheduledFuture> task = new AtomicReference<ScheduledFuture>();
            task.set(connection.eventLoop().scheduleAtFixedRate(new Runnable(){
                private final List<PreparedPacket> chunksSnapshot;
                private int index;
                {
                    this.chunksSnapshot = LimboImpl.this.delayedChunks;
                }

                @Override
                public void run() {
                    if (connection.isClosed()) {
                        ((java.util.concurrent.ScheduledFuture)task.get()).cancel(false);
                        return;
                    }
                    connection.write((Object)this.chunksSnapshot.get(this.index));
                    if (++this.index >= this.chunksSnapshot.size()) {
                        ((java.util.concurrent.ScheduledFuture)task.get()).cancel(false);
                    }
                }
            }, 50L, 50L, TimeUnit.MILLISECONDS));
            MinecraftSessionHandler minecraftSessionHandler = connection.getActiveSessionHandler();
            if (minecraftSessionHandler instanceof LimboSessionHandlerImpl) {
                LimboSessionHandlerImpl sessionHandler = (LimboSessionHandlerImpl)minecraftSessionHandler;
                sessionHandler.setRespawnTask((java.util.concurrent.ScheduledFuture)task.get());
            }
        }
    }

    @Override
    public long getCurrentOnline() {
        return this.currentOnline.sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisconnect() {
        this.currentOnline.decrement();
        if (!this.queuedToRelease.isEmpty() && this.currentOnline.sum() == 0L) {
            LimboImpl limboImpl = this;
            synchronized (limboImpl) {
                PreparedPacket[] packets = this.queuedToRelease.toArray(new PreparedPacket[0]);
                this.queuedToRelease.clear();
                this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
                    for (PreparedPacket packet : packets) {
                        packet.release();
                    }
                }).delay(10L, TimeUnit.SECONDS).schedule();
            }
        }
        if (this.disposeScheduled && this.currentOnline.sum() == 0L) {
            this.localDispose();
        }
    }

    @Override
    public Limbo setName(String name) {
        this.limboName = name;
        this.built = false;
        return this;
    }

    @Override
    public Limbo setReadTimeout(int millis) {
        this.readTimeout = millis;
        return this;
    }

    @Override
    public Limbo setWorldTime(long ticks) {
        this.worldTicks = ticks;
        this.built = false;
        return this;
    }

    @Override
    public Limbo setGameMode(GameMode gameMode) {
        this.gameMode = gameMode.getID();
        this.built = false;
        return this;
    }

    @Override
    public Limbo setShouldRejoin(boolean shouldRejoin) {
        this.shouldRejoin = shouldRejoin;
        this.built = false;
        return this;
    }

    @Override
    public Limbo setShouldRespawn(boolean shouldRespawn) {
        this.shouldRespawn = shouldRespawn;
        this.built = false;
        return this;
    }

    @Override
    public Limbo setShouldUpdateTags(boolean shouldUpdateTags) {
        this.shouldUpdateTags = shouldUpdateTags;
        this.built = false;
        return this;
    }

    @Override
    public Limbo setReducedDebugInfo(boolean reducedDebugInfo) {
        this.reducedDebugInfo = reducedDebugInfo;
        this.built = false;
        return this;
    }

    @Override
    public Limbo setViewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
        this.built = false;
        return this;
    }

    @Override
    public Limbo setSimulationDistance(int simulationDistance) {
        this.simulationDistance = simulationDistance;
        this.built = false;
        return this;
    }

    @Override
    public Limbo setMaxSuppressPacketLength(int maxSuppressPacketLength) {
        this.maxSuppressPacketLength = maxSuppressPacketLength;
        return this;
    }

    @Override
    public Limbo registerCommand(LimboCommandMeta commandMeta) {
        return this.registerCommand(commandMeta, (Command)((SimpleCommand)invocation -> {}));
    }

    @Override
    public Limbo registerCommand(CommandMeta commandMeta, Command command) {
        for (CommandRegistrar<?> registrar : this.registrars) {
            if (!this.tryRegister(registrar, commandMeta, command)) continue;
            this.built = false;
            return this;
        }
        throw new IllegalArgumentException(String.valueOf(command) + " does not implement a registrable Command sub-interface.");
    }

    @Override
    public Limbo registerPacket(PacketDirection direction, Class<?> packetClass, Supplier<?> packetSupplier, PacketMapping[] packetMappings) {
        if (this.localStateRegistry == LimboProtocol.getLimboStateRegistry()) {
            this.localStateRegistry = LimboProtocol.createLocalStateRegistry();
            this.plugin.getPreparedPacketFactory().addStateRegistry(this.localStateRegistry);
        }
        LimboProtocol.register(this.localStateRegistry, direction, packetClass, packetSupplier, packetMappings);
        return this;
    }

    @Override
    public void dispose() {
        if (this.getCurrentOnline() == 0L) {
            this.localDispose();
        } else {
            this.disposeScheduled = true;
        }
    }

    private List<PreparedPacket> takeSnapshot() {
        ArrayList<PreparedPacket> packets = new ArrayList<PreparedPacket>();
        if (this.joinPackets != null) {
            packets.add(this.joinPackets);
        }
        if (this.fastRejoinPackets != null) {
            packets.add(this.fastRejoinPackets);
        }
        if (this.safeRejoinPackets != null) {
            packets.add(this.safeRejoinPackets);
        }
        if (this.postJoinPackets != null) {
            packets.add(this.postJoinPackets);
        }
        if (this.respawnPackets != null) {
            packets.add(this.respawnPackets);
        }
        if (this.firstChunks != null) {
            packets.add(this.firstChunks);
        }
        if (this.delayedChunks != null) {
            packets.addAll(this.delayedChunks);
        }
        if (this.configTransitionPackets != null) {
            packets.add(this.configTransitionPackets);
        }
        if (this.configPackets != null) {
            packets.add(this.configPackets);
        }
        return packets;
    }

    private void localDispose() {
        this.takeSnapshot().forEach(PreparedPacket::release);
        this.built = false;
        this.brandMessages.values().forEach(PreparedPacket::release);
        this.brandMessages.clear();
    }

    private <T extends Command> boolean tryRegister(CommandRegistrar<T> registrar, CommandMeta commandMeta, Command command) {
        Class superInterface = registrar.registrableSuperInterface();
        if (superInterface.isInstance(command)) {
            registrar.register(commandMeta, (Command)superInterface.cast(command));
            return true;
        }
        return false;
    }

    private CompoundBinaryTag createRegistry(String registryName, Map<String, CompoundBinaryTag> tags) {
        int id = 0;
        ListBinaryTag.Builder builder = ListBinaryTag.builder((BinaryTagType)BinaryTagTypes.COMPOUND);
        for (Map.Entry<String, CompoundBinaryTag> tag : tags.entrySet()) {
            builder.add((BinaryTag)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("name", tag.getKey())).putInt("id", id++)).put("element", (BinaryTag)tag.getValue())).build());
        }
        return this.createRegistry(registryName, builder.build());
    }

    private CompoundBinaryTag createRegistry(String registryName, ListBinaryTag tags) {
        return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("type", registryName)).put("value", (BinaryTag)tags)).build();
    }

    private CompoundBinaryTag createDimensionData(Dimension dimension, ProtocolVersion version) {
        CompoundBinaryTag details = ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putBoolean("natural", false)).putFloat("ambient_light", 0.0f)).putBoolean("shrunk", false)).putBoolean("ultrawarm", false)).putBoolean("has_ceiling", false)).putBoolean("has_skylight", true)).putBoolean("piglin_safe", false)).putBoolean("bed_works", false)).putBoolean("respawn_anchor_works", false)).putBoolean("has_raids", false)).putInt("logical_height", 256)).putString("infiniburn", version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_18_2) >= 0 ? "#minecraft:infiniburn_nether" : "minecraft:infiniburn_nether")).putDouble("coordinate_scale", 1.0)).putString("effects", dimension.getKey())).putInt("min_y", 0)).putInt("height", 256)).putInt("monster_spawn_block_light_limit", 0)).putInt("monster_spawn_light_level", 0)).build();
        if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_16_2) >= 0) {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("name", dimension.getKey())).putInt("id", dimension.getModernID())).put("element", (BinaryTag)details)).build();
        }
        return (CompoundBinaryTag)details.putString("name", dimension.getKey());
    }

    private JoinGamePacket createJoinGamePacket(ProtocolVersion version) {
        Dimension dimension = this.world.getDimension();
        JoinGamePacket joinGame = new JoinGamePacket();
        joinGame.setEntityId(1);
        joinGame.setIsHardcore(true);
        joinGame.setGamemode(this.gameMode);
        joinGame.setPreviousGamemode((short)-1);
        joinGame.setDimension(dimension.getModernID());
        joinGame.setDifficulty((short)0);
        try {
            PARTIAL_HASHED_SEED_FIELD.invokeExact(joinGame, ThreadLocalRandom.current().nextLong());
        }
        catch (Throwable e) {
            throw new ReflectionException(e);
        }
        joinGame.setMaxPlayers(1);
        joinGame.setLevelType("flat");
        joinGame.setViewDistance(this.viewDistance);
        joinGame.setSimulationDistance(this.simulationDistance);
        joinGame.setReducedDebugInfo(this.reducedDebugInfo);
        String key = dimension.getKey();
        joinGame.setDimensionInfo(new DimensionInfo(key, key, false, false, version));
        CompoundBinaryTag.Builder registryContainer = CompoundBinaryTag.builder();
        ListBinaryTag encodedDimensionRegistry = ((ListBinaryTag.Builder)((ListBinaryTag.Builder)((ListBinaryTag.Builder)ListBinaryTag.builder((BinaryTagType)BinaryTagTypes.COMPOUND).add((BinaryTag)this.createDimensionData(Dimension.OVERWORLD, version))).add((BinaryTag)this.createDimensionData(Dimension.NETHER, version))).add((BinaryTag)this.createDimensionData(Dimension.THE_END, version))).build();
        if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_16_2) >= 0) {
            CompoundBinaryTag.Builder dimensionRegistryEntry = CompoundBinaryTag.builder();
            dimensionRegistryEntry.putString("type", "minecraft:dimension_type");
            dimensionRegistryEntry.put("value", (BinaryTag)encodedDimensionRegistry);
            registryContainer.put("minecraft:dimension_type", (BinaryTag)dimensionRegistryEntry.build());
            registryContainer.put("minecraft:worldgen/biome", (BinaryTag)Biome.getRegistry(version));
            if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_19) == 0) {
                registryContainer.put("minecraft:chat_type", (BinaryTag)CHAT_TYPE_119);
            } else if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_19_1) >= 0) {
                registryContainer.put("minecraft:chat_type", (BinaryTag)CHAT_TYPE_1191);
            }
            if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_19_4) == 0) {
                registryContainer.put("minecraft:damage_type", (BinaryTag)DAMAGE_TYPE_1194);
            } else if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_21) >= 0) {
                CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
                ListBinaryTag values = DAMAGE_TYPE_120.getList("value");
                ListBinaryTag.Builder tags = ListBinaryTag.builder((BinaryTagType)BinaryTagTypes.COMPOUND);
                for (BinaryTag tag : values) {
                    tags.add((BinaryTag)((CompoundBinaryTag)tag));
                }
                String[] types = version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_21_2) >= 0 ? new String[]{"minecraft:campfire", "minecraft:ender_pearl", "minecraft:mace_smash"} : new String[]{"minecraft:campfire"};
                int id = values.size();
                for (String name : types) {
                    CompoundBinaryTag.Builder type = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("name", name)).putInt("id", id++)).put("element", (BinaryTag)values.getCompound(0).getCompound("element"));
                    tags.add((BinaryTag)type.build());
                }
                registryContainer.put("minecraft:damage_type", (BinaryTag)this.createRegistry("minecraft:damage_type", tags.build()));
            } else if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_20) >= 0) {
                registryContainer.put("minecraft:damage_type", (BinaryTag)DAMAGE_TYPE_120);
            }
            if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_21) >= 0) {
                CompoundBinaryTag.Builder paintingVariant = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putInt("width", 1)).putInt("height", 1)).putString("asset_id", "minecraft:alban");
                registryContainer.put("minecraft:painting_variant", (BinaryTag)this.createRegistry("minecraft:painting_variant", Map.of("minecraft:alban", paintingVariant.build())));
                if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_21_5) >= 0) {
                    CompoundBinaryTag.Builder catVariant = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("asset_id", "minecraft:entity/cat/all_black")).put("spawn_conditions", (BinaryTag)ListBinaryTag.empty());
                    registryContainer.put("minecraft:cat_variant", (BinaryTag)this.createRegistry("minecraft:cat_variant", Map.of("minecraft:all_black", catVariant.build())));
                    CompoundBinaryTag.Builder chickenVariant = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("asset_id", "minecraft:entity/chicken/cold_chicken")).putString("model", "cold")).put("spawn_conditions", (BinaryTag)ListBinaryTag.empty());
                    registryContainer.put("minecraft:chicken_variant", (BinaryTag)this.createRegistry("minecraft:chicken_variant", Map.of("minecraft:cold", chickenVariant.build())));
                    CompoundBinaryTag.Builder cowVariant = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("asset_id", "minecraft:entity/cow/cold_cow")).putString("model", "cold")).put("spawn_conditions", (BinaryTag)ListBinaryTag.empty());
                    registryContainer.put("minecraft:cow_variant", (BinaryTag)this.createRegistry("minecraft:cow_variant", Map.of("minecraft:cold", cowVariant.build())));
                    CompoundBinaryTag.Builder frogVariant = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("asset_id", "minecraft:entity/frog/cold_frog")).put("spawn_conditions", (BinaryTag)ListBinaryTag.empty());
                    registryContainer.put("minecraft:frog_variant", (BinaryTag)this.createRegistry("minecraft:frog_variant", Map.of("minecraft:cold", frogVariant.build())));
                    CompoundBinaryTag.Builder pigVariant = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("asset_id", "minecraft:entity/pig/cold_pig")).putString("model", "cold")).put("spawn_conditions", (BinaryTag)ListBinaryTag.empty());
                    registryContainer.put("minecraft:pig_variant", (BinaryTag)this.createRegistry("minecraft:pig_variant", Map.of("minecraft:cold", pigVariant.build())));
                    CompoundBinaryTag.Builder wolfSoundVariant = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("ambient_sound", "minecraft:entity.wolf_angry.ambient")).putString("death_sound", "minecraft:entity.wolf_angry.death")).putString("growl_sound", "minecraft:entity.wolf_angry.growl")).putString("hurt_sound", "minecraft:entity.wolf_angry.hurt")).putString("pant_sound", "minecraft:entity.wolf_angry.pant")).putString("whine_sound", "minecraft:entity.wolf_angry.whine");
                    registryContainer.put("minecraft:wolf_sound_variant", (BinaryTag)this.createRegistry("minecraft:wolf_sound_variant", Map.of("minecraft:angry", wolfSoundVariant.build())));
                    CompoundBinaryTag.Builder wolfVariant = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("assets", (BinaryTag)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("wild", "minecraft:entity/wolf/wolf_ashen")).putString("tame", "minecraft:entity/wolf/wolf_ashen_tame")).putString("angry", "minecraft:entity/wolf/wolf_ashen_angry")).build())).put("spawn_conditions", (BinaryTag)ListBinaryTag.empty());
                    registryContainer.put("minecraft:wolf_variant", (BinaryTag)this.createRegistry("minecraft:wolf_variant", Map.of("minecraft:ashen", wolfVariant.build())));
                } else {
                    CompoundBinaryTag.Builder wolfVariant = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("wild_texture", "minecraft:entity/wolf/wolf_ashen")).putString("tame_texture", "minecraft:entity/wolf/wolf_ashen_tame")).putString("angry_texture", "minecraft:entity/wolf/wolf_ashen_angry")).put("biomes", (BinaryTag)((ListBinaryTag.Builder)ListBinaryTag.builder().add((BinaryTag)StringBinaryTag.stringBinaryTag((String)"minecraft:plains"))).build());
                    registryContainer.put("minecraft:wolf_variant", (BinaryTag)this.createRegistry("minecraft:wolf_variant", Map.of("minecraft:ashen", wolfVariant.build())));
                }
            }
        } else {
            registryContainer.put("dimension", (BinaryTag)encodedDimensionRegistry);
        }
        try {
            CompoundBinaryTag currentDimensionData = encodedDimensionRegistry.getCompound(dimension.getModernID());
            if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_16_2) >= 0) {
                currentDimensionData = currentDimensionData.getCompound("element");
            }
            CURRENT_DIMENSION_DATA_FIELD.invokeExact(joinGame, currentDimensionData);
            LEVEL_NAMES_FIELDS.invokeExact(joinGame, LEVELS);
            REGISTRY_FIELD.invokeExact(joinGame, registryContainer.build());
        }
        catch (Throwable e) {
            throw new ReflectionException(e);
        }
        return joinGame;
    }

    private JoinGamePacket createLegacyJoinGamePacket() {
        JoinGamePacket joinGame = this.createJoinGamePacket(ProtocolVersion.MINIMUM_VERSION);
        joinGame.setDimension(this.world.getDimension().getLegacyID());
        return joinGame;
    }

    private DefaultSpawnPositionPacket createDefaultSpawnPositionPacket() {
        return new DefaultSpawnPositionPacket((int)this.world.getSpawnX(), (int)this.world.getSpawnY(), (int)this.world.getSpawnZ(), 0.0f);
    }

    private TimeUpdatePacket createWorldTicksPacket() {
        return this.worldTicks == null ? null : new TimeUpdatePacket(this.worldTicks, this.worldTicks);
    }

    private AvailableCommandsPacket createAvailableCommandsPacket() {
        try {
            AvailableCommandsPacket packet = new AvailableCommandsPacket();
            ROOT_NODE_FIELD.invokeExact(packet, this.commandNode);
            return packet;
        }
        catch (Throwable e) {
            throw new ReflectionException(e);
        }
    }

    private PreparedPacket createFirstChunks() {
        PreparedPacket packet = this.plugin.createPreparedPacket();
        List<List<VirtualChunk>> orderedChunks = this.world.getOrderedChunks();
        int chunkCounter = 0;
        for (List<VirtualChunk> chunksWithSameDistance : orderedChunks) {
            if (++chunkCounter > Settings.IMP.MAIN.CHUNK_RADIUS_SEND_ON_SPAWN) break;
            for (VirtualChunk chunk : chunksWithSameDistance) {
                packet.prepare(this.createChunkData(chunk, this.world.getDimension()));
            }
        }
        return packet.build();
    }

    private List<PreparedPacket> createDelayedChunksPackets() {
        List<List<VirtualChunk>> orderedChunks = this.world.getOrderedChunks();
        if (orderedChunks.size() <= Settings.IMP.MAIN.CHUNK_RADIUS_SEND_ON_SPAWN) {
            return List.of();
        }
        LinkedList<PreparedPacket> packets = new LinkedList<PreparedPacket>();
        PreparedPacket packet = this.plugin.createPreparedPacket();
        int chunkCounter = 0;
        ListIterator<List<VirtualChunk>> distanceIterator = orderedChunks.listIterator();
        for (int i = 0; i < Settings.IMP.MAIN.CHUNK_RADIUS_SEND_ON_SPAWN; ++i) {
            distanceIterator.next();
        }
        while (distanceIterator.hasNext()) {
            for (VirtualChunk chunk : (List)distanceIterator.next()) {
                if (++chunkCounter > Settings.IMP.MAIN.CHUNKS_PER_TICK) {
                    packets.add(packet.build());
                    packet = this.plugin.createPreparedPacket();
                    chunkCounter = 0;
                }
                packet.prepare(this.createChunkData(chunk, this.world.getDimension()));
            }
        }
        packets.add(packet.build());
        return packets;
    }

    private List<MinecraftPacket> createFastClientServerSwitch(JoinGamePacket joinGame, ProtocolVersion version) {
        ArrayList<MinecraftPacket> packets = new ArrayList<MinecraftPacket>();
        RespawnPacket respawn = RespawnPacket.fromJoinGame((JoinGamePacket)joinGame);
        if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_16) < 0) {
            joinGame.setDimension(joinGame.getDimension() == 0 ? -1 : 0);
        }
        packets.add((MinecraftPacket)joinGame);
        packets.add((MinecraftPacket)respawn);
        return packets;
    }

    private List<MinecraftPacket> createSafeClientServerSwitch(JoinGamePacket joinGame) {
        ArrayList<MinecraftPacket> packets = new ArrayList<MinecraftPacket>();
        packets.add((MinecraftPacket)joinGame);
        RespawnPacket fakeSwitchPacket = RespawnPacket.fromJoinGame((JoinGamePacket)joinGame);
        fakeSwitchPacket.setDimension(joinGame.getDimension() == 0 ? -1 : 0);
        packets.add((MinecraftPacket)fakeSwitchPacket);
        RespawnPacket correctSwitchPacket = RespawnPacket.fromJoinGame((JoinGamePacket)joinGame);
        packets.add((MinecraftPacket)correctSwitchPacket);
        return packets;
    }

    private PreparedPacket getBrandMessage(Class<? extends LimboSessionHandler> clazz) {
        PreparedPacket preparedPacket = this.brandMessages.get(clazz);
        if (preparedPacket == null) {
            preparedPacket = this.plugin.createPreparedPacket().prepare(this.createBrandMessage(ProtocolVersion.MINECRAFT_1_7_2), ProtocolVersion.MINECRAFT_1_7_2, ProtocolVersion.MINECRAFT_1_7_6).prepare(this.createBrandMessage(ProtocolVersion.MINECRAFT_1_8), ProtocolVersion.MINECRAFT_1_8).build();
            this.brandMessages.put(clazz, preparedPacket);
        }
        return preparedPacket;
    }

    private PluginMessagePacket createBrandMessage(ProtocolVersion version) {
        String brand = "LimboAPI (" + Settings.IMP.VERSION + ") -> " + this.limboName;
        ByteBuf bufWithBrandString = Unpooled.buffer();
        if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) < 0) {
            bufWithBrandString.writeCharSequence((CharSequence)brand, StandardCharsets.UTF_8);
        } else {
            ProtocolUtils.writeString((ByteBuf)bufWithBrandString, (CharSequence)brand);
        }
        return new PluginMessagePacket("MC|Brand", bufWithBrandString);
    }

    private PositionRotationPacket createPlayerPosAndLook(double posX, double posY, double posZ, float yaw, float pitch) {
        return new PositionRotationPacket(posX, posY, posZ, yaw, pitch, false, 44, true);
    }

    private UpdateViewPositionPacket createUpdateViewPosition(int posX, int posZ) {
        return new UpdateViewPositionPacket(posX >> 4, posZ >> 4);
    }

    private ChunkDataPacket createChunkData(VirtualChunk chunk, Dimension dimension) {
        return new ChunkDataPacket(chunk.getFullChunkSnapshot(), dimension.hasLegacySkyLight(), dimension.getMaxSections());
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    private /* synthetic */ void lambda$spawnPlayer$13(MinecraftConnection serverConnection, ConnectedPlayer player, LimboSessionHandler handler, RegisteredServer previousServer) {
        serverConnection.getChannel().close().addListener(f -> this.spawnPlayerLocal(player, handler, previousServer));
    }

    static {
        try {
            PARTIAL_HASHED_SEED_FIELD = MethodHandles.privateLookupIn(JoinGamePacket.class, MethodHandles.lookup()).findSetter(JoinGamePacket.class, "partialHashedSeed", Long.TYPE);
            CURRENT_DIMENSION_DATA_FIELD = MethodHandles.privateLookupIn(JoinGamePacket.class, MethodHandles.lookup()).findSetter(JoinGamePacket.class, "currentDimensionData", CompoundBinaryTag.class);
            ROOT_NODE_FIELD = MethodHandles.privateLookupIn(AvailableCommandsPacket.class, MethodHandles.lookup()).findSetter(AvailableCommandsPacket.class, "rootNode", RootCommandNode.class);
            GRACEFUL_DISCONNECT_FIELD = MethodHandles.privateLookupIn(VelocityServerConnection.class, MethodHandles.lookup()).findSetter(VelocityServerConnection.class, "gracefulDisconnect", Boolean.TYPE);
            REGISTRY_FIELD = MethodHandles.privateLookupIn(JoinGamePacket.class, MethodHandles.lookup()).findSetter(JoinGamePacket.class, "registry", CompoundBinaryTag.class);
            LEVEL_NAMES_FIELDS = MethodHandles.privateLookupIn(JoinGamePacket.class, MethodHandles.lookup()).findSetter(JoinGamePacket.class, "levelNames", ImmutableSet.class);
            try (InputStream stream = LimboAPI.class.getResourceAsStream("/mapping/chat_type_1_19.nbt");){
                CHAT_TYPE_119 = BinaryTagIO.unlimitedReader().read(Objects.requireNonNull(stream), BinaryTagIO.Compression.GZIP);
            }
            stream = LimboAPI.class.getResourceAsStream("/mapping/chat_type_1_19_1.nbt");
            try {
                CHAT_TYPE_1191 = BinaryTagIO.unlimitedReader().read(Objects.requireNonNull(stream), BinaryTagIO.Compression.GZIP);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            stream = LimboAPI.class.getResourceAsStream("/mapping/damage_type_1_19_4.nbt");
            try {
                DAMAGE_TYPE_1194 = BinaryTagIO.unlimitedReader().read(Objects.requireNonNull(stream), BinaryTagIO.Compression.GZIP);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            stream = LimboAPI.class.getResourceAsStream("/mapping/damage_type_1_20.nbt");
            try {
                DAMAGE_TYPE_120 = BinaryTagIO.unlimitedReader().read(Objects.requireNonNull(stream), BinaryTagIO.Compression.GZIP);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ReflectionException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

