/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.server;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.client.ClientConfigSessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.LegacyPlayerListItemPacket;
import com.velocitypowered.proxy.protocol.packet.UpsertPlayerInfoPacket;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import net.elytrium.limboapi.LimboAPI;
import net.elytrium.limboapi.api.Limbo;
import net.elytrium.limboapi.api.material.Item;
import net.elytrium.limboapi.api.material.VirtualItem;
import net.elytrium.limboapi.api.player.GameMode;
import net.elytrium.limboapi.api.player.LimboPlayer;
import net.elytrium.limboapi.api.protocol.item.ItemComponentMap;
import net.elytrium.limboapi.api.protocol.packets.data.MapData;
import net.elytrium.limboapi.api.protocol.packets.data.MapPalette;
import net.elytrium.limboapi.injection.login.LoginTasksQueue;
import net.elytrium.limboapi.protocol.packets.s2c.ChangeGameStatePacket;
import net.elytrium.limboapi.protocol.packets.s2c.MapDataPacket;
import net.elytrium.limboapi.protocol.packets.s2c.PlayerAbilitiesPacket;
import net.elytrium.limboapi.protocol.packets.s2c.PositionRotationPacket;
import net.elytrium.limboapi.protocol.packets.s2c.SetSlotPacket;
import net.elytrium.limboapi.protocol.packets.s2c.TimeUpdatePacket;
import net.elytrium.limboapi.server.LimboImpl;
import net.elytrium.limboapi.server.LimboSessionHandlerImpl;
import net.elytrium.limboapi.server.world.SimpleItem;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;

public class LimboPlayerImpl
implements LimboPlayer {
    private final LimboAPI plugin;
    private final LimboImpl server;
    private final ConnectedPlayer player;
    private final MinecraftConnection connection;
    private final LimboSessionHandlerImpl sessionHandler;
    private final ProtocolVersion version;
    private GameMode gameMode = GameMode.ADVENTURE;

    public LimboPlayerImpl(LimboAPI plugin, LimboImpl server, ConnectedPlayer player) {
        this.plugin = plugin;
        this.server = server;
        this.player = player;
        this.connection = this.player.getConnection();
        this.sessionHandler = (LimboSessionHandlerImpl)this.connection.getActiveSessionHandler();
        this.version = this.player.getProtocolVersion();
    }

    @Override
    public void writePacket(Object packetObj) {
        this.connection.delayedWrite(packetObj);
    }

    @Override
    public void writePacketAndFlush(Object packetObj) {
        this.connection.write(packetObj);
    }

    @Override
    public void flushPackets() {
        this.connection.flush();
    }

    @Override
    public void closeWith(Object packetObj) {
        this.connection.closeWith(packetObj);
    }

    @Override
    public ScheduledExecutorService getScheduledExecutor() {
        return this.connection.eventLoop();
    }

    @Override
    public void sendImage(BufferedImage image) {
        this.sendImage(0, image, true, true);
    }

    @Override
    public void sendImage(BufferedImage image, boolean sendItem) {
        this.sendImage(0, image, sendItem, true);
    }

    @Override
    public void sendImage(int mapID, BufferedImage image) {
        this.sendImage(mapID, image, true, true);
    }

    @Override
    public void sendImage(int mapID, BufferedImage image, boolean sendItem) {
        this.sendImage(mapID, image, sendItem, true);
    }

    @Override
    public void sendImage(int mapID, BufferedImage image, boolean sendItem, boolean resize) {
        if (sendItem) {
            this.setInventory(36, (VirtualItem)SimpleItem.fromItem(Item.FILLED_MAP), 1, mapID, this.version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_17) < 0 ? null : ((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("map", (BinaryTag)IntBinaryTag.intBinaryTag((int)mapID))).build());
        }
        if (image.getWidth() != 128 || image.getHeight() != 128) {
            if (resize) {
                BufferedImage resizedImage = new BufferedImage(128, 128, image.getType());
                Graphics2D graphics = resizedImage.createGraphics();
                graphics.drawImage(image.getScaledInstance(128, 128, 4), 0, 0, null);
                graphics.dispose();
                image = resizedImage;
            } else {
                throw new IllegalStateException("You either need to provide an image of 128x128 pixels or set the resize parameter to true so that API will automatically resize your image.");
            }
        }
        int[] toWrite = MapPalette.imageToBytes(image, this.version);
        if (this.version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) < 0) {
            int i;
            canvas = new byte[128][128];
            for (i = 0; i < 16384; ++i) {
                canvas[i & 0x7F][i >> 7] = (byte)toWrite[i];
            }
            for (i = 0; i < 128; ++i) {
                this.writePacket(new MapDataPacket(mapID, 0, new MapData(i, (byte[])canvas[i])));
            }
            this.flushPackets();
        } else {
            canvas = new byte[16384];
            for (int i = 0; i < 16384; ++i) {
                canvas[i] = (byte)toWrite[i];
            }
            this.writePacketAndFlush(new MapDataPacket(mapID, 0, new MapData((byte[])canvas)));
        }
    }

    @Override
    public void setInventory(VirtualItem item, int count) {
        this.writePacketAndFlush(new SetSlotPacket(0, 36, item, count, 0, null, null));
    }

    @Override
    public void setInventory(VirtualItem item, int slot, int count) {
        this.writePacketAndFlush(new SetSlotPacket(0, slot, item, count, 0, null, null));
    }

    @Override
    public void setInventory(int slot, VirtualItem item, int count, int data, CompoundBinaryTag nbt) {
        this.writePacketAndFlush(new SetSlotPacket(0, slot, item, count, data, nbt, null));
    }

    @Override
    public void setInventory(int slot, VirtualItem item, int count, int data, ItemComponentMap map) {
        this.writePacketAndFlush(new SetSlotPacket(0, slot, item, count, data, null, map));
    }

    @Override
    public void setGameMode(GameMode gameMode) {
        boolean is17;
        boolean bl = is17 = this.version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) < 0;
        if (gameMode != GameMode.SPECTATOR || !is17) {
            this.gameMode = gameMode;
            short id = this.gameMode.getID();
            this.sendAbilities();
            if (!is17) {
                UUID uuid = this.plugin.getInitialID((Player)this.player);
                if (this.connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_19_1) <= 0) {
                    this.writePacket(new LegacyPlayerListItemPacket(1, List.of(new LegacyPlayerListItemPacket.Item(uuid).setGameMode((int)id))));
                } else {
                    UpsertPlayerInfoPacket.Entry playerInfoEntry = new UpsertPlayerInfoPacket.Entry(uuid);
                    playerInfoEntry.setGameMode((int)id);
                    this.writePacket(new UpsertPlayerInfoPacket(EnumSet.of(UpsertPlayerInfoPacket.Action.UPDATE_GAME_MODE), List.of(playerInfoEntry)));
                }
            }
            this.writePacket(new ChangeGameStatePacket(3, id));
            this.flushPackets();
        }
    }

    @Override
    public void teleport(double posX, double posY, double posZ, float yaw, float pitch) {
        this.writePacketAndFlush(new PositionRotationPacket(posX, posY, posZ, yaw, pitch, false, 44, true));
    }

    @Override
    public void disableFalling() {
        this.writePacketAndFlush(new PlayerAbilitiesPacket((byte)(this.getAbilities() | 2 | 4), 0.0f, 0.0f));
    }

    @Override
    public void enableFalling() {
        this.writePacketAndFlush(new PlayerAbilitiesPacket((byte)(this.getAbilities() & 0xFFFFFFFD), 0.05f, 0.1f));
    }

    @Override
    public void disconnect() {
        this.connection.eventLoop().execute(() -> {
            if (this.connection.getActiveSessionHandler() == this.sessionHandler) {
                this.sessionHandler.disconnect(() -> {
                    if (this.plugin.hasLoginQueue((Player)this.player)) {
                        if (this.connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_2) >= 0) {
                            this.sessionHandler.disconnectToConfig(() -> this.plugin.getLoginQueue((Player)this.player).next());
                        } else {
                            this.sessionHandler.disconnected();
                            this.plugin.getLoginQueue((Player)this.player).next();
                        }
                    } else {
                        RegisteredServer server = this.sessionHandler.getPreviousServer();
                        if (server != null) {
                            this.sendToRegisteredServer(server);
                        } else {
                            this.sessionHandler.disconnected();
                        }
                    }
                });
            }
        });
    }

    @Override
    public void disconnect(RegisteredServer server) {
        this.connection.eventLoop().execute(() -> {
            if (this.connection.getActiveSessionHandler() == this.sessionHandler) {
                this.sessionHandler.disconnect(() -> {
                    if (this.plugin.hasLoginQueue((Player)this.player)) {
                        if (this.connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_2) >= 0) {
                            this.sessionHandler.disconnectToConfig(() -> {
                                this.plugin.setNextServer((Player)this.player, server);
                                this.plugin.getLoginQueue((Player)this.player).next();
                            });
                        } else {
                            this.sessionHandler.disconnected();
                            this.plugin.setNextServer((Player)this.player, server);
                            this.plugin.getLoginQueue((Player)this.player).next();
                        }
                    } else {
                        this.sendToRegisteredServer(server);
                    }
                });
            }
        });
    }

    private void deject() {
        this.plugin.deject3rdParty(this.connection.getChannel().pipeline());
        this.plugin.fixCompressor(this.connection.getChannel().pipeline(), this.version);
    }

    private void sendToRegisteredServer(RegisteredServer server) {
        this.deject();
        this.connection.setState(StateRegistry.PLAY);
        if (this.connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_2) >= 0) {
            this.sessionHandler.disconnectToConfig(() -> {
                ClientConfigSessionHandler handler = new ClientConfigSessionHandler(this.plugin.getServer(), this.player);
                LoginTasksQueue.BRAND_CHANNEL_SETTER.accept(handler, "minecraft:brand");
                this.connection.setActiveSessionHandler(StateRegistry.CONFIG, (MinecraftSessionHandler)handler);
                this.player.createConnectionRequest(server).fireAndForget();
            });
        } else {
            if (this.connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_19_1) <= 0) {
                this.connection.delayedWrite((Object)new LegacyPlayerListItemPacket(4, List.of(new LegacyPlayerListItemPacket.Item(this.plugin.getInitialID((Player)this.player)))));
            }
            this.sessionHandler.disconnected();
            this.player.createConnectionRequest(server).fireAndForget();
        }
    }

    @Override
    public void sendAbilities() {
        this.writePacketAndFlush(new PlayerAbilitiesPacket(this.getAbilities(), 0.05f, 0.1f));
    }

    @Override
    public void sendAbilities(int abilities, float flySpeed, float walkSpeed) {
        this.writePacketAndFlush(new PlayerAbilitiesPacket((byte)abilities, flySpeed, walkSpeed));
    }

    @Override
    public void sendAbilities(byte abilities, float flySpeed, float walkSpeed) {
        this.writePacketAndFlush(new PlayerAbilitiesPacket(abilities, flySpeed, walkSpeed));
    }

    @Override
    public byte getAbilities() {
        return switch (this.gameMode) {
            case GameMode.CREATIVE -> 13;
            case GameMode.SPECTATOR -> 7;
            default -> 0;
        };
    }

    @Override
    public GameMode getGameMode() {
        return this.gameMode;
    }

    @Override
    public Limbo getServer() {
        return this.server;
    }

    @Override
    public Player getProxyPlayer() {
        return this.player;
    }

    @Override
    public int getPing() {
        LimboSessionHandlerImpl handler = (LimboSessionHandlerImpl)this.connection.getActiveSessionHandler();
        if (handler != null) {
            return handler.getPing();
        }
        return -1;
    }

    @Override
    public void setWorldTime(long ticks) {
        this.writePacketAndFlush(new TimeUpdatePacket(ticks, ticks));
    }
}

