/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.server.item;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.velocitypowered.api.network.ProtocolVersion;
import it.unimi.dsi.fastutil.Function;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.elytrium.limboapi.LimboAPI;
import net.elytrium.limboapi.server.item.type.BooleanItemComponent;
import net.elytrium.limboapi.server.item.type.ComponentItemComponent;
import net.elytrium.limboapi.server.item.type.ComponentsItemComponent;
import net.elytrium.limboapi.server.item.type.DyedColorItemComponent;
import net.elytrium.limboapi.server.item.type.EmptyItemComponent;
import net.elytrium.limboapi.server.item.type.EnchantmentsItemComponent;
import net.elytrium.limboapi.server.item.type.GameProfileItemComponent;
import net.elytrium.limboapi.server.item.type.IntItemComponent;
import net.elytrium.limboapi.server.item.type.StringItemComponent;
import net.elytrium.limboapi.server.item.type.StringsItemComponent;
import net.elytrium.limboapi.server.item.type.TagItemComponent;
import net.elytrium.limboapi.server.item.type.VarIntItemComponent;
import net.elytrium.limboapi.server.item.type.WriteableItemComponent;

public class SimpleItemComponentManager {
    private static final Gson GSON = new Gson();
    private static final Map<ProtocolVersion, Object2IntMap<String>> ID = new HashMap<ProtocolVersion, Object2IntMap<String>>();
    private final Map<String, Function<ProtocolVersion, WriteableItemComponent>> factory = new HashMap<String, Function<ProtocolVersion, WriteableItemComponent>>();

    public SimpleItemComponentManager() {
        this.register("minecraft:lore", (Function<ProtocolVersion, WriteableItemComponent>)((Function)version -> new ComponentsItemComponent("minecraft:lore")));
        this.register("minecraft:dyed_color", (Function<ProtocolVersion, WriteableItemComponent>)((Function)version -> new DyedColorItemComponent("minecraft:dyed_color")));
        this.register("minecraft:profile", (Function<ProtocolVersion, WriteableItemComponent>)((Function)version -> new GameProfileItemComponent("minecraft:profile")));
        for (String type : new String[]{"minecraft:max_stack_size", "minecraft:max_damage", "minecraft:damage", "minecraft:rarity", "minecraft:custom_model_data", "minecraft:repair_cost", "minecraft:map_id", "minecraft:map_post_processing", "minecraft:ominous_bottle_amplifier", "minecraft:base_color"}) {
            this.register(type, (Function<ProtocolVersion, WriteableItemComponent>)((Function)version -> new VarIntItemComponent(type)));
        }
        for (String type : new String[]{"minecraft:unbreakable", "minecraft:enchantment_glint_override"}) {
            this.register(type, (Function<ProtocolVersion, WriteableItemComponent>)((Function)version -> new BooleanItemComponent(type)));
        }
        for (String type : new String[]{"minecraft:custom_name", "minecraft:item_name"}) {
            this.register(type, (Function<ProtocolVersion, WriteableItemComponent>)((Function)version -> new ComponentItemComponent(type)));
        }
        for (String type : new String[]{"minecraft:hide_additional_tooltip", "minecraft:hide_tooltip", "minecraft:creative_slot_lock", "minecraft:fire_resistant"}) {
            this.register(type, (Function<ProtocolVersion, WriteableItemComponent>)((Function)version -> new EmptyItemComponent(type)));
        }
        for (String type : new String[]{"minecraft:enchantments", "minecraft:stored_enchantments"}) {
            this.register(type, (Function<ProtocolVersion, WriteableItemComponent>)((Function)version -> new EnchantmentsItemComponent(type)));
        }
        for (String type : new String[]{"minecraft:map_color"}) {
            this.register(type, (Function<ProtocolVersion, WriteableItemComponent>)((Function)version -> new IntItemComponent(type)));
        }
        for (String type : new String[]{"minecraft:custom_data", "minecraft:entity_data", "minecraft:bucket_entity_data", "minecraft:block_entity_data"}) {
            this.register(type, (Function<ProtocolVersion, WriteableItemComponent>)((Function)version -> new TagItemComponent(type)));
        }
        for (String type : new String[]{"minecraft:instrument", "minecraft:note_block_sound"}) {
            this.register(type, (Function<ProtocolVersion, WriteableItemComponent>)((Function)version -> new StringItemComponent(type)));
        }
        for (String type : new String[]{"minecraft:recipes"}) {
            this.register(type, (Function<ProtocolVersion, WriteableItemComponent>)((Function)version -> new StringsItemComponent(type)));
        }
    }

    public <T> void register(String name, Function<ProtocolVersion, WriteableItemComponent> factory) {
        this.factory.put(name, factory);
    }

    public <T> WriteableItemComponent<T> createComponent(ProtocolVersion version, String name) {
        return (WriteableItemComponent)this.factory.get(name).apply((Object)version);
    }

    public int getId(String name, ProtocolVersion version) {
        Object2IntMap<String> ids = ID.get(version);
        if (ids == null) {
            throw new IllegalArgumentException("unsupported version: " + String.valueOf(version));
        }
        if (!ids.containsKey((Object)name)) {
            throw new IllegalStateException("component not found: " + name);
        }
        return ids.getInt((Object)name);
    }

    static {
        LinkedTreeMap mapping = (LinkedTreeMap)GSON.fromJson((Reader)new InputStreamReader(Objects.requireNonNull(LimboAPI.class.getResourceAsStream("/mapping/data_component_types_mapping.json")), StandardCharsets.UTF_8), LinkedTreeMap.class);
        LinkedTreeMap components = (LinkedTreeMap)GSON.fromJson((Reader)new InputStreamReader(Objects.requireNonNull(LimboAPI.class.getResourceAsStream("/mapping/data_component_types.json")), StandardCharsets.UTF_8), LinkedTreeMap.class);
        HashMap<String, ProtocolVersion> cache = new HashMap<String, ProtocolVersion>();
        for (ProtocolVersion version : ProtocolVersion.values()) {
            if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_5) < 0) continue;
            cache.put(version.name().substring("MINECRAFT_".length()).replace('_', '.'), version);
        }
        components.forEach((name, id) -> ((LinkedTreeMap)mapping.get(id)).forEach((version, protocolId) -> ID.computeIfAbsent((ProtocolVersion)cache.get(version), key -> new Object2IntOpenHashMap()).put(name, Integer.parseInt(protocolId))));
    }
}

