/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.server.world.chunk;

import java.util.List;
import net.elytrium.limboapi.api.chunk.VirtualBiome;
import net.elytrium.limboapi.api.chunk.VirtualBlock;
import net.elytrium.limboapi.api.chunk.VirtualBlockEntity;
import net.elytrium.limboapi.api.chunk.data.ChunkSnapshot;
import net.elytrium.limboapi.api.chunk.data.LightSection;
import net.elytrium.limboapi.server.world.SimpleBlock;
import net.elytrium.limboapi.server.world.chunk.SimpleSection;

public class SimpleChunkSnapshot
implements ChunkSnapshot {
    private final int posX;
    private final int posZ;
    private final boolean fullChunk;
    private final SimpleSection[] sections;
    private final LightSection[] light;
    private final VirtualBiome[] biomes;
    private final List<VirtualBlockEntity.Entry> blockEntityEntries;

    public SimpleChunkSnapshot(int posX, int posZ, boolean fullChunk, SimpleSection[] sections, LightSection[] light, VirtualBiome[] biomes, List<VirtualBlockEntity.Entry> blockEntityEntries) {
        this.posX = posX;
        this.posZ = posZ;
        this.fullChunk = fullChunk;
        this.sections = sections;
        this.light = light;
        this.biomes = biomes;
        this.blockEntityEntries = blockEntityEntries;
    }

    @Override
    public VirtualBlock getBlock(int posX, int posY, int posZ) {
        SimpleSection section = this.sections[posY >> 4];
        return section == null ? SimpleBlock.AIR : section.getBlockAt(posX, posY & 0xF, posZ);
    }

    @Override
    public int getPosX() {
        return this.posX;
    }

    @Override
    public int getPosZ() {
        return this.posZ;
    }

    @Override
    public boolean isFullChunk() {
        return this.fullChunk;
    }

    public SimpleSection[] getSections() {
        return this.sections;
    }

    @Override
    public LightSection[] getLight() {
        return this.light;
    }

    @Override
    public VirtualBiome[] getBiomes() {
        return this.biomes;
    }

    @Override
    public List<VirtualBlockEntity.Entry> getBlockEntityEntries() {
        return this.blockEntityEntries;
    }
}

