/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.server.world.chunk;

import com.google.common.base.Preconditions;
import net.elytrium.limboapi.api.chunk.data.LightSection;
import net.elytrium.limboapi.api.mcprotocollib.NibbleArray3D;

public class SimpleLightSection
implements LightSection {
    private static final NibbleArray3D NO_LIGHT = new NibbleArray3D(4096);
    private static final NibbleArray3D ALL_LIGHT = new NibbleArray3D(4096, 15);
    private NibbleArray3D blockLight;
    private NibbleArray3D skyLight;
    private long lastUpdate;

    public SimpleLightSection() {
        this(NO_LIGHT, ALL_LIGHT, System.nanoTime());
    }

    private SimpleLightSection(NibbleArray3D blockLight, NibbleArray3D skyLight, long lastUpdate) {
        this.blockLight = blockLight;
        this.skyLight = skyLight;
        this.lastUpdate = lastUpdate;
    }

    @Override
    public void setBlockLight(int posX, int posY, int posZ, byte light) {
        this.checkIndexes(posX, posY, posZ);
        Preconditions.checkArgument((light >= 0 && light <= 15 ? 1 : 0) != 0, (Object)"light should be between 0 and 15");
        if (this.blockLight == NO_LIGHT && light != 0) {
            this.blockLight = new NibbleArray3D(4096);
        }
        this.blockLight.set(posX, posY, posZ, light);
        this.lastUpdate = System.nanoTime();
    }

    @Override
    public NibbleArray3D getBlockLight() {
        return this.blockLight;
    }

    @Override
    public byte getBlockLight(int posX, int posY, int posZ) {
        this.checkIndexes(posX, posY, posZ);
        return (byte)this.blockLight.get(posX, posY, posZ);
    }

    @Override
    public void setSkyLight(int posX, int posY, int posZ, byte light) {
        this.checkIndexes(posX, posY, posZ);
        Preconditions.checkArgument((light >= 0 && light <= 15 ? 1 : 0) != 0, (Object)"light should be between 0 and 15");
        if (this.skyLight == ALL_LIGHT && light != 15) {
            this.skyLight = new NibbleArray3D(4096);
        }
        this.skyLight.set(posX, posY, posZ, light);
        this.lastUpdate = System.nanoTime();
    }

    @Override
    public NibbleArray3D getSkyLight() {
        return this.skyLight;
    }

    @Override
    public byte getSkyLight(int posX, int posY, int posZ) {
        this.checkIndexes(posX, posY, posZ);
        return (byte)this.skyLight.get(posX, posY, posZ);
    }

    private void checkIndexes(int posX, int posY, int posZ) {
        Preconditions.checkArgument((boolean)this.checkIndex(posX), (Object)"x should be between 0 and 15");
        Preconditions.checkArgument((boolean)this.checkIndex(posY), (Object)"y should be between 0 and 15");
        Preconditions.checkArgument((boolean)this.checkIndex(posZ), (Object)"z should be between 0 and 15");
    }

    private boolean checkIndex(int pos) {
        return pos >= 0 && pos <= 15;
    }

    @Override
    public long getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public SimpleLightSection copy() {
        NibbleArray3D skyLight = this.skyLight == ALL_LIGHT ? ALL_LIGHT : this.skyLight.copy();
        NibbleArray3D blockLight = this.blockLight == NO_LIGHT ? NO_LIGHT : this.blockLight.copy();
        return new SimpleLightSection(blockLight, skyLight, this.lastUpdate);
    }
}

