/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.thirdparty.commons.velocity.commands;

import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.common.value.qual.IntRange;

public class SuggestUtils {
    public static @NonNull List<String> suggest(@NonNull String @NonNull [] args, @IntRange(from=1L) int position, String ... suggestions) {
        return SuggestUtils.processArguments(args, position, Arrays.asList(suggestions));
    }

    public static @NonNull List<String> suggestPlayers(@NonNull ProxyServer server, @NonNull String @NonNull [] args, @IntRange(from=1L) int position, String ... additions) {
        List<String> initialList = SuggestUtils.getAllPlayers(server);
        initialList.addAll((Collection<String>)ImmutableList.copyOf((Object[])additions));
        return SuggestUtils.processArguments(args, position, initialList);
    }

    public static @NonNull List<String> suggestServers(@NonNull ProxyServer server, @NonNull String @NonNull [] args, @IntRange(from=1L) int position, String ... additions) {
        List<String> initialList = SuggestUtils.getRegisteredServers(server);
        initialList.addAll((Collection<String>)ImmutableList.copyOf((Object[])additions));
        return SuggestUtils.processArguments(args, position, initialList);
    }

    public static @NonNull List<String> suggestServersAndPlayers(@NonNull ProxyServer server, @NonNull String @NonNull [] args, @IntRange(from=1L) int position, String ... additions) {
        List<String> suggestions = SuggestUtils.getAllPlayers(server);
        suggestions.addAll(SuggestUtils.getRegisteredServers(server));
        suggestions.addAll((Collection<String>)ImmutableList.copyOf((Object[])additions));
        return SuggestUtils.processArguments(args, position, suggestions);
    }

    public static @NonNull List<String> getAllPlayers(@NonNull ProxyServer server) {
        return server.getAllPlayers().stream().map(Player::getUsername).collect(Collectors.toList());
    }

    public static @NonNull List<String> getRegisteredServers(@NonNull ProxyServer server) {
        return server.getAllServers().stream().map(RegisteredServer::getServerInfo).map(ServerInfo::getName).collect(Collectors.toList());
    }

    private static @NonNull List<String> processArguments(@NonNull String @NonNull [] args, int position, @NonNull List<String> suggestions) {
        if (args.length == 0) {
            return suggestions;
        }
        if (args.length == position) {
            String argument = args[position - 1];
            return suggestions.stream().filter(suggestion -> suggestion.regionMatches(true, 0, argument, 0, argument.length())).collect(Collectors.toList());
        }
        return ImmutableList.of();
    }
}

