/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.instasmeltx;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.BlastFurnace;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import org.bukkit.block.Smoker;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class InstaSmeltX
extends JavaPlugin
implements Listener {
    private boolean enableFurnace;
    private boolean enableSmoker;
    private boolean enableBlastFurnace;
    private boolean maintainFuelConsumption;
    private Map<Material, Integer> fuelValues;
    private final Map<Block, Integer> remainingItemsForFuel = new HashMap<Block, Integer>();
    private final Map<Block, Material> currentFuelType = new HashMap<Block, Material>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("InstaSmeltX has been enabled! Enjoy instant smelting!");
    }

    public void onDisable() {
        this.remainingItemsForFuel.clear();
        this.currentFuelType.clear();
        this.getLogger().info("InstaSmeltX has been disabled!");
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.enableFurnace = config.getBoolean("enable-furnace", true);
        this.enableSmoker = config.getBoolean("enable-smoker", true);
        this.enableBlastFurnace = config.getBoolean("enable-blast-furnace", true);
        this.maintainFuelConsumption = config.getBoolean("maintain-fuel-consumption", true);
        this.loadFuelValues();
    }

    private void loadFuelValues() {
        this.fuelValues = new HashMap<Material, Integer>();
        this.fuelValues.put(Material.COAL, 8);
        this.fuelValues.put(Material.CHARCOAL, 8);
        this.fuelValues.put(Material.COAL_BLOCK, 80);
        this.fuelValues.put(Material.LAVA_BUCKET, 100);
        this.fuelValues.put(Material.BLAZE_ROD, 12);
        this.fuelValues.put(Material.WOODEN_AXE, 1);
        this.fuelValues.put(Material.WOODEN_HOE, 1);
        this.fuelValues.put(Material.WOODEN_PICKAXE, 1);
        this.fuelValues.put(Material.WOODEN_SHOVEL, 1);
        this.fuelValues.put(Material.WOODEN_SWORD, 1);
        this.fuelValues.put(Material.OAK_PLANKS, 1);
        this.fuelValues.put(Material.SPRUCE_PLANKS, 1);
        this.fuelValues.put(Material.BIRCH_PLANKS, 1);
        this.fuelValues.put(Material.JUNGLE_PLANKS, 1);
        this.fuelValues.put(Material.ACACIA_PLANKS, 1);
        this.fuelValues.put(Material.DARK_OAK_PLANKS, 1);
        this.fuelValues.put(Material.CRIMSON_PLANKS, 1);
        this.fuelValues.put(Material.WARPED_PLANKS, 1);
        this.fuelValues.put(Material.OAK_LOG, 1);
        this.fuelValues.put(Material.SPRUCE_LOG, 1);
        this.fuelValues.put(Material.BIRCH_LOG, 1);
        this.fuelValues.put(Material.JUNGLE_LOG, 1);
        this.fuelValues.put(Material.ACACIA_LOG, 1);
        this.fuelValues.put(Material.DARK_OAK_LOG, 1);
        this.fuelValues.put(Material.STICK, 0);
        ConfigurationSection fuelSection = this.getConfig().getConfigurationSection("fuel-values");
        if (fuelSection != null) {
            for (String key : fuelSection.getKeys(false)) {
                try {
                    Material material = Material.valueOf((String)key.toUpperCase());
                    int value = fuelSection.getInt(key);
                    this.fuelValues.put(material, value);
                    this.getLogger().info("Loaded custom fuel value: " + key + " = " + value + " items");
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid material name in config: " + key);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onFurnaceBurn(FurnaceBurnEvent event) {
        Block block = event.getBlock();
        if (!this.isFurnaceTypeEnabled(block)) {
            return;
        }
        if (!this.maintainFuelConsumption) {
            return;
        }
        ItemStack fuel = event.getFuel();
        if (fuel == null) {
            return;
        }
        Material fuelType = fuel.getType();
        int itemsPerFuel = this.fuelValues.getOrDefault(fuelType, 1);
        this.remainingItemsForFuel.put(block, itemsPerFuel);
        this.currentFuelType.put(block, fuelType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onFurnaceSmelt(FurnaceSmeltEvent event) {
        final Block block = event.getBlock();
        if (!this.isFurnaceTypeEnabled(block)) {
            return;
        }
        if (!this.maintainFuelConsumption) {
            return;
        }
        if (this.remainingItemsForFuel.containsKey(block)) {
            int remaining = this.remainingItemsForFuel.get(block) - 1;
            if (remaining <= 0) {
                this.remainingItemsForFuel.remove(block);
                this.currentFuelType.remove(block);
                new BukkitRunnable(this){

                    public void run() {
                        if (block.getState() instanceof Furnace) {
                            Furnace furnace = (Furnace)block.getState();
                            furnace.setBurnTime((short)0);
                            furnace.update();
                        }
                    }
                }.runTaskLater((Plugin)this, 1L);
            } else {
                this.remainingItemsForFuel.put(block, remaining);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onFurnaceStartSmelt(FurnaceStartSmeltEvent event) {
        final Block block = event.getBlock();
        if (!this.isFurnaceTypeEnabled(block)) {
            return;
        }
        new BukkitRunnable(this){

            public void run() {
                if (!(block.getState() instanceof Furnace)) {
                    return;
                }
                Furnace furnace = (Furnace)block.getState();
                furnace.setCookTime((short)(furnace.getCookTimeTotal() - 1));
                furnace.update();
            }
        }.runTaskLater((Plugin)this, 1L);
    }

    private boolean isFurnaceTypeEnabled(Block block) {
        if (!(block.getState() instanceof Furnace)) {
            return false;
        }
        if (block.getState() instanceof BlastFurnace) {
            return this.enableBlastFurnace;
        }
        if (block.getState() instanceof Smoker) {
            return this.enableSmoker;
        }
        return this.enableFurnace;
    }
}

