/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.tamg;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.Map;
import java.util.function.BiConsumer;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import org.patryk3211.tamg.Networking;
import org.patryk3211.tamg.TamgClient;
import org.patryk3211.tamg.collections.ItemDisplay;
import org.patryk3211.tamg.collections.TamgEntities;
import org.patryk3211.tamg.collections.TamgItems;
import org.patryk3211.tamg.collections.TamgParticles;
import org.patryk3211.tamg.collections.TamgSoundEvents;
import org.patryk3211.tamg.config.TamgConfigs;
import org.patryk3211.tamg.data.CompactingRecipes;
import org.patryk3211.tamg.data.CuttingRecipes;
import org.patryk3211.tamg.data.SequencedAssemblyRecipes;
import org.patryk3211.tamg.data.StandardRecipes;
import org.slf4j.Logger;

@Mod(value="tamg")
public class Tamg {
    public static final String MOD_ID = "tamg";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static CreateRegistrate REGISTRATE;
    public static IEventBus modEventBus;
    private static final DeferredRegister<CreativeModeTab> TABS;

    public Tamg(FMLJavaModLoadingContext context) {
        modEventBus = context.getModEventBus();
        modEventBus.register(Tamg.class);
        LOGGER.info("Create: The Arsenal Must Grow is loading");
        REGISTRATE = CreateRegistrate.create((String)MOD_ID).setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE));
        REGISTRATE.registerEventListeners(modEventBus);
        TABS.register(modEventBus);
        TABS.register("main", () -> CreativeModeTab.builder().m_257737_(() -> TamgItems.PISTOL.asStack()).m_257501_((CreativeModeTab.DisplayItemsGenerator)new ItemDisplay.BaseItemDisplay(true)).m_257941_((Component)Component.m_237115_((String)"itemGroup.tamg.main")).m_257652_());
        REGISTRATE.addLang("itemGroup", Tamg.asResource("main"), "The Arsenal Must Grow");
        TamgSoundEvents.prepare();
        TamgItems.register();
        TamgEntities.register();
        TamgParticles.register();
        Networking.init();
        TamgParticles.PARTICLE_TYPES.register(modEventBus);
        modEventBus.addListener(TamgSoundEvents::register);
        TamgConfigs.register((ModLoadingContext)context);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> TamgClient::init);
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.m_214293_((String)MOD_ID, (String)path);
    }

    public static ResourceLocation texture(String path) {
        return Tamg.asResource("textures/" + path + ".png");
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput pack = generator.getPackOutput();
        REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            TamgSoundEvents.provideLang(langConsumer);
            Tamg.provideDefaultLang("tooltips", langConsumer);
        });
        generator.addProvider(true, (DataProvider)new SequencedAssemblyRecipes(pack));
        generator.addProvider(true, (DataProvider)new CuttingRecipes(pack));
        generator.addProvider(true, (DataProvider)new CompactingRecipes(pack));
        generator.addProvider(true, (DataProvider)new StandardRecipes(pack));
        generator.addProvider(true, TamgSoundEvents.provider(pack));
    }

    @SubscribeEvent
    public static void configLoad(ModConfigEvent.Loading event) {
        TamgConfigs.onLoad(event.getConfig());
    }

    @SubscribeEvent
    public static void configReload(ModConfigEvent.Reloading event) {
        TamgConfigs.onReload(event.getConfig());
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/tamg/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }

    static {
        TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)MOD_ID);
    }
}

