/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.tamg;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import org.patryk3211.tamg.Networking;
import org.patryk3211.tamg.Tamg;
import org.patryk3211.tamg.collections.TamgPartialModels;
import org.patryk3211.tamg.collections.TamgParticles;
import org.patryk3211.tamg.collections.TamgRenderTypes;
import org.patryk3211.tamg.gun.GunItem;
import org.patryk3211.tamg.gun.GunRenderHandler;
import org.patryk3211.tamg.gun.ZoomC2SPacket;
import org.patryk3211.tamg.gun.sniper.SniperOverlay;
import org.patryk3211.tamg.gun.sniper.SniperRifleItem;

@OnlyIn(value=Dist.CLIENT)
public class TamgClient {
    public static final GunRenderHandler GUN_RENDER_HANDLER = new GunRenderHandler();
    private static int leftUseTicks = 0;

    public static void init() {
        TamgPartialModels.load();
        TamgRenderTypes.init();
        GUN_RENDER_HANDLER.registerListeners(MinecraftForge.EVENT_BUS);
        Tamg.modEventBus.addListener(TamgClient::particleManagerRegistration);
        Tamg.modEventBus.addListener(TamgClient::overlayRegistration);
        MinecraftForge.EVENT_BUS.addListener(TamgClient::clientTick);
        MinecraftForge.EVENT_BUS.addListener(TamgClient::mouseButton);
        MinecraftForge.EVENT_BUS.addListener(TamgClient::fovModifier);
    }

    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            GUN_RENDER_HANDLER.tick();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && SniperRifleItem.isZooming((Player)player) && !Minecraft.m_91087_().f_91066_.f_92096_.m_90857_()) {
                Networking.getChannel().sendToServer((Object)new ZoomC2SPacket(false));
            }
        }
    }

    public static void mouseButton(InputEvent.MouseButton.Pre event) {
        GunItem gun;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof GunItem && (gun = (GunItem)item).hasZoom() && event.getAction() == 1 && Minecraft.m_91087_().f_91066_.f_92096_.m_90830_(event.getButton())) {
            Networking.getChannel().sendToServer((Object)new ZoomC2SPacket(true));
        }
    }

    public static void fovModifier(ComputeFovModifierEvent event) {
        if (SniperRifleItem.isZooming(event.getPlayer())) {
            event.setNewFovModifier(0.1f);
        }
    }

    public static void particleManagerRegistration(RegisterParticleProvidersEvent event) {
        TamgParticles.registerFactories(event);
    }

    public static void overlayRegistration(RegisterGuiOverlaysEvent event) {
        event.registerBelow(VanillaGuiOverlay.SPYGLASS.id(), "tamg_sniper_scope", (IGuiOverlay)new SniperOverlay(Minecraft.m_91087_()));
    }
}

